/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.synthesis.keybladeforge;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.synthesis.keybladeforge.KeybladeData;
import online.kingdomkeys.kingdomkeys.synthesis.keybladeforge.KeybladeLevel;
import online.kingdomkeys.kingdomkeys.synthesis.material.Material;

public class KeybladeDataDeserializer
implements JsonDeserializer<KeybladeData> {
    public KeybladeData deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        KeybladeData out = new KeybladeData();
        JsonObject jsonObject = json.getAsJsonObject();
        jsonObject.entrySet().forEach(entry -> {
            JsonElement element = (JsonElement)entry.getValue();
            switch ((String)entry.getKey()) {
                case "keychain": {
                    Item keychain = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(element.getAsString()));
                    if (keychain == null) break;
                    out.setKeychain(keychain);
                    break;
                }
                case "base_stats": {
                    JsonObject statsObject = element.getAsJsonObject();
                    statsObject.entrySet().forEach(statsEntry -> {
                        JsonElement statsElement = (JsonElement)statsEntry.getValue();
                        switch ((String)statsEntry.getKey()) {
                            case "str": {
                                out.setBaseStrength(statsElement.getAsInt());
                                break;
                            }
                            case "mag": {
                                out.setBaseMagic(statsElement.getAsInt());
                            }
                        }
                    });
                    break;
                }
                case "levels": {
                    if (out.keychain == null) break;
                    ArrayList<KeybladeLevel> levels = new ArrayList<KeybladeLevel>();
                    JsonArray levelsArray = element.getAsJsonArray();
                    levelsArray.forEach(e -> {
                        KeybladeLevel level = new KeybladeLevel();
                        HashMap recipe = new HashMap();
                        JsonObject levelObject = e.getAsJsonObject();
                        levelObject.entrySet().forEach(levelEntry -> {
                            JsonElement levelElement = (JsonElement)levelEntry.getValue();
                            switch ((String)levelEntry.getKey()) {
                                case "str": {
                                    level.setStrength(levelElement.getAsInt());
                                    break;
                                }
                                case "mag": {
                                    level.setMagic(levelElement.getAsInt());
                                    break;
                                }
                                case "recipe": {
                                    JsonArray recipeArray = levelElement.getAsJsonArray();
                                    recipeArray.forEach(ingredient -> {
                                        boolean valid;
                                        JsonObject ingredientObject = ingredient.getAsJsonObject();
                                        Material m = null;
                                        int quantity = 0;
                                        boolean bl = valid = ingredientObject.get("material") != null && ingredientObject.get("quantity") != null;
                                        if (valid) {
                                            m = (Material)GameRegistry.findRegistry(Material.class).getValue(new ResourceLocation(ingredientObject.get("material").getAsString()));
                                            if (m == null) {
                                                throw new JsonParseException("Material supplied in recipe cannot be found in the registry" + json);
                                            }
                                        } else {
                                            throw new JsonParseException("Invalid recipe ingredient, missing material/quantity" + json);
                                        }
                                        quantity = ingredientObject.get("quantity").getAsInt();
                                        recipe.put(m, quantity);
                                        level.setMaterials(recipe);
                                    });
                                    break;
                                }
                                case "ability": {
                                    level.setAbility(levelElement.getAsString());
                                }
                            }
                        });
                        levels.add(level);
                    });
                    out.setLevels(levels);
                    break;
                }
                case "description": {
                    out.setDescription(element.getAsString());
                }
            }
        });
        return out;
    }
}

