/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.synthesis.keybladeforge;

import java.util.Map;
import online.kingdomkeys.kingdomkeys.datagen.init.KeybladeStats;
import online.kingdomkeys.kingdomkeys.synthesis.material.Material;

public class KeybladeLevel {
    private int strength;
    private int magic;
    private Map<Material, Integer> materials;
    String ability;

    public KeybladeLevel() {
    }

    public KeybladeLevel(KeybladeLevelBuilder keybladeLevelBuilder) {
        if (keybladeLevelBuilder.ability != null) {
            this.ability = keybladeLevelBuilder.ability;
        }
        this.magic = keybladeLevelBuilder.magic;
        this.strength = keybladeLevelBuilder.strength;
        this.materials = keybladeLevelBuilder.materials;
    }

    public void setAbility(String ability) {
        this.ability = ability;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setMaterials(Map<Material, Integer> materials) {
        this.materials = materials;
    }

    public void setStrength(int strength) {
        this.strength = strength;
    }

    public String getAbility() {
        return this.ability;
    }

    public int getMagic() {
        return this.magic;
    }

    public int getStrength() {
        return this.strength;
    }

    public Map<Material, Integer> getMaterialList() {
        return this.materials;
    }

    public KeybladeLevel(int strength, int magic, Map<Material, Integer> materials, String ... abilities) {
        this.strength = strength;
        this.magic = magic;
        this.materials = materials;
        this.ability = this.ability;
    }

    public String toString() {
        return String.format("KeybladeLevel[strength:%d, magic:%d, materials[%d]]", this.strength, this.magic, this.materials.size());
    }

    public static class KeybladeLevelBuilder {
        private int strength;
        private int magic;
        private Map<Material, Integer> materials;
        private String ability;

        public KeybladeLevelBuilder withStats(int str, int mag) {
            this.strength = str;
            this.magic = mag;
            return this;
        }

        public KeybladeLevelBuilder withAbilties(String ... abilities) {
            this.ability = abilities[0];
            return this;
        }

        public KeybladeLevelBuilder withMaterials(KeybladeStats.Recipe recipe) {
            this.materials = recipe.asMap();
            return this;
        }

        public KeybladeLevel build() {
            return new KeybladeLevel(this);
        }
    }
}

