/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.synthesis.recipe;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.synthesis.material.Material;
import online.kingdomkeys.kingdomkeys.synthesis.material.ModMaterials;

public class Recipe
implements INBTSerializable<CompoundNBT> {
    @Nullable
    Map<Material, Integer> materials;
    @Nullable
    Item result;
    @Nullable
    int amount;
    @Nullable
    String type;
    ResourceLocation registryName;

    public Recipe() {
    }

    public Recipe(Map<Material, Integer> materials, Item result, int amount, String type) {
        this.materials = materials;
        this.result = result;
        this.amount = amount;
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<Material, Integer> getMaterials() {
        return this.materials;
    }

    public void setMaterials(Map<Material, Integer> materials) {
        this.materials = materials;
    }

    public Item getResult() {
        return this.result;
    }

    public void setResult(Item result, int amount) {
        this.result = result;
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("regname", this.getRegistryName().toString());
        nbt.func_74778_a("result", this.result.getRegistryName().toString());
        nbt.func_74768_a("amount", this.amount);
        nbt.func_74778_a("type", this.getType());
        nbt.func_74768_a("ingredients_size", this.materials.entrySet().size());
        AtomicInteger i = new AtomicInteger();
        this.materials.entrySet().forEach(entry -> {
            nbt.func_74778_a("ingredient_material_" + i, ((Material)((Object)((Object)entry.getKey()))).getRegistryName().toString());
            nbt.func_74768_a("ingredient_amount_" + i, ((Integer)entry.getValue()).intValue());
            i.getAndIncrement();
        });
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.setResult((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(nbt.func_74779_i("result"))), nbt.func_74762_e("amount"));
        this.setType(nbt.func_74779_i("type"));
        HashMap<Material, Integer> ingredients = new HashMap<Material, Integer>();
        for (int i = 0; i < nbt.func_74762_e("ingredients_size"); ++i) {
            ingredients.put((Material)ModMaterials.registry.getValue(new ResourceLocation(nbt.func_74779_i("ingredient_material_" + i))), nbt.func_74762_e("ingredient_amount_" + i));
        }
        this.setMaterials(ingredients);
        this.setRegistryName(nbt.func_74779_i("regname"));
    }

    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    public void setRegistryName(String registryName) {
        this.registryName = new ResourceLocation(registryName);
    }

    public void setRegistryName(String namespace, String path) {
        this.registryName = new ResourceLocation(namespace, path);
    }

    public void setRegistryName(ResourceLocation registryName) {
        this.registryName = registryName;
    }
}

