/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.synthesis.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.HashMap;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.synthesis.material.Material;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;

public class RecipeDataDeserializer
implements JsonDeserializer<Recipe> {
    public Recipe deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        Recipe out = new Recipe();
        JsonObject jsonObject = json.getAsJsonObject();
        jsonObject.entrySet().forEach(entry -> {
            JsonElement element = (JsonElement)entry.getValue();
            switch ((String)entry.getKey()) {
                case "ingredients": {
                    HashMap<Material, Integer> recipe = new HashMap<Material, Integer>();
                    JsonArray recipeArray = element.getAsJsonArray();
                    recipeArray.forEach(ingredient -> {
                        boolean valid;
                        JsonObject ingredientObject = ingredient.getAsJsonObject();
                        Material m = null;
                        int quantity = 0;
                        boolean bl = valid = ingredientObject.get("material") != null && ingredientObject.get("quantity") != null;
                        if (valid) {
                            m = (Material)GameRegistry.findRegistry(Material.class).getValue(new ResourceLocation(ingredientObject.get("material").getAsString()));
                            if (m == null) {
                                throw new JsonParseException("Material supplied in recipe cannot be found in the registry" + json);
                            }
                        } else {
                            throw new JsonParseException("Invalid recipe ingredient, missing material/quantity" + json);
                        }
                        quantity = ingredientObject.get("quantity").getAsInt();
                        recipe.put(m, quantity);
                    });
                    out.setMaterials(recipe);
                    break;
                }
                case "output": {
                    boolean valid;
                    JsonObject outputObject = element.getAsJsonObject();
                    boolean bl = valid = outputObject.get("item") != null && outputObject.get("quantity") != null;
                    if (!valid) break;
                    Item keychain = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(outputObject.get("item").getAsString()));
                    out.setResult(keychain, outputObject.get("quantity").getAsInt());
                    out.setType(outputObject.get("type").getAsString());
                }
            }
        });
        return out;
    }
}

