/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.IForgeRegistryEntry;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.IKeychain;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategoryRegistry;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.organization.OrgWeaponItem;
import online.kingdomkeys.kingdomkeys.limit.Limit;
import online.kingdomkeys.kingdomkeys.limit.ModLimits;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.synthesis.material.Material;

public class Utils {
    public static int getInt(String num) {
        try {
            int number = Integer.parseInt(num);
            return number;
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static int randomWithRange(int min, int max) {
        int range = Math.abs(max - min) + 1;
        return (int)(Math.random() * (double)range) + Math.min(min, max);
    }

    public static double randomWithRange(double min, double max) {
        double range = Math.abs(max - min);
        return Math.random() * range + Math.min(min, max);
    }

    public static float randomWithRange(float min, float max) {
        float range = Math.abs(max - min) + 1.0f;
        return (float)(Math.random() * (double)range) + Math.min(min, max);
    }

    public static String translateToLocalFormatted(String name, Object ... format) {
        TranslationTextComponent translation = new TranslationTextComponent(name, format);
        return translation.func_150254_d();
    }

    public static String translateToLocal(String name) {
        TranslationTextComponent translation = new TranslationTextComponent(name, new Object[0]);
        return translation.func_150254_d();
    }

    public static ItemStack getKeybladeDamageStack(DamageSource damageSource, PlayerEntity player) {
        switch (damageSource.field_76373_n) {
            case "player": {
                if (player.func_184614_ca() == null || !(player.func_184614_ca().func_77973_b() instanceof KeybladeItem)) break;
                return player.func_184614_ca();
            }
            case "keybladeOffhand": {
                if (player.func_184592_cb() == null || !(player.func_184592_cb().func_77973_b() instanceof KeybladeItem)) break;
                return player.func_184592_cb();
            }
        }
        return null;
    }

    public static int getDriveFormLevel(Map<String, int[]> map, String driveForm) {
        if (driveForm.equals("kingdomkeys:form_anti")) {
            return 7;
        }
        return map.get(driveForm)[0];
    }

    public static LinkedHashMap<Material, Integer> getSortedMaterials(Map<Material, Integer> materials) {
        ArrayList<Material> list = new ArrayList<Material>();
        for (Material m : materials.keySet()) {
            list.add(m);
        }
        list.sort(Comparator.comparing(Material::getMaterialName));
        LinkedHashMap<Material, Integer> map = new LinkedHashMap<Material, Integer>();
        for (Material k : list) {
            map.put(k, materials.get((Object)k));
        }
        return map;
    }

    public static LinkedHashMap<String, int[]> getSortedAbilities(LinkedHashMap<String, int[]> abilities) {
        ArrayList<IForgeRegistryEntry> list = new ArrayList<IForgeRegistryEntry>();
        for (String entry : abilities.keySet()) {
            list.add(ModAbilities.registry.getValue(new ResourceLocation(entry)));
        }
        Collections.sort(list, Comparator.comparingInt(Ability::getOrder));
        LinkedHashMap<String, int[]> map = new LinkedHashMap<String, int[]>();
        for (int i = 0; i < list.size(); ++i) {
            map.put(((Ability)((Object)list.get(i))).getRegistryName().toString(), abilities.get(((Ability)((Object)list.get(i))).getRegistryName().toString()));
        }
        return map;
    }

    public static LinkedHashMap<String, int[]> getSortedDriveForms(LinkedHashMap<String, int[]> driveFormsMap) {
        ArrayList<IForgeRegistryEntry> list = new ArrayList<IForgeRegistryEntry>();
        for (String entry : driveFormsMap.keySet()) {
            list.add(ModDriveForms.registry.getValue(new ResourceLocation(entry)));
        }
        Collections.sort(list, Comparator.comparingInt(DriveForm::getOrder));
        LinkedHashMap<String, int[]> map = new LinkedHashMap<String, int[]>();
        for (int i = 0; i < list.size(); ++i) {
            map.put(((DriveForm)((Object)list.get(i))).getRegistryName().toString(), driveFormsMap.get(((DriveForm)((Object)list.get(i))).getRegistryName().toString()));
        }
        return map;
    }

    public static List<String> getSortedMagics(List<String> list) {
        Collections.sort(list, Comparator.comparingInt(a -> ((Magic)ModMagic.registry.getValue(new ResourceLocation(a))).getOrder()));
        return list;
    }

    public static PlayerEntity getPlayerByName(World world, String name) {
        for (PlayerEntity p : world.func_217369_A()) {
            if (!p.func_145748_c_().func_150254_d().equals(name)) continue;
            return p;
        }
        return null;
    }

    public static List<PlayerEntity> getAllPlayers(MinecraftServer ms) {
        ArrayList<PlayerEntity> list = new ArrayList<PlayerEntity>();
        for (ServerWorld world : ms.func_212370_w()) {
            for (PlayerEntity p : world.func_217369_A()) {
                list.add(p);
            }
        }
        return list;
    }

    public static String getResourceName(String text) {
        return text.replaceAll("[ \\t]+$", "").replaceAll("\\s+", "_").replaceAll("[\\'\\:\\-\\,\\#]", "").replaceAll("\\&", "and").toLowerCase();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void blitScaled(AbstractGui gui, float x, float y, int u, int v, int width, int height, float scaleX, float scaleY) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)0.0f);
        RenderSystem.scalef((float)scaleX, (float)scaleY, (float)1.0f);
        gui.blit(0, 0, u, v, width, height);
        RenderSystem.popMatrix();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void blitScaled(AbstractGui gui, float x, float y, int u, int v, int width, int height, float scaleXY) {
        Utils.blitScaled(gui, x, y, u, v, width, height, scaleXY, scaleXY);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawStringScaled(AbstractGui gui, float x, float y, String text, int colour, float scaleX, float scaleY) {
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)0.0f);
        RenderSystem.scalef((float)scaleX, (float)scaleY, (float)1.0f);
        gui.drawString(Minecraft.func_71410_x().field_71466_p, text, 0, 0, colour);
        RenderSystem.popMatrix();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void drawStringScaled(AbstractGui gui, float x, float y, String text, int colour, float scaleXY) {
        Utils.drawStringScaled(gui, x, y, text, colour, scaleXY, scaleXY);
    }

    public static boolean hasID(ItemStack stack) {
        return (stack.func_77973_b() instanceof KeybladeItem || stack.func_77973_b() instanceof IKeychain) && stack.func_77978_p() != null && stack.func_77978_p().func_186855_b("keybladeID");
    }

    public static UUID getID(ItemStack stack) {
        if (Utils.hasID(stack)) {
            return stack.func_77978_p().func_186857_a("keybladeID");
        }
        return null;
    }

    public static int findSummoned(PlayerInventory inv, ItemStack chain, boolean orgWeapon) {
        if (!ItemStack.func_77989_b((ItemStack)chain, (ItemStack)ItemStack.field_190927_a)) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack slotStack = inv.func_70301_a(i);
                if (slotStack.func_77973_b() instanceof KeybladeItem) {
                    if (orgWeapon) {
                        return i;
                    }
                    if (!Utils.hasID(slotStack) || !slotStack.func_77978_p().func_186857_a("keybladeID").equals(chain.func_77978_p().func_186857_a("keybladeID"))) continue;
                    return i;
                }
                if (!(slotStack.func_77973_b() instanceof OrgWeaponItem)) continue;
                return i;
            }
        }
        return -1;
    }

    public static void swapStack(PlayerInventory inv, int stack1, int stack2) {
        ItemStack tempStack = inv.func_70301_a(stack2);
        inv.func_70299_a(stack2, inv.func_70301_a(stack1));
        inv.func_70299_a(stack1, tempStack);
    }

    public static ItemCategory getCategoryForStack(ItemStack stack) {
        ItemCategory category = ItemCategory.MISC;
        if (stack.func_77973_b() instanceof IItemCategory) {
            category = ((IItemCategory)stack.func_77973_b()).getCategory();
        } else if (ItemCategoryRegistry.hasCategory(stack.func_77973_b())) {
            category = ItemCategoryRegistry.getCategory(stack.func_77973_b());
        }
        return category;
    }

    public static int getConsumedAP(IPlayerCapabilities playerData) {
        int ap = 0;
        LinkedHashMap<String, int[]> map = playerData.getAbilityMap();
        for (Map.Entry<String, int[]> entry : map.entrySet()) {
            Ability a = (Ability)ModAbilities.registry.getValue(new ResourceLocation(entry.getKey()));
            if (entry.getValue()[1] <= 0) continue;
            ap += a.getAPCost();
        }
        return ap;
    }

    public static double getMPHasteValue(IPlayerCapabilities playerData) {
        int val = 0;
        LinkedHashMap<String, int[]> map = playerData.getAbilityMap();
        for (Map.Entry<String, int[]> entry : map.entrySet()) {
            if (!playerData.isAbilityEquipped(entry.getKey())) continue;
            switch (entry.getKey()) {
                case "kingdomkeys:ability_mp_haste": {
                    val += 2;
                    break;
                }
                case "kingdomkeys:ability_mp_hastera": {
                    val += 4;
                }
            }
        }
        return val;
    }

    public static boolean isWearingOrgRobes(PlayerEntity player) {
        boolean wearingOrgCloak = true;
        for (int i = 0; i < player.field_71071_by.field_70460_b.size(); ++i) {
            ItemStack itemStack = (ItemStack)player.field_71071_by.field_70460_b.get(i);
            if (!itemStack.func_190926_b() && itemStack.func_77973_b().getRegistryName().func_110623_a().startsWith("organization_")) continue;
            wearingOrgCloak = false;
            break;
        }
        return wearingOrgCloak;
    }

    public static int getBagCosts(int bagLevel) {
        switch (bagLevel) {
            case 0: {
                return 10000;
            }
            case 1: {
                return 20000;
            }
            case 2: {
                return 40000;
            }
        }
        return 0;
    }

    public static String snakeToCamel(String str) {
        str = str.substring(0, 1).toUpperCase() + str.substring(1);
        while (str.contains("_")) {
            str = str.replaceFirst("_[a-z]", String.valueOf(Character.toUpperCase(str.charAt(str.indexOf("_") + 1))));
        }
        str = str.substring(0, 1).toLowerCase() + str.substring(1);
        return str;
    }

    public static boolean isNumber(char c) {
        try {
            Integer.parseInt(String.valueOf(c));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static double getDouble(String num) {
        try {
            double number = Double.parseDouble(num);
            return number;
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public static int getSlotFor(PlayerInventory inv, ItemStack stack) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i).func_190926_b() || !ItemStack.func_77989_b((ItemStack)stack, (ItemStack)inv.func_70301_a(i))) continue;
            return i;
        }
        return -1;
    }

    public static float getTargetPitch(Entity entity, Entity target) {
        double xDiff = target.func_226277_ct_() - entity.func_226277_ct_();
        double yDiff = target.func_226278_cu_() - entity.func_226278_cu_();
        double zDiff = target.func_226281_cx_() - entity.func_226281_cx_();
        double distance = MathHelper.func_76133_a((double)(xDiff * xDiff + zDiff * zDiff));
        return (float)(-(MathHelper.func_181159_b((double)yDiff, (double)distance) * 57.2957763671875));
    }

    public static float getTargetYaw(Entity entity, Entity target) {
        double d0 = target.func_226277_ct_() - entity.func_226277_ct_();
        double d1 = target.func_226281_cx_() - entity.func_226281_cx_();
        return (float)(-(MathHelper.func_181159_b((double)d1, (double)d0) * 57.2957763671875)) - 90.0f;
    }

    public static List<Limit> getPlayerLimitAttacks(PlayerEntity player) {
        ArrayList<Limit> limits = new ArrayList<Limit>();
        limits.add((Limit)ModLimits.registry.getValue(new ResourceLocation("kingdomkeys:laser_circle")));
        limits.add((Limit)ModLimits.registry.getValue(new ResourceLocation("kingdomkeys:laser_dome")));
        return limits;
    }

    public static boolean isPlayerLowHP(PlayerEntity player) {
        return player.func_110143_aJ() < player.func_110138_aP() / 4.0f;
    }

    public static enum OrgMember {
        NONE,
        XEMNAS,
        XIGBAR,
        XALDIN,
        VEXEN,
        LEXAEUS,
        ZEXION,
        SAIX,
        AXEL,
        DEMYX,
        LUXORD,
        MARLUXIA,
        LARXENE,
        ROXAS;

    }

    public static class ModelAnimation {
        public ModelRenderer model;
        public ModelRenderer modelCounterpart;
        public float defVal;
        public float minVal;
        public float maxVal;
        public float actVal;
        public boolean increasing;

        public ModelAnimation(ModelRenderer model, float defVal, float minVal, float maxVal, float actVal, boolean increasing, @Nullable ModelRenderer counterpart) {
            this.model = model;
            this.defVal = defVal;
            this.minVal = minVal;
            this.maxVal = maxVal;
            this.actVal = actVal;
            this.increasing = increasing;
            this.modelCounterpart = counterpart;
        }

        public String toString() {
            return this.defVal + ": " + this.actVal + " " + this.increasing;
        }
    }
}

