/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.dimension;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.WorldGenRegion;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.block.MosaicStainedGlassBlock;
import online.kingdomkeys.kingdomkeys.block.SoAPlatformCoreBlock;
import online.kingdomkeys.kingdomkeys.entity.block.PedestalTileEntity;
import online.kingdomkeys.kingdomkeys.entity.block.SoAPlatformTileEntity;
import online.kingdomkeys.kingdomkeys.item.ModItems;

public class DiveToTheHeartChunkGenerator
extends ChunkGenerator<Config> {
    private static final BlockPos SPAWN_POS = new BlockPos(0, 25, 0);
    private static final ChunkPos SPAWN_CHUNK_POS = new ChunkPos(SPAWN_POS);
    int width = 17;
    int height = 25;
    int depth = 17;
    String topOfPlatform = "0000000000000000000000000300000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000004000000000005000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
    String structureTop = "0000011111110000000011111111111000001111111111111000111111111111111001111111111111110111111111111111111111111111111111111111111111111111111111112111111111111111111111111111111111111111111111111111111111110111111111111111001111111111111110001111111111111000001111111111100000000111111100000";
    String structureMiddle = "0000011111110000000011000000011000001000000000001000100000000000001001000000000000010110000000000000111000000000000000110000000000000001100000000000000011000000000000000110000000000000001100000000000000010100000000000001001000000000000010001000000000001000001100000001100000000111111100000";
    String structureBottom = "0000011111110000000011111111111000001111111111111000111111111111111001111111111111110111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111110111111111111111001111111111111110001111111111111000001111111111100000000111111100000";

    public DiveToTheHeartChunkGenerator(IWorld worldIn, BiomeProvider biomeProviderIn) {
        super(worldIn, biomeProviderIn, (GenerationSettings)Config.createDefault());
    }

    public void func_225551_a_(WorldGenRegion p_225551_1_, IChunk p_225551_2_) {
    }

    private static int distance(int firstX, int firstZ, int secondX, int secondZ) {
        return Math.max(Math.abs(firstX - secondX), Math.abs(firstZ - secondZ));
    }

    public int func_205470_d() {
        return 0;
    }

    public void func_222537_b(IWorld worldIn, IChunk chunkIn) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        if (DiveToTheHeartChunkGenerator.distance(chunkIn.func_76632_l().field_77276_a, chunkIn.func_76632_l().field_77275_b, DiveToTheHeartChunkGenerator.SPAWN_CHUNK_POS.field_77276_a, DiveToTheHeartChunkGenerator.SPAWN_CHUNK_POS.field_77275_b) < 1) {
            int startZ = chunkIn.func_76632_l().func_180333_d() - this.depth / 2;
            int startX = chunkIn.func_76632_l().func_180334_c() - this.width / 2;
            for (int y = 0; y < this.height; ++y) {
                for (int z = startZ; z <= chunkIn.func_76632_l().func_180333_d() + this.depth / 2; ++z) {
                    for (int x = startX; x <= chunkIn.func_76632_l().func_180334_c() + this.width / 2; ++x) {
                        blockpos$mutable.func_181079_c(x, SPAWN_POS.func_177956_o() - y, z);
                        int strucX = x - startX;
                        int strucZ = z - startZ;
                        if (y == 0) {
                            this.stateToPlace(this.topOfPlatform.charAt(strucX + strucZ * this.width), worldIn, blockpos$mutable);
                            continue;
                        }
                        if (y == 1) {
                            this.stateToPlace(this.structureTop.charAt(strucX + strucZ * this.width), worldIn, blockpos$mutable);
                            continue;
                        }
                        if (y == this.height - 1) {
                            this.stateToPlace(this.structureBottom.charAt(strucX + strucZ * this.width), worldIn, blockpos$mutable);
                            continue;
                        }
                        this.stateToPlace(this.structureMiddle.charAt(strucX + strucZ * this.width), worldIn, blockpos$mutable);
                    }
                }
            }
        }
    }

    private void stateToPlace(char c, IWorld world, BlockPos.Mutable pos) {
        switch (c) {
            case '0': {
                return;
            }
            case '1': {
                world.func_180501_a((BlockPos)pos, (BlockState)((Block)ModBlocks.mosaic_stained_glass.get()).func_176223_P().func_206870_a((IProperty)MosaicStainedGlassBlock.STRUCTURE, (Comparable)Boolean.valueOf(true)), 2);
                break;
            }
            case '2': {
                world.func_180501_a((BlockPos)pos, (BlockState)((Block)ModBlocks.station_of_awakening_core.get()).func_176223_P().func_206870_a((IProperty)SoAPlatformCoreBlock.STRUCTURE, (Comparable)Boolean.valueOf(true)), 2);
                ((SoAPlatformTileEntity)world.func_175625_s((BlockPos)pos)).setMultiblockFormed(true);
                break;
            }
            case '3': {
                this.createPedestal(world, pos, new ItemStack((IItemProvider)ModItems.dreamSword.get()));
                break;
            }
            case '4': {
                this.createPedestal(world, pos, new ItemStack((IItemProvider)ModItems.dreamShield.get()));
                break;
            }
            case '5': {
                this.createPedestal(world, pos, new ItemStack((IItemProvider)ModItems.dreamStaff.get()));
            }
        }
    }

    private void createPedestal(IWorld world, BlockPos.Mutable pos, ItemStack toDisplay) {
        world.func_180501_a((BlockPos)pos, ((Block)ModBlocks.pedestal.get()).func_176223_P(), 2);
        PedestalTileEntity te = (PedestalTileEntity)world.func_175625_s((BlockPos)pos);
        te.setStationOfAwakeningMarker(true);
        te.setDisplayStack(toDisplay);
    }

    public int func_222529_a(int x, int z, Heightmap.Type heightmapType) {
        return 0;
    }

    public static class Config
    extends GenerationSettings {
        public static Config createDefault() {
            Config config = new Config();
            config.func_214969_a(Blocks.field_150350_a.func_176223_P());
            config.func_214970_b(Blocks.field_150350_a.func_176223_P());
            return config;
        }
    }
}

