/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.world.features;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import org.apache.commons.lang3.reflect.FieldUtils;

public final class JigsawJank {
    private final OperatorRegistry registry;

    private JigsawJank(OperatorRegistry registry) {
        this.registry = registry;
    }

    public JigsawJank append(ResourceLocation name, Supplier<List<Pair<JigsawPiece, Integer>>> additionalCategoryElements) {
        this.registry.functions.put(name, pool -> this.appendPool((JigsawPattern)pool, (List)additionalCategoryElements.get()));
        return this;
    }

    private JigsawPattern appendPool(JigsawPattern pool, List<Pair<JigsawPiece, Integer>> additionalElements) {
        ResourceLocation fallback = pool.func_214948_a();
        ImmutableList elements = (ImmutableList)Objects.requireNonNull(ObfuscationReflectionHelper.getPrivateValue(JigsawPattern.class, (Object)pool, (String)"field_214952_d"), "elements");
        JigsawPattern.PlacementBehaviour placement = (JigsawPattern.PlacementBehaviour)Objects.requireNonNull(ObfuscationReflectionHelper.getPrivateValue(JigsawPattern.class, (Object)pool, (String)"field_214955_g"), "placement");
        return new JigsawPattern(pool.func_214947_b(), fallback, Stream.concat(elements.stream(), additionalElements.stream()).collect(Collectors.toList()), placement);
    }

    public static JigsawJank create() {
        JigsawPatternRegistry registry;
        Field registryField = ObfuscationReflectionHelper.findField(JigsawManager.class, (String)"field_214891_a");
        FieldUtils.removeFinalModifier((Field)registryField);
        try {
            registry = (JigsawPatternRegistry)registryField.get(null);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        OperatorRegistry operatorRegistry = new OperatorRegistry(registry);
        try {
            registryField.set(null, (Object)operatorRegistry);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        return new JigsawJank(operatorRegistry);
    }

    private static final class OperatorRegistry
    extends JigsawPatternRegistry {
        private final JigsawPatternRegistry delegate;
        private final Map<ResourceLocation, UnaryOperator<JigsawPattern>> functions;

        private OperatorRegistry(JigsawPatternRegistry delegate) {
            this.delegate = delegate;
            this.functions = new HashMap<ResourceLocation, UnaryOperator<JigsawPattern>>();
        }

        public void func_214932_a(JigsawPattern pattern) {
            if (pattern != JigsawPattern.field_214949_a) {
                this.delegate.func_214932_a((JigsawPattern)this.functions.getOrDefault(pattern.func_214947_b(), UnaryOperator.identity()).apply(pattern));
            }
        }

        public JigsawPattern func_214933_a(ResourceLocation name) {
            return this.delegate.func_214933_a(name);
        }
    }
}

