/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.util.Pair;
import net.minecraft.command.CommandSource;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPatternRegistry;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.command.DimensionCommand;
import online.kingdomkeys.kingdomkeys.command.KKDriveLevelCommand;
import online.kingdomkeys.kingdomkeys.command.KKDrivePointsCommand;
import online.kingdomkeys.kingdomkeys.command.KKExpCommand;
import online.kingdomkeys.kingdomkeys.command.KKHeartsCommand;
import online.kingdomkeys.kingdomkeys.command.KKLevelCommand;
import online.kingdomkeys.kingdomkeys.command.KKMaterialCommand;
import online.kingdomkeys.kingdomkeys.command.KKMunnyCommand;
import online.kingdomkeys.kingdomkeys.command.KKRecipeCommand;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.container.ModContainers;
import online.kingdomkeys.kingdomkeys.datagen.DataGeneration;
import online.kingdomkeys.kingdomkeys.entity.MobSpawnings;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.handler.EntityEvents;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.item.organization.OrganizationDataLoader;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.proxy.IProxy;
import online.kingdomkeys.kingdomkeys.proxy.ProxyClient;
import online.kingdomkeys.kingdomkeys.proxy.ProxyServer;
import online.kingdomkeys.kingdomkeys.synthesis.keybladeforge.KeybladeDataLoader;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeDataLoader;
import online.kingdomkeys.kingdomkeys.world.biome.ModBiomes;
import online.kingdomkeys.kingdomkeys.world.dimension.ModDimensions;
import online.kingdomkeys.kingdomkeys.world.features.ModFeatures;
import online.kingdomkeys.kingdomkeys.world.features.OreGeneration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="kingdomkeys")
public class KingdomKeys {
    public static final Logger LOGGER = LogManager.getLogger();
    public static KingdomKeys instance;
    public static final String MODID = "kingdomkeys";
    public static final String MODNAME = "Kingdom Keys";
    public static final String MODVER = "2.0.2.3";
    public static final String MCVER = "1.16.5";
    public static IProxy proxy;
    public static ItemGroup orgWeaponsGroup;
    public static ItemGroup keybladesGroup;
    public static ItemGroup miscGroup;

    public KingdomKeys() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModSounds.SOUNDS.register(modEventBus);
        ModEntities.TILE_ENTITIES.register(modEventBus);
        ModContainers.CONTAINERS.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModFeatures.FEATURES.register(modEventBus);
        ModBiomes.BIOMES.register(modEventBus);
        modEventBus.addGenericListener(Feature.class, this::registerFeatures);
        modEventBus.addListener(this::setup);
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, ModConfigs.CLIENT_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, ModConfigs.COMMON_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, ModConfigs.SERVER_SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new DataGeneration());
        MinecraftForge.EVENT_BUS.register((Object)new EntityEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ModCapabilities());
    }

    private void setup(FMLCommonSetupEvent event) {
        proxy.setup(event);
        ModCapabilities.register();
        event.enqueueWork(PacketHandler::register);
        event.enqueueWork(ModEntities::registerAttributes);
        event.enqueueWork(ModEntities::registerPlacements);
        event.enqueueWork(ModDimensions::setupDimension);
        this.addMoogleHouse();
    }

    public void addMoogleHouse() {
        this.addPieceToPattern(new ResourceLocation("village/plains/houses"), new ResourceLocation(MODID, "village/moogle_house_plains"), 2);
        this.addPieceToPattern(new ResourceLocation("village/desert/houses"), new ResourceLocation(MODID, "village/moogle_house_desert"), 2);
        this.addPieceToPattern(new ResourceLocation("village/savanna/houses"), new ResourceLocation(MODID, "village/moogle_house_savanna"), 2);
        this.addPieceToPattern(new ResourceLocation("village/snowy/houses"), new ResourceLocation(MODID, "village/moogle_house_snowy"), 2);
        this.addPieceToPattern(new ResourceLocation("village/taiga/houses"), new ResourceLocation(MODID, "village/moogle_house_taiga"), 2);
    }

    public void addPieceToPattern(ResourceLocation pattern, ResourceLocation structure, int weight) {
        RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243555_ax, (ResourceLocation)pattern);
        JigsawPattern pat = (JigsawPattern)WorldGenRegistries.field_243656_h.func_230516_a_(key);
        pat.field_214952_d.add(Pair.of(JigsawPiece.func_242849_a((String)structure.toString()).apply(JigsawPattern.PlacementBehaviour.RIGID), (Object)weight));
        JigsawPatternRegistry.func_244094_a((JigsawPattern)pat);
    }

    @SubscribeEvent
    public void serverStarting(FMLServerStartingEvent event) {
        CommandDispatcher dispatcher = event.getServer().func_195571_aL().func_197054_a();
        KKMunnyCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        KKRecipeCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        KKMaterialCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        KKLevelCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        KKDriveLevelCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        KKExpCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        DimensionCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        KKHeartsCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        KKDrivePointsCommand.register((CommandDispatcher<CommandSource>)dispatcher);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void addToBiome(BiomeLoadingEvent event) {
        MobSpawnings.registerSpawns(event);
        OreGeneration.generateOre(event);
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void removeFromBiome(BiomeLoadingEvent event) {
        MobSpawnings.removeSpawns(event);
    }

    @SubscribeEvent
    public void addReloadListeners(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)new KeybladeDataLoader());
        event.addListener((IFutureReloadListener)new OrganizationDataLoader());
        event.addListener((IFutureReloadListener)new RecipeDataLoader());
    }

    public void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        ModFeatures.register();
        ModFeatures.registerConfiguredFeatures();
    }

    static {
        proxy = (IProxy)DistExecutor.safeRunForDist(() -> ProxyClient::new, () -> ProxyServer::new);
        orgWeaponsGroup = new ItemGroup("kingdomkeys_org_weapons"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)ModItems.eternalFlames.get());
            }
        };
        keybladesGroup = new ItemGroup("kingdomkeys_keyblades"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)ModItems.kingdomKey.get());
            }
        };
        miscGroup = new ItemGroup("kingdomkeys_misc"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)ModBlocks.normalBlox.get());
            }
        };
    }
}

