/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.api.item;

import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.AxeItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ElytraItem;
import net.minecraft.item.HoeItem;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.PickaxeItem;
import net.minecraft.item.PotionItem;
import net.minecraft.item.ShovelItem;
import net.minecraft.item.SwordItem;
import net.minecraft.tags.Tag;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;

public class ItemCategoryRegistry {
    public static HashMap<String, ItemCategory> categories = new HashMap();

    public static void register(Item item, ItemCategory category) {
        categories.put(item.getRegistryName().toString(), category);
    }

    public static void register(Block block, ItemCategory category) {
        categories.put(block.getRegistryName().toString(), category);
    }

    public static <T extends IForgeRegistryEntry<T>> void register(Tag<T> tag, ItemCategory category) {
        tag.func_230236_b_().forEach(t -> categories.put(t.getRegistryName().toString(), category));
    }

    public static boolean hasCategory(Item item) {
        return categories.containsKey(item.getRegistryName().toString());
    }

    public static ItemCategory getCategory(Item item) {
        return categories.get(item.getRegistryName().toString());
    }

    static {
        ForgeRegistries.BLOCKS.forEach(block -> ItemCategoryRegistry.register(block, ItemCategory.BUILDING));
        ForgeRegistries.ITEMS.forEach(item -> {
            if (item instanceof SwordItem || item instanceof PickaxeItem || item instanceof ShovelItem || item instanceof HoeItem || item instanceof AxeItem || item instanceof CrossbowItem || item instanceof BowItem) {
                ItemCategoryRegistry.register(item, ItemCategory.TOOL);
            } else if (item.func_219971_r() || item instanceof PotionItem) {
                ItemCategoryRegistry.register(item, ItemCategory.CONSUMABLE);
            } else if (item instanceof ArmorItem || item instanceof ElytraItem) {
                ItemCategoryRegistry.register(item, ItemCategory.EQUIPMENT);
            }
        });
        ItemCategoryRegistry.register(Items.field_151033_d, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Items.field_151097_aZ, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Items.field_151111_aL, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Items.field_151113_aN, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Items.field_151112_aM, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Items.field_151058_ca, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Items.field_151148_bJ, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Items.field_151098_aY, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Blocks.field_150335_W, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Blocks.field_150478_aa, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Items.field_151133_ar, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Items.field_151131_as, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Items.field_151129_at, ItemCategory.TOOL);
        ItemCategoryRegistry.register(Items.field_203184_eO, ItemCategory.TOOL);
    }
}

