/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import online.kingdomkeys.kingdomkeys.block.BaseBlock;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.block.BlastBloxEntity;
import online.kingdomkeys.kingdomkeys.util.SetBlockStateFlags;

public class BlastBloxBlock
extends BaseBlock {
    private static final VoxelShape collisionShape = Block.func_208617_a((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);

    public BlastBloxBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c() && worldIn.func_175640_z(pos)) {
            this.explode(worldIn, pos);
            worldIn.func_217377_a(pos, false);
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.func_175640_z(pos)) {
            this.explode(worldIn, pos);
            worldIn.func_217377_a(pos, false);
        }
    }

    public void func_176208_a(World worldIn, BlockPos pos, BlockState state, PlayerEntity player) {
        if (!worldIn.func_201670_d() && !player.func_184812_l_() && player.func_184614_ca().func_77973_b() != Items.field_151008_G) {
            this.explode(worldIn, pos);
        }
        super.func_176208_a(worldIn, pos, state, player);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        super.func_180652_a(worldIn, pos, explosionIn);
    }

    public void explode(World world, BlockPos pos) {
        this.explode(world, pos, null);
    }

    private void explode(World world, BlockPos pos, @Nullable LivingEntity igniter) {
        if (!world.field_72995_K) {
            BlastBloxEntity entity = new BlastBloxEntity((EntityType)ModEntities.TYPE_BLAST_BLOX.get(), world, (float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f, igniter);
            world.func_217376_c((Entity)entity);
            world.func_184148_a((PlayerEntity)null, (double)entity.func_233580_cy_().func_177958_n(), (double)entity.func_233580_cy_().func_177956_o(), (double)entity.func_233580_cy_().func_177952_p(), SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public void func_196270_a(BlockState state, World worldIn, BlockPos pos, PlayerEntity player) {
        ItemStack held = player.func_184614_ca();
        Item item = held.func_77973_b();
        if (item != Items.field_151008_G) {
            this.explode(worldIn, pos, (LivingEntity)player);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), SetBlockStateFlags.BLOCK_UPDATE.getValue() | SetBlockStateFlags.SEND_TO_CLIENT.getValue() | SetBlockStateFlags.RERENDER_ON_MAIN.getValue());
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        Item item = stack.func_77973_b();
        if (item != Items.field_151033_d && item != Items.field_151059_bz) {
            return super.func_225533_a_(state, worldIn, pos, player, hand, hit);
        }
        this.explode(worldIn, pos, (LivingEntity)player);
        worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), SetBlockStateFlags.BLOCK_UPDATE.getValue() | SetBlockStateFlags.SEND_TO_CLIENT.getValue() | SetBlockStateFlags.RERENDER_ON_MAIN.getValue());
        if (item == Items.field_151033_d) {
            stack.func_222118_a(1, (LivingEntity)player, consumer -> consumer.func_213334_d(hand));
        } else {
            stack.func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.field_72995_K) {
            this.explode(worldIn, pos, entityIn instanceof LivingEntity ? (LivingEntity)entityIn : null);
            worldIn.func_217377_a(pos, false);
        }
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return collisionShape;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        this.explode(worldIn, pos, entityIn instanceof LivingEntity ? (LivingEntity)entityIn : null);
        worldIn.func_217377_a(pos, false);
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }
}

