/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.DirectionProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.block.MagicalChestTileEntity;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MagicalChestBlock
extends ContainerBlock {
    public static final DirectionProperty FACING = BlockStateProperties.field_208155_H;
    public static final BooleanProperty BIG = BooleanProperty.func_177716_a((String)"big");
    private static final VoxelShape collisionShapeEW = Block.func_208617_a((double)2.0, (double)0.0, (double)1.0, (double)14.0, (double)12.0, (double)15.0);
    private static final VoxelShape collisionShapeNS = Block.func_208617_a((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)12.0, (double)14.0);

    public MagicalChestBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((Property)BIG, (Comparable)Boolean.valueOf(false)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new TranslationTextComponent("Can be locked with a keyblade"));
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)FACING, (Comparable)context.func_195992_f().func_176734_d())).func_206870_a((Property)BIG, (Comparable)Boolean.valueOf(false));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{FACING, BIG});
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, world, pos, context);
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        MagicalChestTileEntity te;
        if (state.hasTileEntity() && worldIn.func_175625_s(pos) instanceof MagicalChestTileEntity && (te = (MagicalChestTileEntity)worldIn.func_175625_s(pos)) != null) {
            PlayerEntity player = (PlayerEntity)placer;
            te.setOwner(player.func_146103_bH().getId());
            player.func_146105_b((ITextComponent)new TranslationTextComponent("message.chest.lock"), true);
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        INamedContainerProvider namedContainerProvider = this.func_220052_b(state, worldIn, pos);
        if (namedContainerProvider != null) {
            MagicalChestTileEntity te;
            if (!(player instanceof ServerPlayerEntity)) {
                return ActionResultType.FAIL;
            }
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)player;
            if (state.hasTileEntity() && worldIn.func_175625_s(pos) instanceof MagicalChestTileEntity && (te = (MagicalChestTileEntity)worldIn.func_175625_s(pos)) != null) {
                UUID keyblade = te.getKeyblade();
                ItemStack held = player.func_184586_b(handIn);
                if (held.func_77973_b() instanceof KeybladeItem) {
                    UUID heldID = Utils.getID(held);
                    if (heldID != null) {
                        if (keyblade != null) {
                            if (heldID.equals(keyblade)) {
                                NetworkHooks.openGui((ServerPlayerEntity)serverPlayerEntity, (INamedContainerProvider)namedContainerProvider, buf -> buf.func_179255_a(pos));
                            } else {
                                player.func_146105_b((ITextComponent)new TranslationTextComponent("message.chest.locked"), true);
                            }
                        } else {
                            te.setKeyblade(heldID);
                            player.func_146105_b((ITextComponent)new TranslationTextComponent("message.chest.keyblade_set"), true);
                        }
                    } else if (keyblade == null) {
                        NetworkHooks.openGui((ServerPlayerEntity)serverPlayerEntity, (INamedContainerProvider)namedContainerProvider, buf -> buf.func_179255_a(pos));
                    }
                } else {
                    if (keyblade == null) {
                        NetworkHooks.openGui((ServerPlayerEntity)serverPlayerEntity, (INamedContainerProvider)namedContainerProvider, buf -> buf.func_179255_a(pos));
                        return ActionResultType.SUCCESS;
                    }
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.chest.locked"), true);
                }
            }
        }
        return super.func_225533_a_(state, worldIn, pos, player, handIn, hit);
    }

    @Deprecated
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b((Property)FACING) == Direction.NORTH || state.func_177229_b((Property)FACING) == Direction.SOUTH) {
            return collisionShapeNS;
        }
        return collisionShapeEW;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c()) {
            world.func_175625_s(pos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
                for (int i = 0; i < inv.getSlots(); ++i) {
                    MagicalChestBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)inv.getStackInSlot(i));
                }
            });
            world.func_175713_t(pos);
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.func_196283_a_(world);
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return ((TileEntityType)ModEntities.TYPE_MAGICAL_CHEST.get()).func_200968_a();
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onBlockBreak(BlockEvent.BreakEvent event) {
            MagicalChestTileEntity te;
            if (event.getState().func_177230_c() == ModBlocks.magicalChest.get() && event.getState().hasTileEntity() && (te = (MagicalChestTileEntity)event.getWorld().func_175625_s(event.getPos())) != null && !te.getOwner().equals(event.getPlayer().func_146103_bH().getId()) && te.getKeyblade() != null && event.getPlayer() != null && !event.getPlayer().func_184812_l_()) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock event) {
            ItemStack held;
            PlayerEntity player = event.getPlayer();
            if (player.func_213453_ef() && (held = player.func_184586_b(event.getHand())).func_77973_b() instanceof KeybladeItem) {
                UUID heldID;
                MagicalChestTileEntity te;
                BlockPos pos = event.getPos();
                World world = event.getWorld();
                BlockState state = world.func_180495_p(pos);
                if (state.func_177230_c() == ModBlocks.magicalChest.get() && (te = (MagicalChestTileEntity)world.func_175625_s(pos)) != null && te.getKeyblade() != null && (heldID = Utils.getID(held)).equals(te.getKeyblade())) {
                    te.setKeyblade(null);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("message.chest.unlocked"), true);
                }
            }
        }
    }
}

