/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import online.kingdomkeys.kingdomkeys.block.BaseBlock;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.block.OrgPortalTileEntity;
import online.kingdomkeys.kingdomkeys.lib.PortalData;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCShowOrgPortalGUI;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class OrgPortalBlock
extends BaseBlock {
    public OrgPortalBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return ((TileEntityType)ModEntities.TYPE_ORG_PORTAL_TE.get()).func_200968_a();
    }

    public void func_180633_a(World worldIn, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (!worldIn.field_72995_K && placer instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)placer;
            OrgPortalTileEntity te = (OrgPortalTileEntity)worldIn.func_175625_s(pos);
            IWorldCapabilities worldData = ModCapabilities.getWorld(worldIn);
            List<UUID> portals = worldData.getAllPortalsFromOwnerID(player.func_110124_au());
            if (portals.size() < 3) {
                UUID portalUUID = UUID.randomUUID();
                worldData.addPortal(portalUUID, new PortalData(portalUUID, "Portal", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), (RegistryKey<World>)player.field_70170_p.func_234923_W_(), player.func_110124_au()));
                Utils.syncWorldData(worldIn, worldData);
                player.func_146105_b((ITextComponent)new TranslationTextComponent(TextFormatting.GREEN + "This is now your portal"), true);
                te.setUUID(portalUUID);
                te.func_70296_d();
                PacketHandler.sendTo(new SCShowOrgPortalGUI(te.func_174877_v()), (ServerPlayerEntity)player);
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent(TextFormatting.RED + "You have no empty slots for portals"), true);
            }
        }
        super.func_180633_a(worldIn, pos, state, placer, stack);
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!worldIn.field_72995_K && ModCapabilities.getPlayer(player).getAlignment() != Utils.OrgMember.NONE && worldIn.func_175625_s(pos) instanceof OrgPortalTileEntity) {
            OrgPortalTileEntity te = (OrgPortalTileEntity)worldIn.func_175625_s(pos);
            IWorldCapabilities worldData = ModCapabilities.getWorld(worldIn);
            if (te.getUUID() != null) {
                if (worldData.getOwnerIDFromUUID(te.getUUID()).equals(player.func_110124_au())) {
                    List<UUID> portals = worldData.getAllPortalsFromOwnerID(player.func_110124_au());
                    int i = 0;
                    for (i = 0; i < portals.size() && !portals.get(i).equals(te.getUUID()); i = (int)((byte)(i + 1))) {
                    }
                    PacketHandler.sendTo(new SCShowOrgPortalGUI(te.func_174877_v()), (ServerPlayerEntity)player);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent(TextFormatting.YELLOW + "This is your portal " + (i + 1) + ": " + worldData.getPortalFromUUID(portals.get(i)).getName()), true);
                } else {
                    player.func_146105_b((ITextComponent)new TranslationTextComponent(TextFormatting.RED + "This portal belongs to " + worldIn.func_217371_b(worldData.getOwnerIDFromUUID(te.getUUID())).func_145748_c_().getString()), true);
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!worldIn.field_72995_K && worldIn.func_175625_s(pos) instanceof OrgPortalTileEntity) {
            OrgPortalTileEntity te = (OrgPortalTileEntity)worldIn.func_175625_s(pos);
            UUID portalID = te.getUUID();
            te.func_145843_s();
            if (portalID != null) {
                IWorldCapabilities worldData = ModCapabilities.getWorld(worldIn);
                UUID ownerUUID = worldData.getOwnerIDFromUUID(portalID);
                ModCapabilities.getWorld(worldIn).removePortal(portalID);
                ServerPlayerEntity player = worldIn.func_73046_m().func_184103_al().func_177451_a(ownerUUID);
                if (player != null) {
                    Utils.syncWorldData(worldIn, worldData);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent(TextFormatting.RED + "Portal destination disappeared"), true);
                }
            }
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
    }
}

