/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.capability;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.api.item.IKeychain;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.item.KKPotionItem;
import online.kingdomkeys.kingdomkeys.lib.LevelStats;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCShowOverlayPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.reactioncommands.ModReactionCommands;
import online.kingdomkeys.kingdomkeys.reactioncommands.ReactionCommand;
import online.kingdomkeys.kingdomkeys.shotlock.ModShotlocks;
import online.kingdomkeys.kingdomkeys.shotlock.Shotlock;
import online.kingdomkeys.kingdomkeys.synthesis.material.Material;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class PlayerCapabilities
implements IPlayerCapabilities {
    private int level = 1;
    private int exp = 0;
    private int expGiven = 0;
    private int strength = 1;
    private int magic = 1;
    private int defense = 1;
    private int maxHp = 20;
    private int remainingExp = 0;
    private int maxAP = 10;
    private int aeroTicks = 0;
    private int aeroLevel = 0;
    private int reflectTicks = 0;
    private int reflectLevel = 0;
    private int magicCooldown = 0;
    private int munny = 0;
    private int antipoints = 0;
    private int aerialDodgeTicks;
    private String driveForm = DriveForm.NONE.toString();
    LinkedHashMap<String, int[]> driveForms = new LinkedHashMap();
    LinkedHashMap<String, Integer> magicList = new LinkedHashMap();
    List<String> shotlockList = new ArrayList<String>();
    List<Integer> shotlockEnemies;
    List<ResourceLocation> recipeList = new ArrayList<ResourceLocation>();
    LinkedHashMap<String, int[]> abilityMap = new LinkedHashMap();
    private TreeMap<String, Integer> materials = new TreeMap();
    List<String> reactionList = new ArrayList<String>();
    List<String> partyList = new ArrayList<String>();
    String equippedShotlock = "";
    private double mp = 0.0;
    private double maxMP = 0.0;
    private double dp = 0.0;
    private double maxDP = 1000.0;
    private double fp = 0.0;
    private double focus = 100.0;
    private double maxFocus = 100.0;
    private boolean recharge;
    private boolean reflectActive;
    private boolean isGliding;
    private boolean hasJumpedAerealDodge = false;
    private Vector3d returnPos = Vector3d.field_186680_a;
    private RegistryKey<World> returnDim = World.field_234918_g_;
    SoAState soAState = SoAState.NONE;
    SoAState choice = SoAState.NONE;
    SoAState sacrifice = SoAState.NONE;
    private BlockPos choicePedestal = new BlockPos(0, 0, 0);
    private BlockPos sacrificePedestal = new BlockPos(0, 0, 0);
    private List<String> messages = new ArrayList<String>();
    private List<String> dfMessages = new ArrayList<String>();
    private Utils.OrgMember alignment = Utils.OrgMember.NONE;
    private int hearts = 0;
    private Set<ItemStack> weaponUnlocks = new HashSet<ItemStack>();
    private int limitCooldownTicks = 0;
    private ItemStack equippedWeapon = ItemStack.field_190927_a;
    private Map<ResourceLocation, ItemStack> equippedKeychains = new HashMap<ResourceLocation, ItemStack>();
    private Map<Integer, ItemStack> equippedItems = new HashMap<Integer, ItemStack>();

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public int getExperience() {
        return this.exp;
    }

    @Override
    public void setExperience(int exp) {
        this.exp = exp;
    }

    @Override
    public void addExperience(PlayerEntity player, int exp, boolean shareXP) {
        if (player != null && this.level < 100) {
            Party party = ModCapabilities.getWorld(player.field_70170_p).getPartyFromMember(player.func_110124_au());
            if (party != null && shareXP) {
                double sharedXP = (double)exp * (ModConfigs.partyXPShare / 100.0 * 2.0);
                if (sharedXP > 0.0) {
                    for (Party.Member member : party.getMembers()) {
                        for (RegistryKey worldKey : player.field_70170_p.func_73046_m().func_240770_D_()) {
                            PlayerEntity ally = player.func_184102_h().func_71218_a(worldKey).func_217371_b(member.getUUID());
                            if (ally == null || ally == player) continue;
                            ModCapabilities.getPlayer(ally).addExperience(ally, (int)sharedXP, false);
                            PacketHandler.sendTo(new SCSyncCapabilityPacket(ModCapabilities.getPlayer(ally)), (ServerPlayerEntity)ally);
                        }
                    }
                }
                if (this.getEquippedAbilityLevel("kingdomkeys:ability_experience_boost")[1] > 0 && player.func_110143_aJ() <= player.func_110138_aP() / 2.0f) {
                    exp *= 2;
                }
                this.exp += exp;
            } else {
                if (this.getEquippedAbilityLevel("kingdomkeys:ability_experience_boost")[1] > 0 && player.func_110143_aJ() <= player.func_110138_aP() / 2.0f && shareXP) {
                    exp *= 2;
                }
                this.exp += exp;
            }
            while (this.getExpNeeded(this.getLevel(), this.exp) <= 0 && this.getLevel() != 100) {
                this.setLevel(this.getLevel() + 1);
                this.levelUpStatsAndDisplayMessage(player);
                PacketHandler.sendTo(new SCShowOverlayPacket("levelup"), (ServerPlayerEntity)player);
            }
            PacketHandler.sendTo(new SCShowOverlayPacket("exp"), (ServerPlayerEntity)player);
        }
    }

    @Override
    public int getExperienceGiven() {
        return this.expGiven;
    }

    @Override
    public void setExperienceGiven(int exp) {
        this.expGiven = exp;
    }

    @Override
    public int getStrength() {
        return this.strength;
    }

    @Override
    public void setStrength(int level) {
        this.strength = level;
    }

    @Override
    public int getMagic() {
        return this.magic;
    }

    @Override
    public void setMagic(int level) {
        this.magic = level;
    }

    @Override
    public int getDefense() {
        return this.defense;
    }

    @Override
    public void setDefense(int level) {
        this.defense = level;
    }

    @Override
    public int getExpNeeded(int level, int currentExp) {
        int needed;
        if (level == 100) {
            return 0;
        }
        double nextLevel = ((double)level + 1.0 + 300.0 * Math.pow(2.0, ((double)level + 1.0) / 7.0)) * (((double)level + 1.0) * 0.25);
        this.remainingExp = needed = (int)nextLevel - currentExp;
        return this.remainingExp;
    }

    @Override
    public void addStrength(int str) {
        this.strength += str;
        this.messages.add("stats.levelUpStr");
    }

    @Override
    public void addMagic(int mag) {
        this.magic += mag;
        this.messages.add("stats.levelUpMag");
    }

    @Override
    public void addDefense(int def) {
        this.defense += def;
        this.messages.add("stats.levelUpDef");
    }

    @Override
    public int getMaxHP() {
        return this.maxHp;
    }

    @Override
    public void setMaxHP(int hp) {
        this.maxHp = hp;
    }

    @Override
    public void addMaxHP(int hp) {
        this.maxHp += hp;
        this.messages.add("stats.levelUpHP");
    }

    @Override
    public int getMaxAP() {
        return this.maxAP;
    }

    @Override
    public void setMaxAP(int ap) {
        this.maxAP = ap;
    }

    @Override
    public void addMaxAP(int ap) {
        this.maxAP += ap;
        this.messages.add("stats.levelUpAP");
    }

    @Override
    public List<String> getMessages() {
        return this.messages;
    }

    @Override
    public void clearMessages() {
        this.getMessages().clear();
    }

    @Override
    public List<String> getDFMessages() {
        return this.dfMessages;
    }

    @Override
    public void clearDFMessages() {
        this.getDFMessages().clear();
    }

    @Override
    public void setDFMessages(List<String> messages) {
        this.dfMessages = messages;
    }

    @Override
    public void levelUpStatsAndDisplayMessage(PlayerEntity player) {
        this.getMessages().clear();
        LevelStats.applyStatsForLevel(this.level, player, this);
        player.field_70170_p.func_184133_a((PlayerEntity)null, player.func_233580_cy_(), (SoundEvent)ModSounds.levelup.get(), SoundCategory.MASTER, 0.5f, 1.0f);
        player.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)this.getMaxHP());
        PacketHandler.sendTo(new SCSyncCapabilityPacket(ModCapabilities.getPlayer(player)), (ServerPlayerEntity)player);
        PacketHandler.syncToAllAround(player, this);
    }

    @Override
    public void setMessages(List<String> messages) {
        this.messages = messages;
    }

    @Override
    public void displayDriveFormLevelUpMessage(PlayerEntity player, String driveForm) {
        String name;
        Ability a;
        this.getMessages().clear();
        this.getDFMessages().clear();
        this.dfMessages.add("stats.levelUpFG");
        DriveForm form = (DriveForm)ModDriveForms.registry.getValue(new ResourceLocation(driveForm));
        String driveformAbility = form.getDFAbilityForLevel(this.getDriveFormLevel(driveForm));
        String baseAbility = form.getBaseAbilityForLevel(this.getDriveFormLevel(driveForm));
        if (!driveformAbility.equals("")) {
            a = (Ability)ModAbilities.registry.getValue(new ResourceLocation(driveformAbility));
            name = a.getTranslationKey();
            if (a.getType() == Ability.AbilityType.GROWTH) {
                int level = this.getEquippedAbilityLevel(driveformAbility)[0] + 2;
                name = new StringBuilder(name).insert(name.lastIndexOf(46), "_" + level).toString();
            }
            this.dfMessages.add("A_" + name);
        }
        if (!baseAbility.equals("")) {
            a = (Ability)ModAbilities.registry.getValue(new ResourceLocation(baseAbility));
            name = a.getTranslationKey();
            if (a.getType() == Ability.AbilityType.GROWTH) {
                name = new StringBuilder(name).insert(name.lastIndexOf(46), "_" + (this.getEquippedAbilityLevel(baseAbility)[0] + 1)).toString();
            }
            this.addAbility(baseAbility, name);
        }
        player.field_70170_p.func_184133_a((PlayerEntity)null, player.func_233580_cy_(), (SoundEvent)ModSounds.levelup.get(), SoundCategory.MASTER, 0.5f, 1.0f);
        PacketHandler.sendTo(new SCShowOverlayPacket("drivelevelup", driveForm), (ServerPlayerEntity)player);
    }

    @Override
    public double getDP() {
        return this.dp;
    }

    @Override
    public void setDP(double dp) {
        this.dp = dp;
    }

    @Override
    public void addDP(double dp) {
        this.dp = Math.min(this.dp + dp, this.maxDP);
    }

    @Override
    public void remDP(double dp) {
        this.dp -= dp;
    }

    @Override
    public double getMaxDP() {
        return this.maxDP;
    }

    @Override
    public void setMaxDP(double dp) {
        this.maxDP = Math.min(this.maxDP + dp, 1000.0);
    }

    @Override
    public double getFP() {
        return this.fp;
    }

    @Override
    public void setFP(double fp) {
        this.fp = fp;
    }

    @Override
    public void addFP(double fp) {
        double max = 200 + Utils.getDriveFormLevel(this.getDriveFormMap(), this.getActiveDriveForm()) * 100;
        this.fp = Math.min(this.fp + fp, max);
    }

    @Override
    public void remFP(double cost) {
        this.fp -= this.fp;
    }

    @Override
    public void setActiveDriveForm(String form) {
        this.driveForm = form;
    }

    @Override
    public String getActiveDriveForm() {
        return this.driveForm;
    }

    @Override
    public LinkedHashMap<String, int[]> getDriveFormMap() {
        return this.driveForms;
    }

    @Override
    public void setDriveFormMap(LinkedHashMap<String, int[]> map) {
        this.driveForms = map;
    }

    @Override
    public int getDriveFormLevel(String name) {
        return this.driveForms.containsKey(name) ? this.driveForms.get(name)[0] : 0;
    }

    @Override
    public void setDriveFormLevel(String name, int level) {
        DriveForm form = (DriveForm)ModDriveForms.registry.getValue(new ResourceLocation(name));
        if (level <= form.getMaxLevel()) {
            int experience = form.getLevelUpCost(level);
            this.driveForms.put(name, new int[]{level, experience});
        }
    }

    @Override
    public int getDriveFormExp(String name) {
        return this.driveForms.get(name)[1];
    }

    @Override
    public void setDriveFormExp(PlayerEntity player, String name, int exp) {
        DriveForm form = (DriveForm)ModDriveForms.registry.getValue(new ResourceLocation(name));
        int oldLevel = this.getDriveFormLevel(name);
        int driveLevel = form.getLevelFromExp(exp);
        if (driveLevel <= form.getMaxLevel()) {
            this.driveForms.put(name, new int[]{driveLevel, exp});
            if (driveLevel > oldLevel) {
                this.displayDriveFormLevelUpMessage(player, name);
                if (driveLevel == form.getMaxLevel()) {
                    this.setMaxDP(this.getMaxDP() + 100.0);
                }
                PacketHandler.sendTo(new SCSyncCapabilityPacket(this), (ServerPlayerEntity)player);
            }
        }
    }

    @Override
    public void addDriveFormExperience(String drive, ServerPlayerEntity player, int value) {
        DriveForm form = (DriveForm)ModDriveForms.registry.getValue(new ResourceLocation(drive));
        int oldLevel = this.getDriveFormLevel(drive);
        int driveLevel = form.getLevelFromExp(this.exp + value);
        if (driveLevel <= form.getMaxLevel()) {
            this.driveForms.put(drive, new int[]{driveLevel, this.exp + value});
            if (driveLevel > oldLevel) {
                this.displayDriveFormLevelUpMessage((PlayerEntity)player, drive);
                if (driveLevel == form.getMaxLevel()) {
                    this.setMaxDP(this.getMaxDP() + 100.0);
                }
                PacketHandler.sendTo(new SCSyncCapabilityPacket(this), player);
            }
        }
    }

    @Override
    public int getAntiPoints() {
        return this.antipoints;
    }

    @Override
    public void setAntiPoints(int points) {
        this.antipoints = points;
    }

    @Override
    public double getMP() {
        return this.mp;
    }

    @Override
    public void setMP(double mp) {
        this.mp = mp;
    }

    @Override
    public void addMP(double mp) {
        this.mp = Math.min(this.mp + mp, this.maxMP);
    }

    @Override
    public double getMaxMP() {
        return this.maxMP;
    }

    @Override
    public void setMaxMP(double mp) {
        this.maxMP = mp;
    }

    @Override
    public void addMaxMP(double mp) {
        this.maxMP += mp;
        this.messages.add("stats.levelUpMP");
    }

    @Override
    public void remMP(double amount) {
        this.mp = Math.max(this.mp - amount, 0.0);
    }

    @Override
    public double getFocus() {
        return this.focus;
    }

    @Override
    public void setFocus(double focus) {
        this.focus = focus;
    }

    @Override
    public void addFocus(double focus) {
        this.focus = Math.min(this.focus + focus, this.getMaxFocus());
    }

    @Override
    public void remFocus(double cost) {
        this.focus = Math.max(this.focus - cost, 0.0);
    }

    @Override
    public double getMaxFocus() {
        return this.maxFocus;
    }

    @Override
    public void setMaxFocus(double maxFocus) {
        this.maxFocus = maxFocus;
    }

    @Override
    public void addMaxFocus(double focus) {
        this.focus += focus;
    }

    @Override
    public void setShotlockEnemies(List<Integer> list) {
        this.shotlockEnemies = list;
    }

    @Override
    public List<Integer> getShotlockEnemies() {
        return this.shotlockEnemies;
    }

    @Override
    public void addShotlockEnemy(Integer entity) {
        this.shotlockEnemies.add(entity);
    }

    @Override
    public void setRecharge(boolean b) {
        this.recharge = b;
    }

    @Override
    public boolean getRecharge() {
        return this.recharge;
    }

    @Override
    public int getAeroLevel() {
        return this.aeroLevel;
    }

    @Override
    public void setAeroLevel(int level) {
        this.aeroLevel = level;
    }

    @Override
    public int getAeroTicks() {
        return this.aeroTicks;
    }

    @Override
    public void setAeroTicks(int i, int level) {
        this.aeroTicks = i;
        this.aeroLevel = level;
    }

    @Override
    public void remAeroTicks(int ticks) {
        this.aeroTicks -= ticks;
    }

    @Override
    public int getReflectLevel() {
        return this.reflectLevel;
    }

    @Override
    public void setReflectLevel(int level) {
        this.reflectLevel = level;
    }

    @Override
    public void setReflectTicks(int ticks, int level) {
        this.reflectTicks = ticks;
        this.reflectLevel = level;
    }

    @Override
    public void remReflectTicks(int ticks) {
        this.reflectTicks -= ticks;
    }

    @Override
    public int getReflectTicks() {
        return this.reflectTicks;
    }

    @Override
    public void setReflectActive(boolean active) {
        this.reflectActive = active;
    }

    @Override
    public boolean getReflectActive() {
        return this.reflectActive;
    }

    @Override
    public LinkedHashMap<String, Integer> getMagicsMap() {
        return this.magicList;
    }

    @Override
    public void setMagicsMap(LinkedHashMap<String, Integer> map) {
        this.magicList = map;
    }

    @Override
    public int getMagicLevel(String name) {
        return this.magicList.containsKey(name) ? this.magicList.get(name) : 0;
    }

    @Override
    public void setMagicLevel(String name, int level) {
        Magic magic = (Magic)ModMagic.registry.getValue(new ResourceLocation(name));
        if (level <= magic.getMaxLevel()) {
            this.magicList.put(name, level);
        }
    }

    @Override
    public List<String> getShotlockList() {
        return Utils.getSortedShotlocks(this.shotlockList);
    }

    @Override
    public void setShotlockList(List<String> list) {
        this.shotlockList = list;
    }

    @Override
    public void addshotlockToList(String shotlock, boolean notification) {
        Shotlock shotlockInstance = (Shotlock)ModShotlocks.registry.getValue(new ResourceLocation(shotlock));
        if (notification) {
            this.messages.add("S_" + shotlockInstance.getTranslationKey());
        }
        if (!this.shotlockList.contains(shotlock)) {
            this.shotlockList.add(shotlock);
        }
    }

    @Override
    public void removeShotlockFromList(String shotlock) {
        if (this.shotlockList.contains(shotlock)) {
            this.shotlockList.remove(shotlock);
        }
    }

    @Override
    public void setMunny(int amount) {
        this.munny = amount;
    }

    @Override
    public int getMunny() {
        return this.munny;
    }

    @Override
    public Map<ResourceLocation, ItemStack> getEquippedKeychains() {
        return this.equippedKeychains;
    }

    @Override
    public ItemStack equipKeychain(ResourceLocation form, ItemStack stack) {
        if (this.canEquipKeychain(form, stack)) {
            ItemStack previous = this.getEquippedKeychain(form);
            this.equippedKeychains.put(form, stack);
            return previous;
        }
        return null;
    }

    @Override
    public ItemStack getEquippedKeychain(ResourceLocation form) {
        if (this.equippedKeychains.containsKey(form)) {
            return this.equippedKeychains.get(form);
        }
        return null;
    }

    @Override
    public void equipAllKeychains(Map<ResourceLocation, ItemStack> keychains, boolean force) {
        if (!force) {
            keychains.replaceAll((k, v) -> this.canEquipKeychain((ResourceLocation)k, (ItemStack)v) ? v : ItemStack.field_190927_a);
        }
        this.equippedKeychains = keychains;
    }

    @Override
    public boolean canEquipKeychain(ResourceLocation form, ItemStack stack) {
        return this.getEquippedKeychain(form) != null && ItemStack.func_77989_b((ItemStack)stack, (ItemStack)ItemStack.field_190927_a) | stack.func_77973_b() instanceof IKeychain && stack.func_190916_E() <= 1;
    }

    @Override
    public void setNewKeychain(ResourceLocation form, ItemStack stack) {
        if (!this.equippedKeychains.containsKey(form)) {
            this.equippedKeychains.put(form, stack);
        }
    }

    @Override
    public Map<Integer, ItemStack> getEquippedItems() {
        return this.equippedItems;
    }

    @Override
    public ItemStack equipItem(int slot, ItemStack stack) {
        if (this.canEquipItem(slot, stack)) {
            ItemStack previous = this.getEquippedItem(slot);
            this.equippedItems.put(slot, stack);
            return previous;
        }
        return null;
    }

    @Override
    public ItemStack getEquippedItem(int slot) {
        if (this.equippedItems.containsKey(slot)) {
            return this.equippedItems.get(slot);
        }
        return null;
    }

    @Override
    public void equipAllItems(Map<Integer, ItemStack> Items2, boolean force) {
        if (!force) {
            Items2.replaceAll((k, v) -> this.canEquipItem((int)k, (ItemStack)v) ? v : ItemStack.field_190927_a);
        }
        this.equippedItems = Items2;
    }

    @Override
    public boolean canEquipItem(int slot, ItemStack stack) {
        return this.getEquippedItem(slot) != null && (ItemStack.func_77989_b((ItemStack)stack, (ItemStack)ItemStack.field_190927_a) || stack.func_77973_b() instanceof KKPotionItem) && stack.func_190916_E() <= 1;
    }

    @Override
    public void setNewItem(int slot, ItemStack stack) {
        if (!this.equippedItems.containsKey(slot)) {
            this.equippedItems.put(slot, stack);
        }
    }

    @Override
    public int getHearts() {
        return this.hearts;
    }

    @Override
    public void setHearts(int hearts) {
        this.hearts = Math.max(0, hearts);
    }

    @Override
    public void addHearts(int hearts) {
        this.hearts = MathHelper.func_76125_a((int)(this.hearts + hearts), (int)0, (int)Integer.MAX_VALUE);
    }

    @Override
    public void removeHearts(int hearts) {
        this.addHearts(-hearts);
    }

    @Override
    public Utils.OrgMember getAlignment() {
        return this.alignment;
    }

    @Override
    public int getAlignmentIndex() {
        return this.alignment.ordinal();
    }

    @Override
    public void setAlignment(int index) {
        this.alignment = Utils.OrgMember.values()[index];
    }

    @Override
    public void setAlignment(Utils.OrgMember member) {
        this.alignment = member;
    }

    @Override
    public boolean isWeaponUnlocked(Item weapon) {
        for (ItemStack stack : this.weaponUnlocks) {
            if (stack.func_77973_b() != weapon.getItem()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void unlockWeapon(ItemStack weapon) {
        if (!this.weaponUnlocks.contains(weapon)) {
            this.weaponUnlocks.add(weapon);
        }
    }

    @Override
    public void unlockWeapon(String registryName) {
        ItemStack weaponUnlock;
        Item weapon = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(registryName));
        if (weapon != null && !this.weaponUnlocks.contains(weaponUnlock = new ItemStack((IItemProvider)weapon))) {
            this.weaponUnlocks.add(weaponUnlock);
        }
    }

    @Override
    public ItemStack getEquippedWeapon() {
        return this.equippedWeapon;
    }

    @Override
    public void equipWeapon(ItemStack weapon) {
        this.equippedWeapon = weapon;
    }

    @Override
    public void equipWeapon(String registryName) {
        Item weapon = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(registryName));
        this.equippedWeapon = weapon != null ? new ItemStack((IItemProvider)weapon) : ItemStack.field_190927_a;
    }

    @Override
    public Set<ItemStack> getWeaponsUnlocked() {
        return this.weaponUnlocks;
    }

    @Override
    public void setWeaponsUnlocked(Set<ItemStack> unlocks) {
        this.weaponUnlocks = unlocks;
    }

    @Override
    public int getLimitCooldownTicks() {
        return this.limitCooldownTicks;
    }

    @Override
    public void setLimitCooldownTicks(int ticks) {
        this.limitCooldownTicks = ticks;
    }

    @Override
    public boolean getIsGliding() {
        return this.isGliding;
    }

    @Override
    public void setIsGliding(boolean b) {
        this.isGliding = b;
    }

    @Override
    public int getAerialDodgeTicks() {
        return this.aerialDodgeTicks;
    }

    @Override
    public void setAerialDodgeTicks(int ticks) {
        this.aerialDodgeTicks = ticks;
    }

    @Override
    public boolean hasJumpedAerialDodge() {
        return this.hasJumpedAerealDodge;
    }

    @Override
    public void setHasJumpedAerialDodge(boolean b) {
        this.hasJumpedAerealDodge = b;
    }

    @Override
    public LinkedHashMap<String, int[]> getAbilityMap() {
        return this.abilityMap;
    }

    @Override
    public void setAbilityMap(LinkedHashMap<String, int[]> map) {
        this.abilityMap = map;
    }

    @Override
    public void addAbility(String ability, boolean notification) {
        Ability abilityInstance = (Ability)ModAbilities.registry.getValue(new ResourceLocation(ability));
        if (notification) {
            this.messages.add("A_" + abilityInstance.getTranslationKey());
        }
        if (this.abilityMap.containsKey(ability)) {
            this.abilityMap.put(ability, new int[]{this.abilityMap.get(ability)[0] + 1, this.abilityMap.get(ability)[1]});
        } else {
            this.abilityMap.put(ability, new int[]{1, 0});
        }
    }

    public void addAbility(String ability, String displayName) {
        this.messages.add("A_" + displayName);
        if (this.abilityMap.containsKey(ability)) {
            this.abilityMap.put(ability, new int[]{this.abilityMap.get(ability)[0] + 1, this.abilityMap.get(ability)[1]});
        } else {
            this.abilityMap.put(ability, new int[]{1, 0});
        }
    }

    @Override
    public int[] getEquippedAbilityLevel(String string) {
        if (this.abilityMap.containsKey(string)) {
            return this.abilityMap.get(string);
        }
        return new int[]{0, 0};
    }

    @Override
    public boolean isAbilityEquipped(String string) {
        if (this.abilityMap.containsKey(string)) {
            return this.abilityMap.get(string)[1] > 0;
        }
        return false;
    }

    @Override
    public void addEquippedAbilityLevel(String ability, int level) {
        this.abilityMap.put(ability, new int[]{this.abilityMap.get(ability)[0], this.abilityMap.get(ability)[1] + level});
    }

    @Override
    public void clearAbilities() {
        this.abilityMap.clear();
    }

    @Override
    public List<String> getPartiesInvited() {
        return this.partyList;
    }

    @Override
    public void setPartiesInvited(List<String> list) {
        this.partyList = list;
    }

    @Override
    public void addPartiesInvited(String partyName) {
        this.partyList.add(partyName);
    }

    @Override
    public void removePartiesInvited(String partyName) {
        this.partyList.remove(partyName);
    }

    @Override
    public List<ResourceLocation> getKnownRecipeList() {
        Collections.sort(this.recipeList);
        return this.recipeList;
    }

    @Override
    public void setKnownRecipeList(List<ResourceLocation> list) {
        this.recipeList = list;
    }

    @Override
    public boolean hasKnownRecipe(ResourceLocation recipe) {
        return this.recipeList.contains(recipe);
    }

    @Override
    public void addKnownRecipe(ResourceLocation recipe) {
        if (!this.recipeList.contains(recipe)) {
            this.recipeList.add(recipe);
        }
    }

    @Override
    public void removeKnownRecipe(ResourceLocation recipe) {
        if (this.recipeList.contains(recipe)) {
            this.recipeList.remove(recipe);
        }
    }

    @Override
    public void clearRecipes() {
        this.recipeList.clear();
    }

    @Override
    public TreeMap<String, Integer> getMaterialMap() {
        return this.materials;
    }

    @Override
    public void setMaterialMap(TreeMap<String, Integer> materialMap) {
        this.materials = materialMap;
    }

    @Override
    public int getMaterialAmount(Material material) {
        if (this.materials.containsKey(material.getMaterialName())) {
            int currAmount = this.materials.get(material.getMaterialName());
            return currAmount;
        }
        return 0;
    }

    @Override
    public void addMaterial(Material material, int amount) {
        if (this.materials.containsKey(material.getMaterialName())) {
            int currAmount = this.materials.get(material.getMaterialName());
            if (amount <= 0) {
                this.materials.remove(material.getMaterialName());
            } else {
                this.materials.replace(material.getMaterialName(), currAmount + amount);
            }
        } else if (amount <= 0) {
            this.materials.remove(material.getMaterialName());
        } else {
            this.materials.put(material.getMaterialName(), amount);
        }
    }

    @Override
    public void setMaterial(Material material, int amount) {
        if (this.materials.containsKey(material.getMaterialName())) {
            if (amount <= 0) {
                this.materials.remove(material.getMaterialName());
            } else {
                this.materials.replace(material.getMaterialName(), amount);
            }
        } else if (amount <= 0) {
            this.materials.remove(material.getMaterialName());
        } else {
            this.materials.put(material.getMaterialName(), amount);
        }
    }

    @Override
    public void removeMaterial(Material material, int amount) {
        int currAmount;
        if (this.materials.containsKey(material.getMaterialName())) {
            currAmount = this.materials.get(material.getMaterialName());
            if (amount > currAmount) {
                amount = currAmount;
            }
        } else {
            return;
        }
        this.materials.replace(material.getMaterialName(), currAmount - amount);
    }

    @Override
    public void clearMaterials() {
        this.materials.clear();
    }

    @Override
    public Vector3d getReturnLocation() {
        return this.returnPos;
    }

    @Override
    public void setReturnLocation(PlayerEntity playerEntity) {
        this.setReturnLocation(playerEntity.func_213303_ch());
    }

    @Override
    public void setReturnLocation(Vector3d location) {
        this.returnPos = location;
    }

    @Override
    public RegistryKey<World> getReturnDimension() {
        return this.returnDim;
    }

    @Override
    public void setReturnDimension(PlayerEntity playerEntity) {
        this.setReturnDimension((RegistryKey<World>)playerEntity.field_70170_p.func_234923_W_());
    }

    @Override
    public void setReturnDimension(RegistryKey<World> type) {
        this.returnDim = type;
    }

    @Override
    public SoAState getSoAState() {
        return this.soAState;
    }

    @Override
    public void setSoAState(SoAState state) {
        this.soAState = state;
    }

    @Override
    public SoAState getChosen() {
        return this.choice;
    }

    @Override
    public void setChoice(SoAState choice) {
        this.choice = choice;
    }

    @Override
    public SoAState getSacrificed() {
        return this.sacrifice;
    }

    @Override
    public void setSacrifice(SoAState sacrifice) {
        this.sacrifice = sacrifice;
    }

    @Override
    public BlockPos getChoicePedestal() {
        return this.choicePedestal;
    }

    @Override
    public void setChoicePedestal(BlockPos pos) {
        this.choicePedestal = pos;
    }

    @Override
    public BlockPos getSacrificePedestal() {
        return this.sacrificePedestal;
    }

    @Override
    public void setSacrificePedestal(BlockPos pos) {
        this.sacrificePedestal = pos;
    }

    @Override
    public String getEquippedShotlock() {
        return this.equippedShotlock;
    }

    @Override
    public void setEquippedShotlock(String shotlock) {
        this.equippedShotlock = shotlock;
    }

    @Override
    public void setMagicCooldownTicks(int ticks) {
        this.magicCooldown = ticks;
    }

    @Override
    public void remMagicCooldownTicks(int ticks) {
        this.magicCooldown = Math.max(this.magicCooldown - ticks, 0);
    }

    @Override
    public int getMagicCooldownTicks() {
        return this.magicCooldown;
    }

    @Override
    public List<String> getReactionCommands() {
        return this.reactionList;
    }

    @Override
    public void setReactionCommands(List<String> list) {
        this.reactionList = list;
    }

    @Override
    public boolean addReactionCommand(String command, PlayerEntity player) {
        if (this.reactionList.contains(command)) {
            return false;
        }
        if (((ReactionCommand)ModReactionCommands.registry.getValue(new ResourceLocation(command))).conditionsToAppear(player, (LivingEntity)player)) {
            this.reactionList.add(command);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeReactionCommand(String command) {
        if (this.reactionList.contains(command)) {
            this.reactionList.remove(command);
            return true;
        }
        return false;
    }
}

