/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.capability;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.lib.PortalData;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class WorldCapabilities
implements IWorldCapabilities {
    List<Party> parties = new ArrayList<Party>();
    int heartlessSpawnLevel = 0;
    Map<UUID, PortalData> portals = new HashMap<UUID, PortalData>();

    @Override
    public Map<UUID, PortalData> getPortals() {
        return this.portals;
    }

    @Override
    public void setPortals(Map<UUID, PortalData> portals) {
        this.portals = portals;
    }

    @Override
    public void addPortal(UUID uuid, PortalData data) {
        this.portals.put(uuid, data);
    }

    @Override
    public boolean removePortal(UUID id) {
        if (this.portals.containsKey(id)) {
            this.portals.remove(id);
            return true;
        }
        return false;
    }

    @Override
    public PortalData getPortalFromUUID(UUID uuid) {
        return this.portals.getOrDefault(uuid, null);
    }

    @Override
    public UUID getOwnerIDFromUUID(UUID portalUUID) {
        for (Map.Entry<UUID, PortalData> p : this.portals.entrySet()) {
            if (!p.getValue().getUUID().equals(portalUUID)) continue;
            return p.getValue().getOwnerID();
        }
        return null;
    }

    @Override
    public List<UUID> getAllPortalsFromOwnerID(UUID ownerID) {
        ArrayList<UUID> portals = new ArrayList<UUID>();
        for (Map.Entry<UUID, PortalData> p : this.getPortals().entrySet()) {
            if (!p.getValue().getOwnerID().equals(ownerID)) continue;
            portals.add(p.getValue().getUUID());
        }
        return portals;
    }

    @Override
    public int getHeartlessSpawnLevel() {
        return this.heartlessSpawnLevel;
    }

    @Override
    public void setHeartlessSpawnLevel(int level) {
        this.heartlessSpawnLevel = level;
    }

    @Override
    public void setParties(List<Party> list) {
        this.parties = list;
    }

    @Override
    public List<Party> getParties() {
        return this.parties;
    }

    @Override
    @Nullable
    public Party getPartyFromMember(UUID memId) {
        for (Party party : this.parties) {
            for (Party.Member member : party.getMembers()) {
                if (!member.getUUID().equals(memId)) continue;
                return party;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public Party getPartyFromLeader(UUID leaderId) {
        return this.parties.stream().filter(party -> party.getLeader() != null && party.getLeader().getUUID() == leaderId).findFirst().orElse(null);
    }

    @Override
    @Nullable
    public Party getPartyFromName(String name) {
        for (Party party : this.parties) {
            if (!party.getName().equalsIgnoreCase(name)) continue;
            return party;
        }
        return null;
    }

    @Override
    public void removeParty(Party party) {
        String key = Utils.getResourceName(party.getName());
        int pos = -1;
        for (int i = 0; i < this.parties.size(); ++i) {
            if (!Utils.getResourceName(this.parties.get(i).getName()).equalsIgnoreCase(key)) continue;
            pos = i;
            break;
        }
        if (pos > -1) {
            this.parties.remove(pos);
        }
    }

    @Override
    public void addParty(Party party) {
        String key = Utils.getResourceName(party.getName());
        boolean found = false;
        for (Party p : this.parties) {
            if (!p.getName().equalsIgnoreCase(key)) continue;
            found = true;
        }
        if (!found) {
            this.parties.add(party);
        }
    }

    @Override
    public void removeLeaderMember(Party party, LivingEntity entity) {
        party.removeMember(entity.func_110124_au());
    }

    @Override
    public void addPartyMember(Party party, LivingEntity entity) {
        party.addMember(entity);
    }

    @Override
    public void read(CompoundNBT nbt) {
        this.parties.clear();
        ListNBT parties = nbt.func_150295_c("parties", 10);
        for (int i = 0; i < parties.size(); ++i) {
            CompoundNBT partyNBT = parties.func_150305_b(i);
            Party party = new Party();
            party.read(partyNBT);
            this.parties.add(party);
        }
        this.heartlessSpawnLevel = nbt.func_74762_e("heartless");
        this.portals.clear();
        ListNBT portals = nbt.func_150295_c("portals", 10);
        for (int i = 0; i < portals.size(); ++i) {
            CompoundNBT portalNBT = portals.func_150305_b(i);
            PortalData portal = new PortalData(null, null, 0.0, 0.0, 0.0, null, null);
            portal.read(portalNBT);
            this.portals.put(portal.getUUID(), portal);
        }
    }

    @Override
    public CompoundNBT write(CompoundNBT nbt) {
        ListNBT parties = new ListNBT();
        for (Party party : this.parties) {
            parties.add((Object)party.write());
        }
        nbt.func_218657_a("parties", (INBT)parties);
        nbt.func_74768_a("heartless", this.heartlessSpawnLevel);
        ListNBT portals = new ListNBT();
        for (Map.Entry<UUID, PortalData> entry : this.getPortals().entrySet()) {
            portals.add((Object)entry.getValue().write());
        }
        nbt.func_218657_a("portals", (INBT)portals);
        return nbt;
    }

    public static class Storage
    implements Capability.IStorage<IWorldCapabilities> {
        public INBT writeNBT(Capability<IWorldCapabilities> capability, IWorldCapabilities instance, Direction side) {
            CompoundNBT storage = new CompoundNBT();
            storage.func_74768_a("heartless", instance.getHeartlessSpawnLevel());
            ListNBT parties = new ListNBT();
            for (Party party : instance.getParties()) {
                parties.add((Object)party.write());
            }
            storage.func_218657_a("parties", (INBT)parties);
            ListNBT portals = new ListNBT();
            for (Map.Entry<UUID, PortalData> entry : instance.getPortals().entrySet()) {
                portals.add((Object)entry.getValue().write());
            }
            storage.func_218657_a("portals", (INBT)portals);
            return storage;
        }

        public void readNBT(Capability<IWorldCapabilities> capability, IWorldCapabilities instance, Direction side, INBT nbt) {
            CompoundNBT storage = (CompoundNBT)nbt;
            instance.setHeartlessSpawnLevel(storage.func_74762_e("heartless"));
            List<Party> partiesList = instance.getParties();
            ListNBT parties = storage.func_150295_c("parties", 10);
            for (int i = 0; i < parties.size(); ++i) {
                CompoundNBT partyNBT = parties.func_150305_b(i);
                Party party = new Party();
                party.read(partyNBT);
                partiesList.add(party);
            }
            instance.setParties(partiesList);
            Map<UUID, PortalData> portalList = instance.getPortals();
            ListNBT portals = storage.func_150295_c("portals", 10);
            for (int i = 0; i < portals.size(); ++i) {
                CompoundNBT portalNBT = portals.func_150305_b(i);
                PortalData portal = new PortalData(null, null, 0.0, 0.0, 0.0, null, null);
                portal.read(portalNBT);
                portalList.put(portal.getUUID(), portal);
            }
            instance.setPortals(portalList);
        }
    }
}

