/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.handler.EntityEvents;
import online.kingdomkeys.kingdomkeys.item.organization.ArrowgunItem;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.lib.PortalData;
import online.kingdomkeys.kingdomkeys.limit.Limit;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.reactioncommands.ModReactionCommands;
import online.kingdomkeys.kingdomkeys.reactioncommands.ReactionCommand;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CommandMenuGui
extends Screen {
    public static final int TOP = 5;
    public static final int ATTACK = 4;
    public static final int MAGIC = 3;
    public static final int ITEMS = 2;
    public static final int DRIVE = 1;
    int TOP_WIDTH = 70;
    int TOP_HEIGHT = 15;
    int MENU_WIDTH = 71;
    int MENU_HEIGHT = 15;
    int iconWidth = 10;
    int textX = 0;
    public static final int SUB_MAIN = 0;
    public static final int SUB_MAGIC = 1;
    public static final int SUB_ITEMS = 2;
    public static final int SUB_DRIVE = 3;
    public static final int SUB_PORTALS = 4;
    public static final int SUB_ATTACKS = 5;
    public static final int SUB_TARGET = 6;
    public static final int SUB_LIMIT = 7;
    public static final int NONE = 0;
    public static int selected = 4;
    public static int targetSelected = 0;
    public static int submenu = 0;
    public static int magicSelected = 0;
    public static int potionSelected = 0;
    public static int driveSelected = 0;
    public static int portalSelected = 0;
    public static int attackSelected = 0;
    public static int limitSelected = 0;
    public static int itemSelected = 0;
    public static int reactionSelected = 0;
    ResourceLocation texture = new ResourceLocation("kingdomkeys", "textures/gui/commandmenu.png");
    float alpha = 1.0f;
    float scale = 1.05f;
    float[] orgColor = new float[]{0.8f, 0.8f, 0.8f};
    float[] normalModeColor = new float[]{0.04f, 0.2f, 1.0f, 0.0f};
    float[] portalMenuColor = new float[]{0.8f, 0.8f, 0.8f, 4.0f};
    float[] combatModeColor = new float[]{1.0f, 0.0f, 0.0f, 0.0f};
    float[] magicMenuColor = new float[]{0.4f, 0.0f, 1.0f, 1.0f};
    float[] itemsMenuColor = new float[]{0.3f, 1.0f, 0.3f, 2.0f};
    float[] driveMenuColor = new float[]{0.0f, 1.0f, 1.0f, 3.0f};
    float[] limitMenuColor = new float[]{1.0f, 1.0f, 0.0f, 7.0f};
    float[] targetModeColor = new float[]{0.04f, 0.2f, 1.0f, 6.0f};

    public CommandMenuGui() {
        super((ITextComponent)new TranslationTextComponent(""));
        this.field_230706_i_ = Minecraft.func_71410_x();
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderOverlayPost(RenderGameOverlayEvent event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            this.drawCommandMenu(event.getMatrixStack(), this.field_230706_i_.func_228018_at_().func_198107_o(), this.field_230706_i_.func_228018_at_().func_198087_p());
        }
    }

    private int getColor(int colour, int sub) {
        if (submenu == sub) {
            return colour;
        }
        Color c = Color.decode(String.valueOf(colour));
        return c.darker().darker().getRGB();
    }

    private void paintWithColorArray(MatrixStack matrixStack, float[] array, float alpha) {
        if (EntityEvents.isHostiles) {
            if ((float)submenu == array[3]) {
                RenderSystem.color4f((float)this.combatModeColor[0], (float)this.combatModeColor[1], (float)this.combatModeColor[2], (float)alpha);
            } else {
                RenderSystem.color4f((float)(this.combatModeColor[0] / 2.0f), (float)(array[1] / 2.0f), (float)(this.combatModeColor[2] / 2.0f), (float)alpha);
            }
        } else if (ModCapabilities.getPlayer((PlayerEntity)Minecraft.func_71410_x().field_71439_g).getAlignment() != Utils.OrgMember.NONE && array == this.normalModeColor) {
            if ((float)submenu == array[3]) {
                RenderSystem.color4f((float)this.orgColor[0], (float)this.orgColor[1], (float)this.orgColor[2], (float)alpha);
            } else {
                RenderSystem.color4f((float)(this.orgColor[0] / 2.0f), (float)(this.orgColor[1] / 2.0f), (float)(this.orgColor[2] / 2.0f), (float)alpha);
            }
        } else if ((float)submenu == array[3]) {
            RenderSystem.color4f((float)array[0], (float)array[1], (float)array[2], (float)alpha);
        } else {
            RenderSystem.color4f((float)(array[0] / 2.0f), (float)(array[1] / 2.0f), (float)(array[2] / 2.0f), (float)alpha);
        }
    }

    public void drawCommandMenu(MatrixStack matrixStack, int width, int height) {
        if (ModCapabilities.getPlayer((PlayerEntity)this.field_230706_i_.field_71439_g) != null) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)ModConfigs.cmXPos, 0.0, 0.0);
            this.drawMain(matrixStack, width, height);
            if (submenu == 4) {
                this.drawSubPortals(matrixStack, width, height);
            }
            if (submenu == 1 || submenu == 6 && selected == 3) {
                this.drawSubMagic(matrixStack, width, height);
            }
            if (submenu == 2 || submenu == 6 && selected == 2) {
                this.drawSubItems(matrixStack, width, height);
            }
            if (submenu == 3) {
                this.drawSubDrive(matrixStack, width, height);
            }
            if (submenu == 7) {
                this.drawSubLimits(matrixStack, width, height);
            }
            if (submenu == 6) {
                this.drawSubTargetSelector(matrixStack, width, height);
            }
            matrixStack.func_227865_b_();
        }
    }

    private void drawHeader(MatrixStack matrixStack, String text, int subMenu) {
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_((float)ModConfigs.cmXScale / 100.0f, 1.0f, 1.0f);
        this.func_238474_b_(matrixStack, 0, 0, 0, 0, this.TOP_WIDTH, this.TOP_HEIGHT);
        matrixStack.func_227865_b_();
        if (ModConfigs.cmHeaderTextVisible) {
            CommandMenuGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)Utils.translateToLocal(text, new Object[0]), (int)((int)((double)(5 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset), (int)4, (int)this.getColor(0xFFFFFF, subMenu));
        }
    }

    private void drawSelectedSlot(MatrixStack matrixStack) {
        RenderSystem.enableBlend();
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_((float)ModConfigs.cmXScale / 100.0f, 1.0f, 1.0f);
        this.func_238474_b_(matrixStack, 5, 0, this.TOP_WIDTH, this.MENU_HEIGHT, this.TOP_WIDTH, this.MENU_HEIGHT);
        matrixStack.func_227865_b_();
        RenderSystem.disableBlend();
    }

    private void drawUnselectedSlot(MatrixStack matrixStack) {
        RenderSystem.enableBlend();
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_((float)ModConfigs.cmXScale / 100.0f, 1.0f, 1.0f);
        this.func_238474_b_(matrixStack, 0, 0, this.TOP_WIDTH, 0, this.TOP_WIDTH, 0 + this.MENU_HEIGHT);
        matrixStack.func_227865_b_();
        RenderSystem.disableBlend();
    }

    private void drawIcon(MatrixStack matrixStack, int selected, int subMenu) {
        RenderSystem.enableBlend();
        if (subMenu == submenu) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        } else {
            RenderSystem.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)this.alpha);
        }
        this.func_238474_b_(matrixStack, (int)((double)this.TOP_WIDTH * ((double)ModConfigs.cmXScale / 100.0) - (double)this.TOP_WIDTH * ((double)ModConfigs.cmXScale / 100.0) * 0.15), 2, 140 + selected * this.iconWidth - this.iconWidth, 18, this.iconWidth, this.iconWidth);
        RenderSystem.disableBlend();
    }

    private String getCommandMenuName(int i) {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)this.field_230706_i_.field_71439_g);
        switch (i) {
            case 4: {
                return playerData.getAlignment() == Utils.OrgMember.NONE ? "gui.commandmenu.attack" : "gui.commandmenu.portal";
            }
            case 3: {
                return "gui.commandmenu.magic";
            }
            case 2: {
                return "gui.commandmenu.items";
            }
            case 1: {
                return playerData.getAlignment() == Utils.OrgMember.NONE ? (playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) ? "gui.commandmenu.drive" : "gui.commandmenu.revert") : "gui.commandmenu.limit";
            }
        }
        return "";
    }

    public void drawMain(MatrixStack matrixStack, int width, int height) {
        RenderSystem.enableBlend();
        matrixStack.func_227860_a_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        this.field_230706_i_.field_71446_o.func_110577_a(this.texture);
        matrixStack.func_227861_a_(0.0, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * 5.0f), 0.0);
        matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
        this.textX = 0;
        this.paintWithColorArray(matrixStack, this.normalModeColor, this.alpha);
        this.drawHeader(matrixStack, "gui.commandmenu.command", 0);
        matrixStack.func_227865_b_();
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)this.field_230706_i_.field_71439_g);
        List<String> list = playerData.getReactionCommands();
        for (int i = 0; i < list.size(); ++i) {
            matrixStack.func_227860_a_();
            if (i == reactionSelected) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            } else {
                RenderSystem.color4f((float)0.4f, (float)0.4f, (float)0.4f, (float)this.alpha);
            }
            this.field_230706_i_.field_71446_o.func_110577_a(this.texture);
            matrixStack.func_227861_a_(0.0, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * 5.0f - 15.0f * this.scale * (float)i), 0.0);
            matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
            this.textX = 0;
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_((float)ModConfigs.cmXScale / 75.0f, 1.0f, 1.0f);
            this.func_238474_b_(matrixStack, 0, 0, 0, 15, this.TOP_WIDTH, this.TOP_HEIGHT);
            matrixStack.func_227865_b_();
            ReactionCommand command = (ReactionCommand)ModReactionCommands.registry.getValue(new ResourceLocation(list.get(i)));
            CommandMenuGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)Utils.translateToLocal(command.getTranslationKey(), new Object[0]), (int)((int)((double)(5 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset), (int)4, (int)0xFFFFFF);
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227860_a_();
        boolean x = false;
        for (int i = 1; i <= 4; ++i) {
            ItemStack weapon;
            matrixStack.func_227860_a_();
            this.field_230706_i_.field_71446_o.func_110577_a(this.texture);
            matrixStack.func_227861_a_((double)x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)i), 0.0);
            matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
            this.paintWithColorArray(matrixStack, this.normalModeColor, this.alpha);
            ClientPlayerEntity player = this.field_230706_i_.field_71439_g;
            if (selected == i) {
                this.textX = (int)((double)(10 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                this.drawSelectedSlot(matrixStack);
                if (selected == 4 && ModCapabilities.getPlayer((PlayerEntity)player).getAlignment() != Utils.OrgMember.NONE) {
                    this.drawIcon(matrixStack, selected + 1, 0);
                } else {
                    this.drawIcon(matrixStack, selected, 0);
                }
            } else {
                this.textX = (int)((double)(5 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                this.drawUnselectedSlot(matrixStack);
            }
            int color = this.getColor(0xFFFFFF, 0);
            if (i == 3) {
                int n = color = playerData.getMagicsMap().isEmpty() || playerData.getMaxMP() == 0.0 || playerData.getMagicCooldownTicks() > 0 || playerData.getRecharge() || playerData.getActiveDriveForm().equals("kingdomkeys:form_valor") ? 0x888888 : this.getColor(0xFFFFFF, 0);
            }
            if (i == 2) {
                color = this.getColor(Utils.getEquippedItems(playerData.getEquippedItems()).size() > 0 ? 0xFFFFFF : 0x888888, 0);
            }
            if (i == 1) {
                color = this.getColor(0x888888, 0);
                color = playerData.getAlignment() != Utils.OrgMember.NONE ? (playerData.getLimitCooldownTicks() <= 0 ? this.getColor(0xFFFFFF, 0) : this.getColor(0x888888, 0)) : (playerData.getActiveDriveForm().equals("kingdomkeys:form_anti") && EntityEvents.isHostiles || playerData.getDriveFormMap().size() <= 1 ? this.getColor(0x888888, 0) : this.getColor(0xFFFFFF, 0));
            }
            CommandMenuGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)Utils.translateToLocal(this.getCommandMenuName(i), new Object[0]), (int)this.textX, (int)4, (int)color);
            if (i == 4 && player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof ArrowgunItem && (weapon = player.func_184614_ca()).func_77942_o() && weapon.func_77978_p().func_74764_b("ammo")) {
                int ammo = weapon.func_77978_p().func_74762_e("ammo");
                CommandMenuGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(ammo + ""), (int)((int)((double)this.TOP_WIDTH * ((double)ModConfigs.cmXScale / 100.0) + (double)this.TOP_WIDTH * ((double)ModConfigs.cmXScale / 100.0) * 0.1)), (int)4, (int)0xFFFFFF);
            }
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
        RenderSystem.disableBlend();
    }

    public void drawSubPortals(MatrixStack matrixStack, int width, int height) {
        RenderSystem.enableBlend();
        IWorldCapabilities worldData = ModCapabilities.getWorld(this.field_230706_i_.field_71439_g.field_70170_p);
        List<UUID> portals = worldData.getAllPortalsFromOwnerID(this.field_230706_i_.field_71439_g.func_110124_au());
        if (portals != null && !portals.isEmpty()) {
            double x = (double)(10 * ModConfigs.cmSubXOffset) / 100.0;
            matrixStack.func_227860_a_();
            this.paintWithColorArray(matrixStack, this.portalMenuColor, this.alpha);
            this.field_230706_i_.field_71446_o.func_110577_a(this.texture);
            matrixStack.func_227861_a_(x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)(portals.size() + 1)), 0.0);
            matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
            this.drawHeader(matrixStack, "gui.commandmenu.portal.title", 4);
            matrixStack.func_227865_b_();
            if (submenu == 4) {
                for (int i = 0; i < portals.size(); ++i) {
                    matrixStack.func_227860_a_();
                    this.field_230706_i_.field_71446_o.func_110577_a(this.texture);
                    matrixStack.func_227861_a_(x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)(portals.size() - i)), 0.0);
                    matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
                    this.paintWithColorArray(matrixStack, this.portalMenuColor, this.alpha);
                    if (portalSelected == i) {
                        this.textX = (int)((double)(10 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                        this.drawSelectedSlot(matrixStack);
                        this.drawIcon(matrixStack, selected, 4);
                    } else {
                        this.textX = (int)((double)(5 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                        this.drawUnselectedSlot(matrixStack);
                    }
                    UUID portalUUID = portals.get(i);
                    PortalData portal = worldData.getPortalFromUUID(portalUUID);
                    if (portal != null) {
                        CommandMenuGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)Utils.translateToLocal(portal.getName(), new Object[0]), (int)this.textX, (int)4, (int)0xFFFFFF);
                    }
                    matrixStack.func_227865_b_();
                }
            }
        }
        RenderSystem.disableBlend();
    }

    private void drawSubTargetSelector(MatrixStack matrixStack, int width, int height) {
        RenderSystem.enableBlend();
        IWorldCapabilities worldData = ModCapabilities.getWorld((World)this.field_230706_i_.field_71441_e);
        if (worldData == null || worldData.getPartyFromMember(this.field_230706_i_.field_71439_g.func_110124_au()) == null) {
            submenu = 0;
            return;
        }
        double x = (double)(20 * ModConfigs.cmSubXOffset) / 100.0;
        matrixStack.func_227860_a_();
        this.paintWithColorArray(matrixStack, this.targetModeColor, this.alpha);
        this.field_230706_i_.field_71446_o.func_110577_a(this.texture);
        matrixStack.func_227861_a_(x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)(worldData.getPartyFromMember(this.field_230706_i_.field_71439_g.func_110124_au()).getMembers().size() + 1)), 0.0);
        matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
        this.drawHeader(matrixStack, "TARGET", 6);
        matrixStack.func_227865_b_();
        for (int i = 0; i < worldData.getPartyFromMember(this.field_230706_i_.field_71439_g.func_110124_au()).getMembers().size(); ++i) {
            matrixStack.func_227860_a_();
            this.field_230706_i_.field_71446_o.func_110577_a(this.texture);
            matrixStack.func_227861_a_(x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)(worldData.getPartyFromMember(this.field_230706_i_.field_71439_g.func_110124_au()).getMembers().size() - i)), 0.0);
            matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
            if (submenu == 6) {
                this.paintWithColorArray(matrixStack, this.targetModeColor, this.alpha);
                if (targetSelected == i) {
                    this.textX = (int)((double)(10 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                    this.drawSelectedSlot(matrixStack);
                    this.drawIcon(matrixStack, selected, 6);
                } else {
                    this.textX = (int)((double)(5 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                    this.drawUnselectedSlot(matrixStack);
                }
                Party.Member member = worldData.getPartyFromMember(this.field_230706_i_.field_71439_g.func_110124_au()).getMembers().get(i);
                if (this.field_230706_i_.field_71441_e.func_217371_b(member.getUUID()) != null && this.field_230706_i_.field_71439_g.func_70032_d((Entity)this.field_230706_i_.field_71441_e.func_217371_b(member.getUUID())) < (float)ModConfigs.partyRangeLimit) {
                    CommandMenuGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)member.getUsername(), (int)((int)((float)this.textX + (float)ModConfigs.cmXScale / 100.0f)), (int)4, (int)0xFFFFFF);
                } else {
                    CommandMenuGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)member.getUsername(), (int)((int)((float)this.textX + (float)ModConfigs.cmXScale / 100.0f)), (int)4, (int)0x888888);
                }
            }
            matrixStack.func_227865_b_();
        }
        RenderSystem.disableBlend();
    }

    private void drawSubMagic(MatrixStack matrixStack, int width, int height) {
        RenderSystem.enableBlend();
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)this.field_230706_i_.field_71439_g);
        LinkedHashMap<String, Integer> magics = Utils.getSortedMAgics(playerData.getMagicsMap());
        if (playerData != null && magics != null && !magics.isEmpty()) {
            double x = (double)(10 * ModConfigs.cmSubXOffset) / 100.0;
            matrixStack.func_227860_a_();
            this.field_230706_i_.field_71446_o.func_110577_a(this.texture);
            matrixStack.func_227861_a_(x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)(magics.size() + 1)), 0.0);
            matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
            this.paintWithColorArray(matrixStack, this.magicMenuColor, this.alpha);
            this.drawHeader(matrixStack, "gui.commandmenu.magic.title", 1);
            matrixStack.func_227865_b_();
            for (int i = 0; i < magics.size(); ++i) {
                int colour;
                matrixStack.func_227860_a_();
                this.field_230706_i_.field_71446_o.func_110577_a(this.texture);
                matrixStack.func_227861_a_(x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)(magics.size() - i)), 0.0);
                matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
                this.paintWithColorArray(matrixStack, this.magicMenuColor, this.alpha);
                if (magicSelected == i) {
                    this.textX = (int)((double)(10 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                    this.drawSelectedSlot(matrixStack);
                    this.drawIcon(matrixStack, selected, 1);
                } else {
                    this.textX = (int)((double)(5 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                    this.drawUnselectedSlot(matrixStack);
                }
                String magic = (String)magics.keySet().toArray()[i];
                int magicLevel = playerData.getMagicLevel(magic);
                Magic magicInstance = (Magic)ModMagic.registry.getValue(new ResourceLocation(magic));
                int cost = magicInstance.getCost();
                int n = colour = playerData.getMP() > (double)cost ? 0xFFFFFF : 0xFF9900;
                if (playerData.getMaxMP() == 0.0 || playerData.getRecharge() || (double)cost > playerData.getMaxMP() && cost < 300) {
                    colour = 0x888888;
                }
                magic = magicInstance.getTranslationKey(magicLevel);
                CommandMenuGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)Utils.translateToLocal(magic, new Object[0]), (int)this.textX, (int)4, (int)this.getColor(colour, 1));
                matrixStack.func_227865_b_();
            }
        }
        RenderSystem.disableBlend();
    }

    private void drawSubItems(MatrixStack matrixStack, int width, int height) {
        RenderSystem.enableBlend();
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)this.field_230706_i_.field_71439_g);
        Map<Integer, ItemStack> items = Utils.getEquippedItems(playerData.getEquippedItems());
        double x = (double)(10 * ModConfigs.cmSubXOffset) / 100.0;
        if (playerData != null && items != null && !items.isEmpty()) {
            matrixStack.func_227860_a_();
            this.paintWithColorArray(matrixStack, this.itemsMenuColor, this.alpha);
            this.field_230706_i_.field_71446_o.func_110577_a(this.texture);
            matrixStack.func_227861_a_(x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)(items.size() + 1)), 0.0);
            matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
            this.drawHeader(matrixStack, "ITEMS", 2);
            matrixStack.func_227865_b_();
            int c = 0;
            for (Map.Entry<Integer, ItemStack> entry : items.entrySet()) {
                ItemStack itemStack = entry.getValue();
                matrixStack.func_227860_a_();
                this.field_230706_i_.field_71446_o.func_110577_a(this.texture);
                matrixStack.func_227861_a_(x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)(items.size() - c)), 0.0);
                matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
                this.paintWithColorArray(matrixStack, this.itemsMenuColor, this.alpha);
                if (itemSelected == c) {
                    this.textX = (int)((double)(10 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                    this.drawSelectedSlot(matrixStack);
                    this.drawIcon(matrixStack, selected, 2);
                } else {
                    this.textX = (int)((double)(5 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                    this.drawUnselectedSlot(matrixStack);
                }
                matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
                CommandMenuGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)Utils.translateToLocal(itemStack.func_77977_a(), new Object[0]), (int)this.textX, (int)4, (int)0xFFFFFF);
                matrixStack.func_227865_b_();
                ++c;
            }
        }
        RenderSystem.disableBlend();
    }

    private void drawSubDrive(MatrixStack matrixStack, int width, int height) {
        RenderSystem.enableBlend();
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)this.field_230706_i_.field_71439_g);
        LinkedHashMap<String, int[]> forms = Utils.getSortedDriveForms(playerData.getDriveFormMap());
        forms.remove(DriveForm.NONE.toString());
        double x = (double)(10 * ModConfigs.cmSubXOffset) / 100.0;
        if (playerData != null && forms != null && !forms.isEmpty()) {
            matrixStack.func_227860_a_();
            this.paintWithColorArray(matrixStack, this.driveMenuColor, this.alpha);
            this.field_230706_i_.field_71446_o.func_110577_a(this.texture);
            matrixStack.func_227861_a_(x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)(forms.size() + 1)), 0.0);
            matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
            this.drawHeader(matrixStack, "gui.commandmenu.drive.title", 3);
            matrixStack.func_227865_b_();
            for (int i = 0; i < forms.size(); ++i) {
                String formName = (String)forms.keySet().toArray()[i];
                if (formName.equals(DriveForm.NONE.toString())) continue;
                DriveForm form = (DriveForm)ModDriveForms.registry.getValue(new ResourceLocation(formName));
                int cost = form.getDriveCost();
                int color = playerData.getDP() >= (double)cost ? 0xFFFFFF : 0x888888;
                formName = form.getTranslationKey();
                matrixStack.func_227860_a_();
                this.field_230706_i_.field_71446_o.func_110577_a(this.texture);
                matrixStack.func_227861_a_(x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)(forms.size() - i)), 0.0);
                matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
                if (submenu == 3) {
                    this.paintWithColorArray(matrixStack, this.driveMenuColor, this.alpha);
                    if (driveSelected == i) {
                        this.textX = (int)((double)(10 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                        this.drawSelectedSlot(matrixStack);
                        this.drawIcon(matrixStack, selected, 3);
                    } else {
                        this.textX = (int)((double)(5 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                        this.drawUnselectedSlot(matrixStack);
                    }
                }
                matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
                if (submenu == 3) {
                    CommandMenuGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)Utils.translateToLocal(formName, new Object[0]), (int)this.textX, (int)4, (int)color);
                }
                matrixStack.func_227865_b_();
            }
        }
        RenderSystem.disableBlend();
    }

    private void drawSubLimits(MatrixStack matrixStack, int width, int height) {
        RenderSystem.enableBlend();
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)this.field_230706_i_.field_71439_g);
        List<Limit> limits = Utils.getPlayerLimitAttacks((PlayerEntity)this.field_230706_i_.field_71439_g);
        if (playerData != null && limits != null && !limits.isEmpty()) {
            double x = (double)(10 * ModConfigs.cmSubXOffset) / 100.0;
            matrixStack.func_227860_a_();
            this.field_230706_i_.field_71446_o.func_110577_a(this.texture);
            matrixStack.func_227861_a_(x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)(limits.size() + 1)), 0.0);
            matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
            this.paintWithColorArray(matrixStack, this.limitMenuColor, this.alpha);
            this.drawHeader(matrixStack, "gui.commandmenu.limit.title", 7);
            matrixStack.func_227865_b_();
            for (int i = 0; i < limits.size(); ++i) {
                matrixStack.func_227860_a_();
                this.field_230706_i_.field_71446_o.func_110577_a(this.texture);
                matrixStack.func_227861_a_(x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)(limits.size() - i)), 0.0);
                matrixStack.func_227862_a_(this.scale, this.scale, this.scale);
                this.paintWithColorArray(matrixStack, this.limitMenuColor, this.alpha);
                if (limitSelected == i) {
                    this.textX = (int)((double)(10 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                    this.drawSelectedSlot(matrixStack);
                    this.drawIcon(matrixStack, selected, 7);
                } else {
                    this.textX = (int)((double)(5 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                    this.drawUnselectedSlot(matrixStack);
                }
                int limitCost = limits.get(i).getCost();
                int color = playerData.getDP() >= (double)limitCost ? 0xFFFFFF : 0x888888;
                String name = limits.get(i).getTranslationKey();
                matrixStack.func_227862_a_(this.scale * 0.7f, this.scale * 0.9f, this.scale);
                CommandMenuGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)Utils.translateToLocal(name, new Object[0]), (int)this.textX, (int)4, (int)this.getColor(color, 7));
                matrixStack.func_227862_a_(this.scale * 1.3f, this.scale * 1.1f, this.scale);
                CommandMenuGui.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(limitCost / 100 + ""), (int)((int)((double)this.TOP_WIDTH * ((double)ModConfigs.cmXScale / 100.0) + (double)this.TOP_WIDTH * ((double)ModConfigs.cmXScale / 100.0) * 0.1)), (int)4, (int)this.getColor(65535, 7));
                matrixStack.func_227865_b_();
            }
        }
        RenderSystem.disableBlend();
    }
}

