/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.lib.Party;

public class PartyHUDGui
extends Screen {
    int hpBarWidth;
    int guiHeight = 10;
    int counter = 0;

    public PartyHUDGui() {
        super((ITextComponent)new TranslationTextComponent(""));
        this.field_230706_i_ = Minecraft.func_71410_x();
    }

    public ResourceLocation getLocationSkin(PlayerEntity player) {
        NetworkPlayerInfo networkplayerinfo = Minecraft.func_71410_x().func_147114_u().func_175102_a(player.func_110124_au());
        return networkplayerinfo == null ? DefaultPlayerSkin.func_177334_a((UUID)player.func_110124_au()) : networkplayerinfo.func_178837_g();
    }

    @SubscribeEvent
    public void onRenderOverlayPost(RenderGameOverlayEvent event) {
        ClientPlayerEntity player = this.field_230706_i_.field_71439_g;
        if (!event.getType().equals((Object)RenderGameOverlayEvent.ElementType.HEALTH) || event.isCancelable()) {
            // empty if block
        }
        MatrixStack matrixStack = event.getMatrixStack();
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            int screenWidth = this.field_230706_i_.func_228018_at_().func_198107_o();
            int screenHeight = this.field_230706_i_.func_228018_at_().func_198087_p();
            float scale = 0.5f;
            IWorldCapabilities worldData = ModCapabilities.getWorld((World)this.field_230706_i_.field_71441_e);
            Party p = worldData.getPartyFromMember(player.func_110124_au());
            if (p == null) {
                return;
            }
            ArrayList<Party.Member> allies = new ArrayList<Party.Member>();
            allies.clear();
            for (Party.Member m : p.getMembers()) {
                if (m.getUUID().equals(player.func_110124_au())) continue;
                allies.add(m);
            }
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)ModConfigs.partyXPos, (double)(ModConfigs.partyYPos - 100), 0.0);
            for (int i = 0; i < allies.size(); ++i) {
                Party.Member member = (Party.Member)allies.get(i);
                PlayerEntity playerAlly = player.field_70170_p.func_217371_b(member.getUUID());
                this.renderFace(matrixStack, playerAlly, screenWidth, screenHeight, scale, i);
            }
            matrixStack.func_227865_b_();
        }
    }

    public void renderFace(MatrixStack matrixStack, PlayerEntity playerAlly, float screenWidth, float screenHeight, float scale, int i) {
        String name;
        ResourceLocation skin = playerAlly != null ? this.getLocationSkin(playerAlly) : new ResourceLocation("minecraft", "textures/entity/steve.png");
        this.field_230706_i_.func_110434_K().func_110577_a(skin);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(-16.0, (double)(-screenHeight / 4.0f * ((float)(i * ModConfigs.partyYDistance) / 100.0f)), 0.0);
        int headWidth = 32;
        int headHeight = 32;
        float headPosX = 0.0f;
        float headPosY = 0.0f;
        float scaledHeadPosX = headPosX * scale;
        float scaledHeadPosY = headPosY * scale;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(screenWidth - (float)headWidth * scale - scaledHeadPosX), (double)(screenHeight - (float)headHeight * scale - scaledHeadPosY), 0.0);
        matrixStack.func_227862_a_(scale, scale, scale);
        if (playerAlly == null) {
            RenderSystem.color4f((float)0.2f, (float)0.2f, (float)0.2f, (float)1.0f);
        } else {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.func_238474_b_(matrixStack, 0, 0, 32, 32, headWidth, headHeight);
        matrixStack.func_227865_b_();
        int hatWidth = 32;
        int hatHeight = 32;
        float hatPosX = 0.0f;
        float hatPosY = 0.0f;
        float scaledHatPosX = hatPosX * scale;
        float scaledHatPosY = hatPosY * scale;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(screenWidth - (float)hatWidth * scale - scaledHatPosX), (double)(screenHeight - (float)hatHeight * scale - scaledHatPosY), 0.0);
        matrixStack.func_227862_a_(scale, scale, scale);
        this.func_238474_b_(matrixStack, 0, 0, 160, 32, hatWidth, hatHeight);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(screenWidth - (float)hatWidth * scale - scaledHatPosX), (double)(screenHeight - (float)hatHeight * scale - scaledHatPosY), 0.0);
        matrixStack.func_227862_a_(scale, scale, scale);
        String string = name = playerAlly == null ? "Out of range" : playerAlly.func_145748_c_().getString();
        if (playerAlly != null && this.field_230706_i_.field_71439_g.func_70032_d((Entity)playerAlly) >= (float)ModConfigs.partyRangeLimit) {
            PartyHUDGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)"Out of range", (int)16, (int)-20, (int)0xFFFFFF);
        }
        PartyHUDGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)name, (int)16, (int)-10, (int)0xFFFFFF);
        matrixStack.func_227865_b_();
        if (playerAlly != null) {
            matrixStack.func_227861_a_((double)(screenWidth - (float)headWidth * scale - scaledHeadPosX), (double)(screenHeight - (float)headHeight * scale - scaledHeadPosY), 0.0);
            float val = playerAlly.func_110143_aJ();
            float max = playerAlly.func_110138_aP();
            this.field_230706_i_.field_71446_o.func_110577_a(new ResourceLocation("kingdomkeys", "textures/gui/hpbar.png"));
            matrixStack.func_227861_a_(-4.0, 0.0, 1.0);
            matrixStack.func_227860_a_();
            matrixStack.func_227862_a_(scale / 3.0f * 2.0f, scale, 1.0f);
            this.func_238474_b_(matrixStack, 0, 0, 0, 72, 12, 2);
            matrixStack.func_227865_b_();
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 1.0, 1.0);
            matrixStack.func_227862_a_(scale / 3.0f * 2.0f, scale * 28.0f, 1.0f);
            this.func_238474_b_(matrixStack, 0, 0, 0, 74, 12, 1);
            matrixStack.func_227865_b_();
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, 30.0, 1.0);
            matrixStack.func_227862_a_(scale / 3.0f * 2.0f, scale, 1.0f);
            this.func_238474_b_(matrixStack, 0, -30, 0, 72, 12, 2);
            matrixStack.func_227865_b_();
            matrixStack.func_227860_a_();
            matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_((float)Math.toRadians(180.0)));
            matrixStack.func_227861_a_(-4.0, -15.0, 1.0);
            matrixStack.func_227862_a_(scale * 0.66f, scale * 28.0f * val / max, 1.0f);
            this.func_238474_b_(matrixStack, 0, 0, 0, 78, 12, 1);
            matrixStack.func_227865_b_();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(playerAlly);
            if (playerData != null) {
                val = (float)playerData.getMP();
                max = (float)playerData.getMaxMP();
                this.field_230706_i_.field_71446_o.func_110577_a(new ResourceLocation("kingdomkeys", "textures/gui/mpbar.png"));
                matrixStack.func_227861_a_(20.0, 0.0, 1.0);
                matrixStack.func_227860_a_();
                matrixStack.func_227862_a_(scale / 3.0f * 2.0f, scale, 1.0f);
                this.func_238474_b_(matrixStack, 0, 0, 0, 58, 12, 2);
                matrixStack.func_227865_b_();
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.0, 1.0, 1.0);
                matrixStack.func_227862_a_(scale / 3.0f * 2.0f, scale * 28.0f, 1.0f);
                this.func_238474_b_(matrixStack, 0, 0, 0, 60, 12, 1);
                matrixStack.func_227865_b_();
                matrixStack.func_227860_a_();
                matrixStack.func_227861_a_(0.0, 30.0, 1.0);
                matrixStack.func_227862_a_(scale / 3.0f * 2.0f, scale, 1.0f);
                this.func_238474_b_(matrixStack, 0, -30, 0, 58, 12, 2);
                matrixStack.func_227865_b_();
                matrixStack.func_227860_a_();
                matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_((float)Math.toRadians(180.0)));
                matrixStack.func_227861_a_(-4.0, -15.0, 1.0);
                matrixStack.func_227862_a_(scale / 3.0f * 2.0f, scale * 28.0f * val / max, 1.0f);
                this.func_238474_b_(matrixStack, 0, 0, 0, 64, 12, 1);
                matrixStack.func_227865_b_();
            }
        }
        matrixStack.func_227865_b_();
    }
}

