/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButtonBase;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MenuBackground
extends Screen {
    int selected;
    String tip = null;
    Color color;
    public boolean drawPlayerInfo;
    MenuBar bottomLeftBar;
    MenuBar bottomRightBar;
    MenuBar topLeftBar;
    MenuBar topRightBar;
    protected float topBarHeight = (float)this.field_230709_l_ * 0.17f;
    protected float bottomBarHeight;
    protected float topLeftBarWidth;
    protected float topRightBarWidth;
    protected float topGap;
    protected float bottomLeftBarWidth;
    protected float bottomRightBarWidth;
    protected float bottomGap;
    protected float middleHeight;
    public boolean drawSeparately = false;
    protected float buttonPosX;
    protected int buttonPosY;
    protected float buttonWidth;
    public static final ResourceLocation optionsBackground = new ResourceLocation("kingdomkeys", "textures/gui/menubg.png");
    public static final ResourceLocation menu = new ResourceLocation("kingdomkeys", "textures/gui/menu/menu_button.png");

    public MenuBackground(String name, Color rgb) {
        super((ITextComponent)new TranslationTextComponent(name));
        this.field_230706_i_ = Minecraft.func_71410_x();
        this.selected = -1;
        this.color = rgb;
    }

    public void drawMenuBackground(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.drawBars(matrixStack);
        this.drawMunnyTime(matrixStack);
        this.drawBiomeDim(matrixStack);
        this.drawTip(matrixStack);
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(1.3f, 1.3f, 1.0f);
        MenuBackground.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)Utils.translateToLocal(this.func_231171_q_().getString(), new Object[0]), (int)2, (int)10, (int)0xFF9900);
        matrixStack.func_227865_b_();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (!this.drawSeparately) {
            this.drawMenuBackground(matrixStack, mouseX, mouseY, partialTicks);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    private void clearButtons() {
        for (Widget btn : this.field_230710_m_) {
            if (!(btn instanceof MenuButtonBase)) continue;
            ((MenuButtonBase)btn).setSelected(false);
        }
    }

    public void drawBars(MatrixStack matrixStack) {
        this.func_230446_a_(matrixStack);
        int sh = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
        int sw = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
        for (int i = 0; i < sh; i += 3) {
            matrixStack.func_227860_a_();
            RenderSystem.color3f((float)((float)this.color.getRed() / 255.0f), (float)((float)this.color.getGreen() / 255.0f), (float)((float)this.color.getBlue() / 255.0f));
            RenderSystem.enableBlend();
            this.field_230706_i_.field_71446_o.func_110577_a(menu);
            matrixStack.func_227861_a_(0.0, (double)i, 0.0);
            matrixStack.func_227862_a_((float)sw, 1.0f, 1.0f);
            this.func_238474_b_(matrixStack, 0, 0, 77, 92, 1, 1);
            RenderSystem.disableBlend();
            matrixStack.func_227865_b_();
        }
        this.topLeftBar.draw(matrixStack);
        this.topRightBar.draw(matrixStack);
        this.bottomLeftBar.draw(matrixStack);
        this.bottomRightBar.draw(matrixStack);
    }

    public void drawBiomeDim(MatrixStack matrixStack) {
        matrixStack.func_227860_a_();
        String dimension = this.field_230706_i_.field_71439_g.field_70170_p.func_234923_W_().func_240901_a_().func_110623_a().toUpperCase().replaceAll("_", " ");
        ResourceLocation biomeLoc = this.field_230706_i_.field_71441_e.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)this.field_230706_i_.field_71441_e.func_226691_t_(this.field_230706_i_.field_71439_g.func_233580_cy_()));
        String biome = "biome." + biomeLoc.func_110624_b() + "." + biomeLoc.func_110623_a();
        biome = LanguageMap.func_74808_a().func_230506_b_(biome) ? Utils.translateToLocal(biome, new Object[0]) : biomeLoc.toString();
        String text = dimension + " | " + biome;
        MenuBackground.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)text, (int)(this.field_230708_k_ - this.field_230706_i_.field_71466_p.func_78256_a(text) - 5), (int)5, (int)16091955);
        matrixStack.func_227865_b_();
    }

    public void drawMunnyTime(MatrixStack matrixStack) {
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(1.1f, 1.1f, 1.0f);
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)this.field_230706_i_.field_71439_g);
        MenuBackground.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(Utils.translateToLocal("gui.menu.main.munny", new Object[0]) + ": " + playerData.getMunny()), (int)5, (int)((int)(this.topBarHeight + this.middleHeight) - 7), (int)16148007);
        FontRenderer fontRenderer = this.field_230706_i_.field_71466_p;
        String string = Utils.translateToLocal("gui.menu.main.hearts", new Object[0]) + ": " + playerData.getHearts();
        int n = (int)(this.topBarHeight + this.middleHeight);
        this.field_230706_i_.field_71466_p.getClass();
        MenuBackground.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)fontRenderer, (String)string, (int)5, (int)(n + 9 - 7), (int)(playerData.getAlignment() == Utils.OrgMember.NONE ? 0x888888 : 0xFF3333));
        FontRenderer fontRenderer2 = this.field_230706_i_.field_71466_p;
        String string2 = Utils.translateToLocal("gui.menu.main.time", new Object[0]) + ": " + MenuBackground.getWorldHours((World)this.field_230706_i_.field_71441_e) + ":" + MenuBackground.getWorldMinutes((World)this.field_230706_i_.field_71441_e);
        int n2 = (int)(this.topBarHeight + this.middleHeight);
        this.field_230706_i_.field_71466_p.getClass();
        MenuBackground.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)fontRenderer2, (String)string2, (int)5, (int)(n2 + 9 * 2 - 7), (int)0xFFFFFF);
        long seconds = this.field_230706_i_.field_71441_e.func_72820_D() / 20L;
        long h = seconds / 3600L;
        long m = seconds % 3600L / 60L;
        long s = seconds % 3600L % 60L;
        String sec = s < 10L ? "0" + s : s + "";
        String min = m < 10L ? "0" + m : m + "";
        String hou = h < 10L ? "0" + h : h + "";
        String time = hou + ":" + min + ":" + sec;
        FontRenderer fontRenderer3 = this.field_230706_i_.field_71466_p;
        String string3 = Utils.translateToLocal("gui.menu.main.time.spent", new Object[0]) + ": " + time;
        int n3 = (int)(this.topBarHeight + this.middleHeight);
        this.field_230706_i_.field_71466_p.getClass();
        MenuBackground.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)fontRenderer3, (String)string3, (int)5, (int)(n3 + 9 * 3 - 7), (int)4378367);
        matrixStack.func_227865_b_();
    }

    public void drawTip(MatrixStack matrixStack) {
        this.tip = null;
        int i = 0;
        for (Widget btn : this.field_230710_m_) {
            if (!(btn instanceof MenuButtonBase)) continue;
            ++i;
            if (!btn.func_230449_g_()) continue;
            this.selected = -1;
            this.clearButtons();
            if (!(btn instanceof MenuButton) || !btn.field_230694_p_) continue;
            this.tip = ((MenuButton)btn).getTip();
        }
        if (this.tip != null) {
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)1.1f, (float)1.1f, (float)1.0f);
            RenderSystem.translatef((float)0.0f, (float)-5.0f, (float)0.0f);
            Utils.drawSplitString(this.field_230706_i_.field_71466_p, Utils.translateToLocal(this.tip, new Object[0]), (int)(this.bottomLeftBarWidth + this.bottomGap), (int)(this.topBarHeight + this.middleHeight), (int)((float)this.field_230708_k_ * 0.5f), 0xFF9900);
            RenderSystem.popMatrix();
        }
    }

    public static String getWorldMinutes(World world) {
        int time = (int)Math.abs((world.func_82737_E() + 6000L) % 24000L);
        if (time % 1000 * 6 / 100 < 10) {
            return "0" + time % 1000 * 6 / 100;
        }
        return Integer.toString(time % 1000 * 6 / 100);
    }

    public static int getWorldHours(World world) {
        int time = (int)Math.abs((world.func_82737_E() + 6000L) % 24000L);
        return (int)((float)time / 1000.0f);
    }

    public void func_231160_c_() {
        this.topBarHeight = (float)this.field_230709_l_ * 0.17f;
        this.bottomBarHeight = (float)this.field_230709_l_ * 0.23f;
        this.topLeftBarWidth = (float)this.field_230708_k_ * 0.175f;
        this.topRightBarWidth = (float)this.field_230708_k_ * 0.82f;
        this.topGap = (float)this.field_230708_k_ * 0.005f;
        this.bottomLeftBarWidth = (float)this.field_230708_k_ * 0.304f;
        this.bottomRightBarWidth = (float)this.field_230708_k_ * 0.6875f;
        this.bottomGap = (float)this.field_230708_k_ * 0.0085f;
        this.middleHeight = (float)this.field_230709_l_ * 0.6f;
        this.topLeftBar = new MenuBar(-10, -10, (int)this.topLeftBarWidth + 10, (int)this.topBarHeight + 10, true);
        this.topRightBar = new MenuBar((int)(this.topLeftBarWidth + this.topGap), -10, (int)this.topRightBarWidth + 10, (int)this.topBarHeight + 10, true);
        this.bottomLeftBar = new MenuBar(-10, (int)(this.topBarHeight + this.middleHeight), (int)this.bottomLeftBarWidth + 10, (int)this.bottomBarHeight + 10, false);
        this.bottomRightBar = new MenuBar((int)(this.bottomLeftBarWidth + this.bottomGap), (int)(this.topBarHeight + this.middleHeight), (int)this.bottomRightBarWidth + 10, (int)this.bottomBarHeight + 10, false);
        this.buttonPosX = (float)this.field_230708_k_ * 0.03f;
        this.buttonPosY = (int)this.topBarHeight + 5;
        this.buttonWidth = (float)this.field_230708_k_ * 0.1744f - 22.0f;
    }

    protected void drawBackground(int screenWidth, int screenHeight, boolean drawPlayer) {
    }
}

