/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements.buttons;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButtonBase;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MenuButton
extends MenuButtonBase {
    private ResourceLocation texture = new ResourceLocation("kingdomkeys", "textures/gui/menu/menu_button.png");
    private int endWidth = 11;
    private int bLeftU = 0;
    private int bMiddleU = 12;
    private int bRightU = 14;
    private int bVPos = 0;
    private int bSelectedVPos = 20;
    private int sbLeftU = 22;
    private int sbMiddleU = 34;
    private int sbRightU = 36;
    private int sbVPos = 118;
    private int sbSelectedVPos = 138;
    private int middleWidth;
    private String data;
    private String tip;
    Ability.AbilityType abilityType;
    ButtonType type;
    private boolean selected;

    public MenuButton(int x, int y, int widthIn, String buttonText, ButtonType type, Button.IPressable onPress) {
        super(x, y, 22 + widthIn, 20, Utils.translateToLocal(buttonText, new Object[0]), onPress);
        this.middleWidth = widthIn;
        this.type = type;
    }

    public MenuButton(int x, int y, int widthIn, String buttonText, ButtonType type, boolean hasTooltip, Button.IPressable onPress) {
        this(x, y, widthIn, buttonText, type, onPress);
        if (hasTooltip) {
            this.tip = buttonText + ".desc";
        }
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getTip() {
        return this.tip;
    }

    public void setTip(String tip) {
        this.tip = tip;
    }

    @ParametersAreNonnullByDefault
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        boolean bl = this.field_230692_n_ = mouseX > this.field_230690_l_ + 1 && mouseY >= this.field_230691_m_ + 1 && mouseX < this.field_230690_l_ + this.field_230688_j_ - 1 && mouseY < this.field_230691_m_ + this.field_230689_k_ - 1;
        if (this.field_230694_p_) {
            matrixStack.func_227860_a_();
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(this.texture);
            if (this.field_230692_n_ && this.field_230693_o_) {
                this.field_230690_l_ += 10;
                this.drawButton(matrixStack, true);
                MenuButton.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (ITextComponent)this.func_230458_i_(), (int)(this.field_230690_l_ + 12), (int)(this.field_230691_m_ + 6), (int)new Color(255, 255, 255).hashCode());
                this.field_230690_l_ -= 10;
            } else if (this.field_230693_o_) {
                this.drawButton(matrixStack, false);
                MenuButton.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (ITextComponent)this.func_230458_i_(), (int)(this.field_230690_l_ + 12), (int)(this.field_230691_m_ + 6), (int)new Color(255, 255, 255).hashCode());
            } else if (this.selected) {
                this.field_230690_l_ += 10;
                this.drawButton(matrixStack, false);
                MenuButton.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (ITextComponent)this.func_230458_i_(), (int)(this.field_230690_l_ + 12), (int)(this.field_230691_m_ + 6), (int)new Color(100, 100, 100).hashCode());
                this.field_230690_l_ -= 10;
            } else {
                this.drawButton(matrixStack, false);
                MenuButton.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (ITextComponent)this.func_230458_i_(), (int)(this.field_230690_l_ + 12), (int)(this.field_230691_m_ + 6), (int)new Color(100, 100, 100).hashCode());
            }
            RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            matrixStack.func_227865_b_();
        }
    }

    private void drawButton(MatrixStack matrixStack, boolean hovered) {
        int leftU = 0;
        int middleU = 0;
        int rightU = 0;
        int vPos = 0;
        int selVPos = 0;
        switch (this.type) {
            case BUTTON: {
                leftU = this.bLeftU;
                middleU = this.bMiddleU;
                rightU = this.bRightU;
                vPos = this.bVPos;
                selVPos = this.bSelectedVPos;
                break;
            }
            case SUBBUTTON: {
                leftU = this.sbLeftU;
                middleU = this.sbMiddleU;
                rightU = this.sbRightU;
                vPos = this.sbVPos;
                selVPos = this.sbSelectedVPos;
            }
        }
        vPos = hovered || this.selected ? selVPos : vPos;
        this.func_238474_b_(matrixStack, this.field_230690_l_, this.field_230691_m_, leftU, vPos, this.endWidth, this.field_230689_k_);
        for (int i = 0; i < this.middleWidth; ++i) {
            this.func_238474_b_(matrixStack, this.field_230690_l_ + i + this.endWidth, this.field_230691_m_, middleU, vPos, 1, this.field_230689_k_);
        }
        this.func_238474_b_(matrixStack, this.field_230690_l_ + this.endWidth + this.middleWidth, this.field_230691_m_, rightU, vPos, this.endWidth, this.field_230689_k_);
    }

    public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
        if (this.field_230692_n_) {
            return super.func_231044_a_(p_mouseClicked_1_, p_mouseClicked_3_, p_mouseClicked_5_);
        }
        return false;
    }

    public boolean func_230449_g_() {
        return this.field_230692_n_;
    }

    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void func_230988_a_(SoundHandler soundHandlerIn) {
        soundHandlerIn.func_147682_a((ISound)SimpleSound.func_194007_a((SoundEvent)((SoundEvent)ModSounds.menu_select.get()), (float)1.0f, (float)1.0f));
    }

    public static enum ButtonType {
        BUTTON,
        SUBBUTTON;

    }
}

