/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.abilities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.GuiHelper;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuAbilitiesButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSSetEquippedAbilityPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MenuAbilitiesScreen
extends MenuBackground {
    IPlayerCapabilities playerData;
    LinkedHashMap<String, int[]> abilitiesMap;
    List<MenuAbilitiesButton> abilities;
    MenuBox box;
    Button prev;
    Button next;
    MenuButton back;
    int page;
    int itemsPerPage;
    Ability hoveredAbility;

    public MenuAbilitiesScreen() {
        super("gui.menu.main.button.abilities", new Color(0, 0, 255));
        this.playerData = ModCapabilities.getPlayer((PlayerEntity)this.field_230706_i_.field_71439_g);
        this.abilities = new ArrayList<MenuAbilitiesButton>();
        this.page = 0;
    }

    protected void action(String string) {
        switch (string) {
            case "prev": {
                --this.page;
                this.field_230706_i_.field_71441_e.func_184133_a((PlayerEntity)this.field_230706_i_.field_71439_g, this.field_230706_i_.field_71439_g.func_233580_cy_(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                break;
            }
            case "next": {
                ++this.page;
                this.field_230706_i_.field_71441_e.func_184133_a((PlayerEntity)this.field_230706_i_.field_71439_g, this.field_230706_i_.field_71439_g.func_233580_cy_(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public void func_231160_c_() {
        this.abilitiesMap = Utils.getSortedAbilities(this.playerData.getAbilityMap());
        this.field_230708_k_ = this.field_230708_k_;
        this.field_230709_l_ = this.field_230709_l_;
        super.func_231160_c_();
        this.field_230710_m_.clear();
        this.field_230705_e_.clear();
        this.abilities.clear();
        float boxPosX = (float)this.field_230708_k_ * 0.2f;
        float topBarHeight = (float)this.field_230709_l_ * 0.17f;
        float boxWidth = (float)this.field_230708_k_ * 0.45f;
        float middleHeight = (float)this.field_230709_l_ * 0.6f;
        this.box = new MenuBox((int)boxPosX, (int)topBarHeight, (int)boxWidth, (int)middleHeight, new Color(4, 4, 68));
        int buttonPosX = (int)boxPosX + 10;
        int buttonPosY = (int)topBarHeight + 5;
        int buttonWidth = 100;
        int i = 0;
        for (i = 0; i < this.abilitiesMap.size(); ++i) {
            String abilityName = (String)this.abilitiesMap.keySet().toArray()[i];
            Ability ability = (Ability)ModAbilities.registry.getValue(new ResourceLocation(abilityName));
            String path = new ResourceLocation(abilityName).func_110623_a();
            this.abilities.add(new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, Utils.translateToLocal(path, new Object[0]), ability.getType(), e -> this.action(ability)));
            this.abilities.get((int)i).field_230694_p_ = false;
        }
        this.abilities.forEach(arg_0 -> ((MenuAbilitiesScreen)this).func_230480_a_(arg_0));
        this.back = new MenuButton((int)this.buttonPosX, this.buttonPosY, (int)this.buttonWidth, new TranslationTextComponent("gui.menu.back").getString(), MenuButton.ButtonType.BUTTON, b -> GuiHelper.openMenu());
        this.func_230480_a_((Widget)this.back);
        this.prev = new Button(buttonPosX + 10, (int)((float)this.field_230709_l_ * 0.1f), 30, 20, (ITextComponent)new TranslationTextComponent(Utils.translateToLocal("<--", new Object[0])), e -> this.action("prev"));
        this.func_230480_a_((Widget)this.prev);
        this.next = new Button(buttonPosX + 10 + 76, (int)((float)this.field_230709_l_ * 0.1f), 30, 20, (ITextComponent)new TranslationTextComponent(Utils.translateToLocal("-->", new Object[0])), e -> this.action("next"));
        this.func_230480_a_((Widget)this.next);
        this.prev.field_230694_p_ = false;
        this.next.field_230694_p_ = false;
        this.itemsPerPage = (int)(middleHeight / 19.0f);
    }

    private void action(Ability ability) {
        String abilityName = ability.getRegistryName().toString();
        int apCost = ((Ability)ModAbilities.registry.getValue(new ResourceLocation(abilityName))).getAPCost();
        int lvlIncrease = 0;
        if (this.playerData.isAbilityEquipped(abilityName)) {
            lvlIncrease = -1;
        } else {
            if (Utils.getConsumedAP(this.playerData) + apCost > this.playerData.getMaxAP()) {
                return;
            }
            lvlIncrease = 1;
        }
        if (lvlIncrease != 0) {
            this.playerData.addEquippedAbilityLevel(abilityName, lvlIncrease);
            PacketHandler.sendToServer(new CSSetEquippedAbilityPacket(abilityName, lvlIncrease));
            this.func_231160_c_();
        }
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int i;
        this.box.draw(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.drawAP(matrixStack);
        this.prev.field_230694_p_ = this.page > 0;
        this.next.field_230694_p_ = this.page < this.abilities.size() / this.itemsPerPage;
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)(this.prev.field_230690_l_ + this.prev.func_230998_h_() + 5), (double)this.field_230709_l_ * 0.15 - 18.0, 1.0);
        MenuAbilitiesScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)Utils.translateToLocal("Page: " + (this.page + 1), new Object[0]), (int)0, (int)10, (int)0xFF9900);
        matrixStack.func_227865_b_();
        for (i = 0; i < this.abilities.size(); ++i) {
            this.abilities.get((int)i).field_230694_p_ = false;
        }
        for (i = this.page * this.itemsPerPage; i < this.page * this.itemsPerPage + this.itemsPerPage; ++i) {
            if (i >= this.abilities.size() || this.abilities.get(i) == null) continue;
            this.abilities.get((int)i).field_230694_p_ = true;
            this.abilities.get((int)i).field_230691_m_ = (int)this.topBarHeight + i % this.itemsPerPage * 19 + 2;
            this.abilities.get(i).func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        this.prev.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.next.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.back.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        if (this.hoveredAbility != null) {
            this.renderSelectedData(mouseX, mouseY, partialTicks);
        }
    }

    protected void renderSelectedData(int mouseX, int mouseY, float partialTicks) {
        float tooltipPosX = (float)this.field_230708_k_ * 0.22f;
        float tooltipPosY = (float)this.field_230709_l_ * 0.77f;
        Utils.drawSplitString(this.field_230712_o_, new TranslationTextComponent(this.hoveredAbility.getTranslationKey().replace(".name", ".desc")).getString(), (int)tooltipPosX + 60, (int)tooltipPosY + 15, (int)((float)this.field_230708_k_ * 0.6f), 65535);
    }

    private void drawAP(MatrixStack matrixStack) {
        int j;
        int percent;
        int requiredAP;
        int j2;
        int consumedAP = Utils.getConsumedAP(this.playerData);
        int maxAP = this.playerData.getMaxAP();
        this.hoveredAbility = null;
        for (int i = 0; i < this.abilitiesMap.size(); ++i) {
            String abilityName = (String)this.abilitiesMap.keySet().toArray()[i];
            Ability ability = (Ability)ModAbilities.registry.getValue(new ResourceLocation(abilityName));
            this.abilities.get((int)i).equipped = this.playerData.isAbilityEquipped(abilityName);
            String lvl = "";
            if (ability.getType() == Ability.AbilityType.GROWTH) {
                int level = this.playerData.getEquippedAbilityLevel(abilityName)[0];
                lvl = lvl + "_" + level;
            }
            abilityName = ability.getTranslationKey();
            String text = Utils.translateToLocal(new StringBuilder(abilityName).insert(abilityName.lastIndexOf(46), lvl).toString(), new Object[0]);
            if (!(this.field_230710_m_.get(i) instanceof MenuAbilitiesButton)) continue;
            MenuAbilitiesButton button = (MenuAbilitiesButton)((Object)this.field_230710_m_.get(i));
            if (ability.getAPCost() > this.playerData.getMaxAP() - consumedAP) {
                button.field_230693_o_ = false;
            }
            if (this.playerData.isAbilityEquipped(ability.getRegistryName().toString())) {
                button.field_230693_o_ = true;
            }
            button.func_238482_a_((ITextComponent)new TranslationTextComponent(text));
            button.setAP(ability.getAPCost());
            if (!button.func_230449_g_()) continue;
            this.hoveredAbility = ability;
        }
        int screenWidth = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
        int screenHeight = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
        int barWidth = 100;
        int posX = screenWidth - barWidth;
        int posY = screenHeight - 100;
        float scale = 1.0f;
        this.field_230706_i_.field_71446_o.func_110577_a(new ResourceLocation("kingdomkeys", "textures/gui/menu/menu_button.png"));
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)((float)(posX - 2) * scale - 20.0f), (double)((float)posY * scale - 10.0f), 0.0);
        matrixStack.func_227860_a_();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.func_238474_b_(matrixStack, 0, 0, 143, 67, 7, 25);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        for (j2 = 0; j2 < barWidth; ++j2) {
            this.func_238474_b_(matrixStack, 7 + j2, 0, 151, 67, 1, 25);
        }
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.func_238474_b_(matrixStack, 7 + barWidth, 0, 153, 67, 7, 25);
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        for (j2 = 0; j2 < barWidth; ++j2) {
            this.func_238474_b_(matrixStack, j2 + 7, 17, 161, 67, 1, 25);
        }
        matrixStack.func_227865_b_();
        int n = requiredAP = this.hoveredAbility != null ? this.hoveredAbility.getAPCost() : 0;
        if (this.hoveredAbility != null && this.playerData.isAbilityEquipped(this.hoveredAbility.getRegistryName().toString())) {
            requiredAP *= -1;
            matrixStack.func_227860_a_();
            percent = consumedAP * barWidth / maxAP;
            matrixStack.func_227860_a_();
            for (j = 0; j < percent; ++j) {
                this.func_238474_b_(matrixStack, j + 7, 17, 165, 67, 1, 5);
            }
            matrixStack.func_227865_b_();
            matrixStack.func_227865_b_();
        } else if (consumedAP + requiredAP <= this.playerData.getMaxAP()) {
            matrixStack.func_227860_a_();
            percent = (consumedAP + requiredAP) * barWidth / maxAP;
            matrixStack.func_227860_a_();
            for (j = 0; j < percent; ++j) {
                this.func_238474_b_(matrixStack, j + 7, 17, 167, 67, 1, 5);
            }
            matrixStack.func_227865_b_();
            matrixStack.func_227865_b_();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.func_227860_a_();
        percent = consumedAP * barWidth / maxAP;
        if (requiredAP < 0) {
            percent = (consumedAP + requiredAP) * barWidth / maxAP;
        }
        for (j = 0; j < percent; ++j) {
            this.func_238474_b_(matrixStack, j + 7, 17, 163, 67, 1, 5);
        }
        matrixStack.func_227865_b_();
        matrixStack.func_227860_a_();
        matrixStack.func_227862_a_(scale * 1.3f, scale * 1.1f, 0.0f);
        MenuAbilitiesScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(Utils.translateToLocal("gui.menu.status.ap", new Object[0]) + ": " + consumedAP + "/" + maxAP), (int)16, (int)5, (int)0xFFFFFF);
        matrixStack.func_227865_b_();
        matrixStack.func_227865_b_();
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 1) {
            GuiHelper.openMenu();
        }
        return super.func_231044_a_(mouseX, mouseY, mouseButton);
    }
}

