/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.synthesis;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterable;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuScrollBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuStockItem;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisScreen;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSSynthesiseKeyblade;
import online.kingdomkeys.kingdomkeys.synthesis.material.Material;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class SynthesisCreateScreen
extends MenuFilterable {
    MenuScrollBar scrollBar;
    MenuBox boxL;
    MenuBox boxM;
    MenuBox boxR;
    int itemsX = 100;
    int itemsY = 100;
    int itemWidth = 140;
    int itemHeight = 10;
    Button prev;
    Button next;
    Button create;
    int itemsPerPage;
    private MenuButton back;

    public SynthesisCreateScreen() {
        super("Synthesis", new Color(0, 255, 0));
        this.drawSeparately = true;
    }

    protected void action(String string) {
        switch (string) {
            case "prev": {
                --this.page;
                this.field_230706_i_.field_71441_e.func_184133_a((PlayerEntity)this.field_230706_i_.field_71439_g, this.field_230706_i_.field_71439_g.func_233580_cy_(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                break;
            }
            case "next": {
                ++this.page;
                this.field_230706_i_.field_71441_e.func_184133_a((PlayerEntity)this.field_230706_i_.field_71439_g, this.field_230706_i_.field_71439_g.func_233580_cy_(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                break;
            }
            case "create": {
                PacketHandler.sendToServer(new CSSynthesiseKeyblade(this.selected.func_77973_b().getRegistryName()));
                this.field_230706_i_.field_71441_e.func_184133_a((PlayerEntity)this.field_230706_i_.field_71439_g, this.field_230706_i_.field_71439_g.func_233580_cy_(), (SoundEvent)ModSounds.itemget.get(), SoundCategory.MASTER, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public void func_231160_c_() {
        float boxPosX = (float)this.field_230708_k_ * 0.1437f;
        float topBarHeight = (float)this.field_230709_l_ * 0.17f;
        float boxWidth = (float)this.field_230708_k_ * 0.35f;
        float middleHeight = (float)this.field_230709_l_ * 0.6f;
        this.boxL = new MenuBox((int)boxPosX, (int)topBarHeight, (int)boxWidth, (int)middleHeight, new Color(4, 4, 68));
        this.boxM = new MenuBox((int)boxPosX + (int)boxWidth, (int)topBarHeight, (int)(boxWidth * 0.46f), (int)middleHeight, new Color(4, 4, 68));
        this.boxR = new MenuBox(this.boxM.field_230690_l_ + (int)(boxWidth * 0.46f), (int)topBarHeight, (int)boxWidth, (int)middleHeight, new Color(4, 4, 68));
        float filterPosX = (float)this.field_230708_k_ * 0.3f;
        float filterPosY = (float)this.field_230709_l_ * 0.02f;
        this.filterBar = new MenuFilterBar((int)filterPosX, (int)filterPosY, this);
        this.filterBar.init();
        this.initItems();
        this.buttonPosX -= 10.0f;
        this.buttonWidth = (float)this.field_230708_k_ * 0.07f;
        super.func_231160_c_();
        this.itemsPerPage = (int)(middleHeight / 14.0f);
    }

    @Override
    public void initItems() {
        int i;
        ClientPlayerEntity player = this.field_230706_i_.field_71439_g;
        float invPosX = (float)this.field_230708_k_ * 0.1494f;
        float invPosY = (float)this.field_230709_l_ * 0.1851f;
        this.inventory.clear();
        this.field_230705_e_.clear();
        this.field_230710_m_.clear();
        this.filterBar.buttons.forEach(arg_0 -> ((SynthesisCreateScreen)this).func_230480_a_(arg_0));
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
        for (i = 0; i < playerData.getKnownRecipeList().size(); ++i) {
            ResourceLocation itemName = playerData.getKnownRecipeList().get(i);
            Recipe recipe = RecipeRegistry.getInstance().getValue(itemName);
            ItemStack stack2 = new ItemStack((IItemProvider)recipe.getResult());
            if (recipe.getResult() instanceof KeychainItem) {
                stack2 = new ItemStack((IItemProvider)((KeychainItem)recipe.getResult()).getKeyblade());
            }
            if (!this.filterItem(stack2)) continue;
            items.add(stack2);
        }
        items.sort(Comparator.comparing(Utils::getCategoryForStack).thenComparing(stack -> stack.func_200301_q().func_150261_e()));
        for (i = 0; i < items.size(); ++i) {
            this.inventory.add(new MenuStockItem(this, (ItemStack)items.get(i), (int)invPosX, (int)invPosY + i * 14, false));
        }
        this.inventory.forEach(arg_0 -> ((SynthesisCreateScreen)this).func_230480_a_(arg_0));
        super.func_231160_c_();
        float buttonPosX = (float)this.field_230708_k_ * 0.03f;
        this.prev = new Button((int)buttonPosX + 10, (int)((float)this.field_230709_l_ * 0.1f), 30, 20, (ITextComponent)new TranslationTextComponent(Utils.translateToLocal("<--", new Object[0])), e -> this.action("prev"));
        this.func_230480_a_((Widget)this.prev);
        this.next = new Button((int)buttonPosX + 10 + 76, (int)((float)this.field_230709_l_ * 0.1f), 30, 20, (ITextComponent)new TranslationTextComponent(Utils.translateToLocal("-->", new Object[0])), e -> this.action("next"));
        this.func_230480_a_((Widget)this.next);
        this.create = new Button(this.boxM.field_230690_l_ + 3, (int)((double)this.field_230709_l_ * 0.67), 70, 20, (ITextComponent)new TranslationTextComponent(Utils.translateToLocal("gui.synthesis.synthesise.create", new Object[0])), e -> this.action("create"));
        this.func_230480_a_((Widget)this.create);
        this.back = new MenuButton((int)this.buttonPosX, this.buttonPosY, (int)this.buttonWidth / 2, new TranslationTextComponent("gui.menu.back").getString(), MenuButton.ButtonType.BUTTON, b -> this.field_230706_i_.func_147108_a((Screen)new SynthesisScreen()));
        this.func_230480_a_((Widget)this.back);
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int i;
        this.drawMenuBackground(matrixStack, mouseX, mouseY, partialTicks);
        this.boxL.draw(matrixStack);
        this.boxM.draw(matrixStack);
        this.boxR.draw(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.prev.field_230694_p_ = this.page > 0;
        boolean bl = this.next.field_230694_p_ = this.page < this.inventory.size() / this.itemsPerPage;
        if (this.selected != ItemStack.field_190927_a) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)this.field_230706_i_.field_71439_g);
            boolean enoughMats = true;
            if (RecipeRegistry.getInstance().containsKey(this.selected.func_77973_b().getRegistryName())) {
                Recipe recipe = RecipeRegistry.getInstance().getValue(this.selected.func_77973_b().getRegistryName());
                this.create.field_230694_p_ = true;
                for (Map.Entry<Material, Integer> m : recipe.getMaterials().entrySet()) {
                    if (playerData.getMaterialAmount(m.getKey()) >= m.getValue()) continue;
                    enoughMats = false;
                }
            }
            this.create.field_230693_o_ = enoughMats;
            if (this.field_230706_i_.field_71439_g.field_71071_by.func_70447_i() == -1) {
                this.create.field_230693_o_ = false;
                this.create.func_238482_a_((ITextComponent)new TranslationTextComponent("No empty slot"));
            }
            this.create.field_230694_p_ = RecipeRegistry.getInstance().containsKey(this.selected.func_77973_b().getRegistryName());
        } else {
            this.create.field_230694_p_ = false;
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)((float)this.field_230708_k_ * 0.03f + 45.0f), (double)this.field_230709_l_ * 0.15 - 18.0, 1.0);
        SynthesisCreateScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)Utils.translateToLocal("Page: " + (this.page + 1), new Object[0]), (int)0, (int)10, (int)0xFF9900);
        matrixStack.func_227865_b_();
        for (i = 0; i < this.inventory.size(); ++i) {
            ((MenuStockItem)((Object)this.inventory.get((int)i))).field_230693_o_ = false;
        }
        for (i = this.page * this.itemsPerPage; i < this.page * this.itemsPerPage + this.itemsPerPage; ++i) {
            if (i >= this.inventory.size() || this.inventory.get(i) == null) continue;
            ((MenuStockItem)((Object)this.inventory.get((int)i))).field_230694_p_ = true;
            ((MenuStockItem)((Object)this.inventory.get((int)i))).field_230691_m_ = (int)this.topBarHeight + i % this.itemsPerPage * 14 + 5;
            ((MenuStockItem)((Object)this.inventory.get(i))).func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            ((MenuStockItem)((Object)this.inventory.get((int)i))).field_230693_o_ = true;
        }
        this.prev.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.next.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.create.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.back.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderSelectedData(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        float tooltipPosX = (float)this.field_230708_k_ * 0.3333f;
        float tooltipPosY = (float)this.field_230709_l_ * 0.8f;
        float iconPosX = this.boxR.field_230690_l_;
        float iconPosY = this.boxR.field_230691_m_ + 25;
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)this.field_230706_i_.field_71439_g);
        RenderHelper.func_74518_a();
        RenderSystem.pushMatrix();
        double offset = (float)this.boxM.func_230998_h_() * 0.1f;
        RenderSystem.translated((double)((double)this.boxM.field_230690_l_ + offset / 2.0), (double)iconPosY, (double)1.0);
        RenderSystem.scalef((float)((float)((double)((float)this.boxM.func_230998_h_() / 20.0f) - offset / 20.0)), (float)((float)((double)((float)this.boxM.func_230998_h_() / 20.0f) - offset / 20.0)), (float)1.0f);
        this.field_230707_j_.func_175042_a(this.selected, 0, 0);
        RenderSystem.popMatrix();
        if (this.selected.func_77973_b() != null && this.selected.func_77973_b() instanceof KeybladeItem) {
            KeybladeItem kb = (KeybladeItem)this.selected.func_77973_b();
            matrixStack.func_227860_a_();
            String text = Utils.translateToLocal(this.selected.func_77977_a(), new Object[0]);
            SynthesisCreateScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)text, (int)((int)(tooltipPosX + 5.0f)), (int)((int)tooltipPosY + 5), (int)0xFF9900);
            String string = kb.getDescription();
            int n = (int)tooltipPosX + 5;
            int n2 = (int)tooltipPosY + 5;
            this.field_230706_i_.field_71466_p.getClass();
            Utils.drawSplitString(this.field_230712_o_, string, n, n2 + 9, (int)((float)this.field_230708_k_ * 0.6f), 0xFFFFFF);
            matrixStack.func_227865_b_();
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)(this.boxM.field_230690_l_ + 10), (double)this.field_230709_l_ * 0.58, 1.0);
            SynthesisCreateScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(Utils.translateToLocal("gui.menu.status.strength", new Object[0]) + ": " + kb.getStrength(0)), (int)0, (int)0, (int)0xFF0000);
            SynthesisCreateScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(Utils.translateToLocal("gui.menu.status.magic", new Object[0]) + ": " + kb.getMagic(0)), (int)0, (int)10, (int)0x4444FF);
            matrixStack.func_227865_b_();
        }
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)(iconPosX + 20.0f), (double)((double)this.field_230709_l_ * 0.2), (double)1.0);
        if (RecipeRegistry.getInstance().containsKey(this.selected.func_77973_b().getRegistryName())) {
            Recipe recipe = RecipeRegistry.getInstance().getValue(this.selected.func_77973_b().getRegistryName());
            Iterator<Map.Entry<Material, Integer>> materials = Utils.getSortedMaterials(recipe.getMaterials()).entrySet().iterator();
            int i = 0;
            while (materials.hasNext()) {
                Map.Entry<Material, Integer> m = materials.next();
                ItemStack stack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(m.getKey().getMaterialName())), m.getValue().intValue());
                String n = Utils.translateToLocal(stack.func_77977_a(), new Object[0]);
                int color = playerData.getMaterialAmount(m.getKey()) >= m.getValue() ? 65280 : 0xFF0000;
                SynthesisCreateScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)(n + " x" + m.getValue() + " (" + playerData.getMaterialAmount(m.getKey()) + ")"), (int)0, (int)(i * 16), (int)color);
                this.field_230707_j_.func_175042_a(stack, -17, i * 16 - 4);
                ++i;
            }
        }
        RenderSystem.popMatrix();
    }

    public boolean func_231177_au__() {
        return false;
    }
}

