/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.synthesis;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterable;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuStockItem;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisScreen;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSDepositMaterials;
import online.kingdomkeys.kingdomkeys.network.cts.CSSyncAllClientDataPacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSTakeMaterials;
import online.kingdomkeys.kingdomkeys.synthesis.material.Material;
import online.kingdomkeys.kingdomkeys.synthesis.material.ModMaterials;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class SynthesisMaterialScreen
extends MenuFilterable {
    MenuButton deposit;
    MenuButton back;
    Button prev;
    Button next;
    Button take;
    MenuBox boxL;
    MenuBox boxR;
    TextFieldWidget amountBox;
    int page = 0;
    int itemsPerPage = 14;

    public SynthesisMaterialScreen() {
        super("gui.synthesis.materials", new Color(0, 255, 0));
        this.drawPlayerInfo = true;
    }

    @Override
    public void action(ItemStack stack) {
        super.action(stack);
        this.amountBox.func_146180_a("" + Math.min(64, stack.func_190916_E()));
    }

    protected void action(String string) {
        switch (string) {
            case "prev": {
                --this.page;
                this.field_230706_i_.field_71441_e.func_184133_a((PlayerEntity)this.field_230706_i_.field_71439_g, this.field_230706_i_.field_71439_g.func_233580_cy_(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                break;
            }
            case "next": {
                ++this.page;
                this.field_230706_i_.field_71441_e.func_184133_a((PlayerEntity)this.field_230706_i_.field_71439_g, this.field_230706_i_.field_71439_g.func_233580_cy_(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                break;
            }
            case "deposit": {
                this.field_230706_i_.field_71441_e.func_184133_a((PlayerEntity)this.field_230706_i_.field_71439_g, this.field_230706_i_.field_71439_g.func_233580_cy_(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                ClientPlayerEntity player = this.field_230706_i_.field_71439_g;
                IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stack = player.field_71071_by.func_70301_a(i);
                    if (ItemStack.func_77989_b((ItemStack)stack, (ItemStack)ItemStack.field_190927_a) || ModMaterials.registry.getValue(new ResourceLocation("kingdomkeys", "mat_" + stack.func_77973_b().getRegistryName().func_110623_a())) == null) continue;
                    Material mat = (Material)ModMaterials.registry.getValue(new ResourceLocation("kingdomkeys", "mat_" + stack.func_77973_b().getRegistryName().func_110623_a()));
                    playerData.addMaterial(mat, stack.func_190916_E());
                    player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                }
                PacketHandler.sendToServer(new CSDepositMaterials());
                PacketHandler.sendToServer(new CSSyncAllClientDataPacket());
                break;
            }
            case "back": {
                this.field_230706_i_.func_147108_a((Screen)new SynthesisScreen());
                break;
            }
            case "take": {
                if (ItemStack.func_179545_c((ItemStack)this.selected, (ItemStack)ItemStack.field_190927_a) || this.field_230706_i_.field_71439_g.field_71071_by.func_70447_i() <= -1) break;
                try {
                    Integer.parseInt(this.amountBox.func_146179_b());
                    PacketHandler.sendToServer(new CSTakeMaterials(this.selected.func_77973_b(), Integer.parseInt(this.amountBox.func_146179_b())));
                    break;
                }
                catch (Exception e) {
                    System.out.println("NaN " + this.amountBox.func_146179_b());
                }
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
    }

    @Override
    public void func_231160_c_() {
        float boxPosX = (float)this.field_230708_k_ * 0.2f;
        float topBarHeight = (float)this.field_230709_l_ * 0.17f;
        float boxWidth = (float)this.field_230708_k_ * 0.33f;
        float middleHeight = (float)this.field_230709_l_ * 0.6f;
        this.boxL = new MenuBox((int)boxPosX, (int)topBarHeight, (int)boxWidth, (int)middleHeight, new Color(4, 4, 68));
        this.boxR = new MenuBox(this.boxL.field_230690_l_ + this.boxL.func_230998_h_(), (int)topBarHeight, (int)boxWidth, (int)middleHeight, new Color(4, 4, 68));
        super.func_231160_c_();
        this.initItems();
        this.itemsPerPage = (int)(middleHeight / 14.0f);
    }

    @Override
    public void initItems() {
        float buttonPosX = (float)this.field_230708_k_ * 0.008f;
        int button_statsY = (int)this.topBarHeight + 10;
        float buttonWidth = (float)this.field_230708_k_ * 0.1744f - 20.0f;
        float invPosX = this.boxL.field_230690_l_;
        float invPosY = (float)this.field_230709_l_ * 0.1851f;
        this.inventory.clear();
        this.field_230705_e_.clear();
        this.field_230710_m_.clear();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)this.field_230706_i_.field_71439_g);
        for (Map.Entry<String, Integer> mat : playerData.getMaterialMap().entrySet()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(mat.getKey()));
            items.add(new ItemStack((IItemProvider)item, mat.getValue().intValue()));
        }
        items.sort(Comparator.comparing(Utils::getCategoryForStack).thenComparing(stack -> stack.func_77977_a()));
        for (int i = 0; i < items.size(); ++i) {
            this.inventory.add(new MenuStockItem(this, (ItemStack)items.get(i), (int)invPosX, (int)invPosY + i * 14, true));
        }
        this.inventory.forEach(arg_0 -> ((SynthesisMaterialScreen)this).func_230480_a_(arg_0));
        this.prev = new Button((int)buttonPosX + 10, (int)((float)this.field_230709_l_ * 0.1f), 30, 20, (ITextComponent)new TranslationTextComponent(Utils.translateToLocal("<--", new Object[0])), e -> this.action("prev"));
        this.func_230480_a_((Widget)this.prev);
        this.next = new Button((int)buttonPosX + 10 + 76, (int)((float)this.field_230709_l_ * 0.1f), 30, 20, (ITextComponent)new TranslationTextComponent(Utils.translateToLocal("-->", new Object[0])), e -> this.action("next"));
        this.func_230480_a_((Widget)this.next);
        this.prev.field_230694_p_ = false;
        this.next.field_230694_p_ = false;
        this.deposit = new MenuButton((int)buttonPosX, button_statsY + 0, (int)buttonWidth, Utils.translateToLocal("gui.synthesis.materials.deposit", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("deposit"));
        this.func_230480_a_((Widget)this.deposit);
        this.back = new MenuButton((int)buttonPosX, button_statsY + 18, (int)buttonWidth, Utils.translateToLocal("gui.menu.back", new Object[0]), MenuButton.ButtonType.BUTTON, e -> this.action("back"));
        this.func_230480_a_((Widget)this.back);
        this.amountBox = new TextFieldWidget(this.field_230706_i_.field_71466_p, this.boxR.field_230690_l_ + 50, (int)(this.topBarHeight + this.middleHeight - 20.0f), this.field_230706_i_.field_71466_p.func_78256_a("#####"), 16, (ITextComponent)new TranslationTextComponent("test")){

            public boolean func_231042_a_(char c, int i) {
                if (Utils.isNumber(c)) {
                    String text = new StringBuilder(this.func_146179_b()).insert(this.func_146198_h(), c).toString();
                    if (Integer.parseInt(text) > 64) {
                        return false;
                    }
                } else {
                    return false;
                }
                return super.func_231042_a_(c, i);
            }
        };
        this.func_230480_a_((Widget)this.amountBox);
        this.take = new Button(this.amountBox.field_230690_l_ + this.amountBox.func_230998_h_() + 1, (int)(this.topBarHeight + this.middleHeight - 22.0f), 50, 20, (ITextComponent)new TranslationTextComponent(Utils.translateToLocal("gui.synthesis.materials.take", new Object[0])), e -> this.action("take"));
        this.func_230480_a_((Widget)this.take);
        this.take.field_230694_p_ = false;
        this.updateButtons();
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int i;
        this.drawMenuBackground(matrixStack, mouseX, mouseY, partialTicks);
        this.boxL.draw(matrixStack);
        this.boxR.draw(matrixStack);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.prev.field_230694_p_ = this.page > 0;
        boolean bl = this.next.field_230694_p_ = this.page < this.inventory.size() / this.itemsPerPage;
        if (this.field_230706_i_.field_71439_g.field_71071_by.func_70447_i() == -1) {
            this.take.field_230693_o_ = false;
            this.take.func_238482_a_((ITextComponent)new TranslationTextComponent("No empty slot"));
        }
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_((double)((float)this.field_230708_k_ * 0.008f + 45.0f), (double)this.field_230709_l_ * 0.15 - 18.0, 1.0);
        SynthesisMaterialScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)Utils.translateToLocal("Page: " + (this.page + 1), new Object[0]), (int)0, (int)10, (int)0xFF9900);
        matrixStack.func_227865_b_();
        for (i = 0; i < this.inventory.size(); ++i) {
            ((MenuStockItem)((Object)this.inventory.get((int)i))).field_230693_o_ = false;
        }
        for (i = this.page * this.itemsPerPage; i < this.page * this.itemsPerPage + this.itemsPerPage; ++i) {
            if (i >= this.inventory.size() || this.inventory.get(i) == null) continue;
            ((MenuStockItem)((Object)this.inventory.get((int)i))).field_230694_p_ = true;
            ((MenuStockItem)((Object)this.inventory.get((int)i))).field_230691_m_ = (int)this.topBarHeight + i % this.itemsPerPage * 14 + 5;
            ((MenuStockItem)((Object)this.inventory.get(i))).func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            ((MenuStockItem)((Object)this.inventory.get((int)i))).field_230693_o_ = true;
        }
        this.prev.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.next.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.deposit.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.back.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderSelectedData(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.amountBox.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.take.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.take.field_230694_p_ = true;
        float iconPosX = this.boxR.field_230690_l_;
        float iconPosY = this.boxR.field_230691_m_ + 15;
        matrixStack.func_227860_a_();
        String name = this.selected.func_200301_q().getString();
        matrixStack.func_227861_a_((double)(this.boxR.field_230690_l_ + this.boxR.func_230998_h_() / 2 - this.field_230706_i_.field_71466_p.func_78256_a(name) / 2), (double)(this.boxR.field_230691_m_ + 3), 1.0);
        SynthesisMaterialScreen.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)this.field_230706_i_.field_71466_p, (String)Utils.translateToLocal(name, new Object[0]), (int)0, (int)0, (int)0xFF9900);
        matrixStack.func_227865_b_();
        RenderSystem.pushMatrix();
        double offset = (float)this.boxR.func_230998_h_() * 0.2f;
        RenderSystem.translated((double)((double)iconPosX + offset / 2.0), (double)iconPosY, (double)1.0);
        RenderSystem.scalef((float)((float)((double)(this.boxR.func_230998_h_() / 16) - offset / 16.0)), (float)((float)((double)(this.boxR.func_230998_h_() / 16) - offset / 16.0)), (float)1.0f);
        this.field_230707_j_.func_175042_a(this.selected, 0, 0);
        RenderSystem.popMatrix();
    }

    public boolean func_231177_au__() {
        return false;
    }
}

