/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.awt.Color;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.math.MathHelper;
import online.kingdomkeys.kingdomkeys.client.particle.ModParticles;

public class ExpParticleData
implements IParticleData {
    private Color tint;
    private double diameter;
    public static final IParticleData.IDeserializer<ExpParticleData> DESERIALIZER = new IParticleData.IDeserializer<ExpParticleData>(){

        @Nonnull
        public ExpParticleData deserialize(@Nonnull ParticleType<ExpParticleData> type, @Nonnull StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            double diameter = ExpParticleData.constrainDiameterToValidRange(reader.readDouble());
            boolean MIN_COLOUR = false;
            int MAX_COLOUR = 255;
            reader.expect(' ');
            int red = MathHelper.func_76125_a((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int green = MathHelper.func_76125_a((int)reader.readInt(), (int)0, (int)255);
            reader.expect(' ');
            int blue = MathHelper.func_76125_a((int)reader.readInt(), (int)0, (int)255);
            Color color = new Color(red, green, blue);
            return new ExpParticleData(color, diameter);
        }

        public ExpParticleData read(@Nonnull ParticleType<ExpParticleData> type, PacketBuffer buf) {
            boolean MIN_COLOUR = false;
            int MAX_COLOUR = 255;
            int red = MathHelper.func_76125_a((int)buf.readInt(), (int)0, (int)255);
            int green = MathHelper.func_76125_a((int)buf.readInt(), (int)0, (int)255);
            int blue = MathHelper.func_76125_a((int)buf.readInt(), (int)0, (int)255);
            Color color = new Color(red, green, blue);
            double diameter = ExpParticleData.constrainDiameterToValidRange(buf.readDouble());
            return new ExpParticleData(color, diameter);
        }
    };

    public ExpParticleData(Color tint, double diameter) {
        this.tint = tint;
        this.diameter = ExpParticleData.constrainDiameterToValidRange(diameter);
    }

    public Color getTint() {
        return this.tint;
    }

    public double getDiameter() {
        return this.diameter;
    }

    @Nonnull
    public ParticleType<?> func_197554_b() {
        return (ParticleType)ModParticles.TYPE_EXP.get();
    }

    public void func_197553_a(PacketBuffer buf) {
        buf.writeInt(this.tint.getRed());
        buf.writeInt(this.tint.getGreen());
        buf.writeInt(this.tint.getBlue());
        buf.writeDouble(this.diameter);
    }

    @Nonnull
    public String func_197555_a() {
        return String.format(Locale.ROOT, "%s %.2f %i %i %i", this.func_197554_b().getRegistryName(), this.diameter, this.tint.getRed(), this.tint.getGreen(), this.tint.getBlue());
    }

    private static double constrainDiameterToValidRange(double diameter) {
        double MIN_DIAMETER = 0.05;
        double MAX_DIAMETER = 1.0;
        return MathHelper.func_151237_a((double)diameter, (double)0.05, (double)1.0);
    }
}

