/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.render.block;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.items.CapabilityItemHandler;
import online.kingdomkeys.kingdomkeys.entity.block.PedestalTileEntity;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;

public class PedestalRenderer
extends TileEntityRenderer<PedestalTileEntity> {
    private ItemRenderer renderItem;

    public PedestalRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    public void render(PedestalTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        this.renderItem = Minecraft.func_71410_x().func_175599_af();
        if (!tileEntityIn.isStationOfAwakeningMarker()) {
            tileEntityIn.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).ifPresent(iih -> {
                if (!iih.getStackInSlot(0).func_190926_b()) {
                    this.renderItem(tileEntityIn, matrixStackIn, bufferIn, partialTicks, iih.getStackInSlot(0).func_77973_b() instanceof KeychainItem ? new ItemStack((IItemProvider)((KeychainItem)iih.getStackInSlot(0).func_77973_b()).getKeyblade()) : iih.getStackInSlot(0));
                }
            });
        } else if (!tileEntityIn.hide) {
            this.renderItem(tileEntityIn, matrixStackIn, bufferIn, partialTicks, tileEntityIn.getDisplayStack());
        }
    }

    private void renderItem(PedestalTileEntity tileEntity, MatrixStack matrixStack, IRenderTypeBuffer buffer, float partialTicks, ItemStack toRender) {
        float rotation;
        float height;
        matrixStack.func_227860_a_();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!tileEntity.isPaused()) {
            float lerpedTicks = (float)tileEntity.previousTicks + (float)(tileEntity.ticksExisted() - tileEntity.previousTicks) * partialTicks;
            height = tileEntity.getBaseHeight() + 0.1f * (float)Math.sin(tileEntity.getBobSpeed() * lerpedTicks);
            rotation = lerpedTicks * tileEntity.getRotationSpeed() % 360.0f;
            tileEntity.setCurrentTransforms(rotation, height);
        } else {
            height = tileEntity.getSavedHeight();
            rotation = tileEntity.getSavedRotation();
        }
        matrixStack.func_227861_a_(0.5, (double)height, 0.5);
        matrixStack.func_227863_a_(new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), rotation, true));
        matrixStack.func_227862_a_(tileEntity.getScale(), tileEntity.getScale(), tileEntity.getScale());
        this.renderItem.func_229110_a_(toRender, ItemCameraTransforms.TransformType.FIXED, 100, 655360, matrixStack, buffer);
        matrixStack.func_227865_b_();
    }
}

