/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ITeleporter;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.world.dimension.ModDimensions;
import online.kingdomkeys.kingdomkeys.world.utils.BaseTeleporter;

public class DimensionCommand
extends BaseCommand {
    private static final SuggestionProvider<CommandSource> SUGGEST_DIMENSIONS = (p_198296_0_, p_198296_1_) -> {
        ArrayList<String> list = new ArrayList<String>();
        list.add("overworld");
        list.add("the_nether");
        list.add("the_end");
        list.add(ModDimensions.DIVE_TO_THE_HEART.func_240901_a_().toString());
        return ISuggestionProvider.func_197013_a(list.stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)p_198296_1_);
    };

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"kk_dimension").requires(source -> source.func_197034_c(2));
        builder.then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"dim", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_DIMENSIONS).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(DimensionCommand::changeDim))).executes(DimensionCommand::changeDim));
        dispatcher.register(builder);
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
    }

    private static int changeDim(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Collection<ServerPlayerEntity> players = DimensionCommand.getPlayers(context, 2);
        String dim = StringArgumentType.getString(context, (String)"dim");
        RegistryKey dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(dim));
        if (dimension == null) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("Invalid dimension " + dim), true);
            return 1;
        }
        for (ServerPlayerEntity player : players) {
            BlockPos coords = DimensionCommand.getWorldCoords((PlayerEntity)player, (RegistryKey<World>)dimension);
            player.changeDimension(player.func_184102_h().func_71218_a(dimension), (ITeleporter)new BaseTeleporter(coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p()));
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("Teleported" + player.func_145748_c_().getString() + " to dimension " + dimension.getRegistryName().toString()), true);
            player.func_145747_a((ITextComponent)new TranslationTextComponent("You have been teleported to " + dimension.func_240901_a_().toString()), Util.field_240973_b_);
        }
        return 1;
    }

    private static BlockPos getWorldCoords(PlayerEntity player, RegistryKey<World> dimension) {
        if (dimension == ModDimensions.DIVE_TO_THE_HEART) {
            return new BlockPos(0, 26, 0);
        }
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
        if (dimension == playerData.getReturnDimension()) {
            return new BlockPos(playerData.getReturnLocation());
        }
        return new BlockPos(0, 64, 0);
    }
}

