/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class KKDriveLevelCommand
extends BaseCommand {
    private static final SuggestionProvider<CommandSource> SUGGEST_DRIVE_FORMS = (p_198296_0_, p_198296_1_) -> {
        ArrayList<String> list = new ArrayList<String>();
        for (ResourceLocation location : ModDriveForms.registry.getKeys()) {
            if (location.func_110623_a().equals("form_anti")) continue;
            list.add(location.toString());
        }
        return ISuggestionProvider.func_197013_a(list.stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)p_198296_1_);
    };

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"kk_drivelevel").requires(source -> source.func_197034_c(2));
        builder.then(Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"form", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_DRIVE_FORMS).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1, (int)7)).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(KKDriveLevelCommand::setValue))).executes(KKDriveLevelCommand::setValue))));
        dispatcher.register(builder);
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
    }

    private static int setValue(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Collection<ServerPlayerEntity> players = KKDriveLevelCommand.getPlayers(context, 4);
        int level = IntegerArgumentType.getInteger(context, (String)"level");
        String form = StringArgumentType.getString(context, (String)"form");
        for (ServerPlayerEntity player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
            playerData.setDriveFormLevel(form, 1);
            playerData.setDriveFormExp((PlayerEntity)player, form, 0);
            DriveForm drive = (DriveForm)ModDriveForms.registry.getValue(new ResourceLocation(form));
            playerData.setNewKeychain(new ResourceLocation(form), ItemStack.field_190927_a);
            playerData.getAbilityMap().remove(drive.getBaseAbilityForLevel(3));
            while (playerData.getDriveFormLevel(form) < level) {
                int cost = drive.getLevelUpCost(playerData.getDriveFormLevel(form) + 1);
                playerData.setDriveFormExp((PlayerEntity)player, form, cost);
            }
            DriveForm formInstance = (DriveForm)ModDriveForms.registry.getValue(new ResourceLocation(form));
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("Set " + Utils.translateToLocal(formInstance.getTranslationKey(), new Object[0]) + " for " + player.func_145748_c_().getString() + " to level " + level), true);
            player.func_145747_a((ITextComponent)new TranslationTextComponent("Your " + Utils.translateToLocal(formInstance.getTranslationKey(), new Object[0]) + " level is now " + level), Util.field_240973_b_);
        }
        return 1;
    }
}

