/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;

public class KKHeartsCommand
extends BaseCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"kk_hearts").requires(source -> source.func_197034_c(2));
        builder.then(Commands.func_197057_a((String)"set").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(KKHeartsCommand::setValue))).executes(KKHeartsCommand::setValue)));
        builder.then(Commands.func_197057_a((String)"give").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(KKHeartsCommand::addValue))).executes(KKHeartsCommand::addValue)));
        builder.then(Commands.func_197057_a((String)"take").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1, (int)Integer.MAX_VALUE)).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(KKHeartsCommand::removeValue))).executes(KKHeartsCommand::removeValue)));
        dispatcher.register(builder);
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
    }

    private static int setValue(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Collection<ServerPlayerEntity> players = KKHeartsCommand.getPlayers(context, 3);
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        for (ServerPlayerEntity player : players) {
            KKHeartsCommand.setValue(context, value, player);
        }
        return 1;
    }

    private static int setValue(CommandContext<CommandSource> context, int value, ServerPlayerEntity player) throws CommandSyntaxException {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
        playerData.setHearts(value);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("Set " + player.func_145748_c_().getString() + " hearts to " + value), true);
        player.func_145747_a((ITextComponent)new TranslationTextComponent("Your hearts have been set to " + value), Util.field_240973_b_);
        return 1;
    }

    private static int addValue(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Collection<ServerPlayerEntity> players = KKHeartsCommand.getPlayers(context, 3);
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        for (ServerPlayerEntity player : players) {
            KKHeartsCommand.addValue(context, value, player);
        }
        return 1;
    }

    private static int addValue(CommandContext<CommandSource> context, int value, ServerPlayerEntity player) throws CommandSyntaxException {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
        playerData.addHearts(value);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("Added " + value + " hearts to " + player.func_145748_c_().getString()), true);
        player.func_145747_a((ITextComponent)new TranslationTextComponent("Your hearts have been increased by " + value), Util.field_240973_b_);
        return 1;
    }

    private static int removeValue(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Collection<ServerPlayerEntity> players = KKHeartsCommand.getPlayers(context, 3);
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        for (ServerPlayerEntity player : players) {
            KKHeartsCommand.removeValue(context, value, player);
        }
        return 1;
    }

    private static int removeValue(CommandContext<CommandSource> context, int value, ServerPlayerEntity player) throws CommandSyntaxException {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
        playerData.removeHearts(value);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("Taken " + value + " hearts from " + player.func_145748_c_().getString()), true);
        player.func_145747_a((ITextComponent)new TranslationTextComponent("Your hearts have been decreased by " + value), Util.field_240973_b_);
        return 1;
    }
}

