/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import online.kingdomkeys.kingdomkeys.entity.SpawningMode;

public class CommonConfig {
    public ForgeConfigSpec.EnumValue<SpawningMode> heartlessSpawningMode;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> mobSpawnRate;
    public ForgeConfigSpec.BooleanValue oreGen;
    public ForgeConfigSpec.BooleanValue bloxGen;
    public ForgeConfigSpec.BooleanValue debugConsoleOutput;
    public ForgeConfigSpec.BooleanValue bombExplodeWithFire;
    public ForgeConfigSpec.IntValue driveHeal;
    public ForgeConfigSpec.DoubleValue drivePointsMultiplier;
    public ForgeConfigSpec.DoubleValue focusPointsMultiplier;
    public ForgeConfigSpec.DoubleValue limitLaserCircleMult;
    public ForgeConfigSpec.DoubleValue limitLaserDomeMult;
    public ForgeConfigSpec.DoubleValue limitArrowRainMult;
    public ForgeConfigSpec.IntValue hpDropProbability;
    public ForgeConfigSpec.IntValue mpDropProbability;
    public ForgeConfigSpec.IntValue munnyDropProbability;
    public ForgeConfigSpec.IntValue driveDropProbability;
    public ForgeConfigSpec.IntValue focusDropProbability;
    public ForgeConfigSpec.BooleanValue playerSpawnHeartless;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> playerSpawnHeartlessData;
    public ForgeConfigSpec.DoubleValue shotlockMult;

    CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        this.oreGen = builder.comment("Allow Synthesis Materials ores to generate").translation("kingdomkeys.config.ore_gen").define("oreGen", true);
        this.bloxGen = builder.comment("Allow Blox to generate").translation("kingdomkeys.config.blox_gen").define("bloxGen", true);
        this.debugConsoleOutput = builder.comment("Enable debug console output").translation("kingdomkeys.config.debug").define("debugConsoleOutput", false);
        this.bombExplodeWithFire = builder.comment("Allow Bomb heartless to explode when lit on fire").translation("kingdomkeys.config.bomb_explode_with_fire").define("bombExplodeWithfire", true);
        this.driveHeal = builder.comment("Health % restored when using a drive form").translation("kingdomkeys.config.drive_heal").defineInRange("driveHeal", 50, 0, 100);
        this.drivePointsMultiplier = builder.comment("Drive Points Drop Multiplier").translation("kingdomkeys.config.drive_points_multiplier").defineInRange("drivePointsMultiplier", 1.0, 0.0, 100.0);
        this.focusPointsMultiplier = builder.comment("Focus Points Drop Multiplier").translation("kingdomkeys.config.focus_points_multiplier").defineInRange("focusPointsMultiplier", 1.0, 0.0, 100.0);
        builder.pop();
        builder.push("spawning");
        this.heartlessSpawningMode = builder.comment("Heartless spawning mode: NEVER, ALWAYS, AFTER_KEYCHAIN (after the first keychain is synthesized), AFTER_DRAGON (after the Ender Dragon is defeated)").translation("kingdomkeys.config.heartless_spawning_mode").defineEnum("heartlessSpawningMode", (Enum)SpawningMode.AFTER_KEYCHAIN);
        this.mobSpawnRate = builder.comment("Mob Spawn (name, weight, min, max)").translation("kingdomkeys.config.mob_spawn").defineList("mobSpawn", (List)Lists.newArrayList((Object[])new String[]{"Moogle,2,0,1", "Pureblood,2,0,1", "Emblem,2,0,1", "Nobody,2,0,1"}), o -> o instanceof String);
        this.playerSpawnHeartless = builder.comment("Allow a heartless and a nobody to spawn when a player gets killed by a heartless").translation("kingdomkeys.config.player_spawn_heartless").define("playerSpawnHeartless", true);
        this.playerSpawnHeartlessData = builder.comment("Heartless and nobody stats: name, hp (% of the player's), strength (% of the player's)").translation("kingdomkeys.config.player_spawn_heartless_Data").defineList("playerSpawnHeartlessData", (List)Lists.newArrayList((Object[])new String[]{"Heartless,100,100", "Nobody,100,100"}), o -> o instanceof String);
        builder.pop();
        builder.push("drops");
        this.hpDropProbability = builder.comment("HP Drops Probability").translation("kingdomkeys.config.hp_drop_probability").defineInRange("hpDropProbability", 80, 0, 100);
        this.mpDropProbability = builder.comment("MP Drops Probability").translation("kingdomkeys.config.mp_drop_probability").defineInRange("mpDropProbability", 80, 0, 100);
        this.munnyDropProbability = builder.comment("Munny Drops Probability").translation("kingdomkeys.config.munny_drop_probability").defineInRange("munnyDropProbability", 80, 0, 100);
        this.driveDropProbability = builder.comment("Drive Drops Probability").translation("kingdomkeys.config.drive_drop_probability").defineInRange("driveDropProbability", 80, 0, 100);
        this.focusDropProbability = builder.comment("Focus Drops Probability").translation("kingdomkeys.config.focus_drop_probability").defineInRange("focusDropProbability", 80, 0, 100);
        builder.pop();
        builder.push("limits");
        this.limitLaserCircleMult = builder.comment("Laser Circle Damage Multiplier ((strength + magic) / 2 * multiplier)").translation("kingdomkeys.config.laser_circle_mult").defineInRange("laserCircleMult", 2.0, 0.0, 100.0);
        this.limitLaserDomeMult = builder.comment("Laser Dome Damage Multiplier ((strength + magic) / 2 * multiplier)").translation("kingdomkeys.config.laser_dome_mult").defineInRange("laserDomeMult", 0.3, 0.0, 100.0);
        this.limitArrowRainMult = builder.comment("Arrow Rain Damage Multiplier ((strength + magic) / 2 * multiplier)").translation("kingdomkeys.config.arrow_rain_mult").defineInRange("arrowRainMult", 2.0, 0.0, 100.0);
        builder.pop();
        builder.push("shotlock");
        this.shotlockMult = builder.comment("Shotlock Damage Multiplier (magic * multiplier)").translation("kingdomkeys.config.shotlock_mult").defineInRange("shotlockMult", 0.4, 0.0, 100.0);
        builder.pop();
    }
}

