/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.datagen.builder;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ModelFile;
import online.kingdomkeys.kingdomkeys.synthesis.keybladeforge.KeybladeLevel;

public class KeybladeBuilder<T extends KeybladeBuilder<T>>
extends ModelFile {
    private ResourceLocation keychain;
    private int baseStr;
    private int baseMag;
    private String desc;
    private String[] baseAbilities;
    private ArrayList<KeybladeLevel> keybladeLevels = new ArrayList();

    public KeybladeBuilder(Object o, Object o1) {
        super((ResourceLocation)o);
    }

    private T self() {
        return (T)((Object)this);
    }

    public T keychain(String keyChain) {
        Preconditions.checkNotNull((Object)keyChain, (Object)"Texture must not be null");
        ResourceLocation asLoc = keyChain.contains(":") ? new ResourceLocation(keyChain) : new ResourceLocation(this.getLocation().func_110624_b(), keyChain);
        return this.keychain(asLoc);
    }

    public T keychain(ResourceLocation keychain) {
        Preconditions.checkNotNull((Object)keychain, (Object)"Keychain must not be null");
        this.keychain = keychain;
        return this.self();
    }

    public T baseStats(int baseStr, int baseMag) {
        this.baseMag = baseMag;
        this.baseStr = baseStr;
        return this.self();
    }

    public T level(KeybladeLevel keybladeLevel) {
        this.keybladeLevels.add(keybladeLevel);
        return this.self();
    }

    public T desc(String desc) {
        this.desc = desc;
        return this.self();
    }

    public T abilities(String ... abilities) {
        this.baseAbilities = abilities;
        return this.self();
    }

    protected boolean exists() {
        return true;
    }

    @VisibleForTesting
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        JsonObject baseStat = new JsonObject();
        JsonArray levels = new JsonArray();
        JsonArray abilities = new JsonArray();
        Arrays.stream(this.baseAbilities).forEach(arg_0 -> ((JsonArray)abilities).add(arg_0));
        root.add("abilities", (JsonElement)abilities);
        if (this.keychain != null) {
            root.addProperty("keychain", this.keychain.toString());
        }
        baseStat.addProperty("str", (Number)this.baseStr);
        baseStat.addProperty("mag", (Number)this.baseMag);
        root.add("base_stats", (JsonElement)baseStat);
        for (KeybladeLevel k : this.keybladeLevels) {
            JsonObject obj1 = new JsonObject();
            levels.add((JsonElement)obj1);
            obj1.addProperty("str", (Number)k.getStrength());
            obj1.addProperty("mag", (Number)k.getMagic());
            JsonArray recipe = new JsonArray();
            if (k.getMaterialList() != null) {
                k.getMaterialList().forEach((key, value) -> {
                    JsonObject matObj = new JsonObject();
                    matObj.addProperty("material", key.getRegistryName().toString());
                    matObj.addProperty("quantity", (Number)value);
                    recipe.add((JsonElement)matObj);
                });
            }
            obj1.add("recipe", (JsonElement)recipe);
            if (k.getAbility() == null) continue;
            obj1.addProperty("ability", k.getAbility());
        }
        root.add("levels", (JsonElement)levels);
        root.addProperty("description", this.desc);
        return root;
    }
}

