/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.datagen.builder;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ModelFile;

public class SynthesisRecipeBuilder<T extends SynthesisRecipeBuilder<T>>
extends ModelFile {
    private ResourceLocation output;
    private String type;
    private Map recipe = new HashMap();
    private int quantity;

    public SynthesisRecipeBuilder(Object o, Object o1) {
        super((ResourceLocation)o);
    }

    private T self() {
        return (T)((Object)this);
    }

    public T output(String output, int quantity) {
        Preconditions.checkNotNull((Object)output, (Object)"Texture must not be null");
        ResourceLocation asLoc = output.contains(":") ? new ResourceLocation(output) : new ResourceLocation(this.getLocation().func_110624_b(), output);
        return this.output(asLoc, quantity);
    }

    public T output(ResourceLocation output, int quantity) {
        Preconditions.checkNotNull((Object)output, (Object)"Keychain must not be null");
        this.output = output;
        this.quantity = quantity;
        return this.self();
    }

    public T addType(String type) {
        this.type = type;
        return this.self();
    }

    public T addMaterial(String mat, int quantity) {
        this.recipe.put("kingdomkeys:mat_" + mat, quantity);
        return this.self();
    }

    protected boolean exists() {
        return true;
    }

    @VisibleForTesting
    public JsonObject toJson() {
        JsonObject root = new JsonObject();
        JsonObject obj1 = new JsonObject();
        JsonArray recipes = new JsonArray();
        if (this.output != null) {
            obj1.addProperty("item", this.output.toString());
            obj1.addProperty("quantity", (Number)this.quantity);
            obj1.addProperty("type", this.type);
        }
        if (this.recipe != null) {
            this.recipe.forEach((key, value) -> {
                JsonObject matObj = new JsonObject();
                matObj.addProperty("material", key.toString());
                matObj.addProperty("quantity", value.toString());
                recipes.add((JsonElement)matObj);
            });
        }
        root.add("output", (JsonElement)obj1);
        root.add("ingredients", (JsonElement)recipes);
        return root;
    }
}

