/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.driveform;

import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Pose;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.mob.IKHMob;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSSetAerialDodgeTicksPacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSSetGlidingPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;

@Mod.EventBusSubscriber(modid="kingdomkeys")
public class DriveFormFinal
extends DriveForm {
    public DriveFormFinal(String registryName, int order, ResourceLocation skinRL, boolean hasKeychain) {
        super(registryName, order, hasKeychain);
        this.driveCost = 500;
        this.ap = -10;
        this.levelUpCosts = new int[]{0, 20, 80, 152, 242, 350, 500};
        this.color = new float[]{0.9f, 0.9f, 0.9f};
        this.skinRL = skinRL;
    }

    @Override
    public String getBaseAbilityForLevel(int driveFormLevel) {
        switch (driveFormLevel) {
            case 1: {
                return "";
            }
            case 2: {
                return "kingdomkeys:ability_auto_final";
            }
            case 3: {
                return "kingdomkeys:ability_glide";
            }
            case 4: {
                return "";
            }
            case 5: {
                return "kingdomkeys:ability_glide";
            }
            case 6: {
                return "";
            }
            case 7: {
                return "kingdomkeys:ability_glide";
            }
        }
        return null;
    }

    @Override
    public String getDFAbilityForLevel(int driveFormLevel) {
        switch (driveFormLevel) {
            case 1: {
                return "kingdomkeys:ability_glide";
            }
            case 2: {
                return "";
            }
            case 3: {
                return "kingdomkeys:ability_glide";
            }
            case 4: {
                return "";
            }
            case 5: {
                return "kingdomkeys:ability_glide";
            }
            case 6: {
                return "";
            }
            case 7: {
                return "kingdomkeys:ability_glide";
            }
        }
        return null;
    }

    @SubscribeEvent
    public static void getFinalFormXP(LivingDeathEvent event) {
        PlayerEntity player;
        IPlayerCapabilities playerData;
        if ((!event.getEntity().field_70170_p.field_72995_K && event.getEntity() instanceof EndermanEntity || event.getEntity() instanceof IKHMob && ((IKHMob)event.getEntity()).getMobType() == EntityHelper.MobType.NOBODY) && event.getSource().func_76346_g() instanceof PlayerEntity && (playerData = ModCapabilities.getPlayer(player = (PlayerEntity)event.getSource().func_76346_g())) != null && playerData.getActiveDriveForm().equals("kingdomkeys:form_final")) {
            double mult = Double.parseDouble(ModConfigs.driveFormXPMultiplier.get(4).split(",")[1]);
            playerData.setDriveFormExp(player, playerData.getActiveDriveForm(), (int)((double)playerData.getDriveFormExp(playerData.getActiveDriveForm()) + 1.0 * mult));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayerEntity)player);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        PlayerEntity player;
        IPlayerCapabilities playerData;
        if (event.getEntityLiving() instanceof PlayerEntity && (playerData = ModCapabilities.getPlayer(player = (PlayerEntity)event.getEntityLiving())) != null) {
            if (playerData.getActiveDriveForm().equals("kingdomkeys:form_final") && player.func_233570_aj_()) {
                player.func_213317_d(player.func_213322_ci().func_216369_h(new Vector3d(1.5, 1.0, 1.5)));
            }
            if (playerData.getDriveFormMap() != null && playerData.getActiveDriveForm().equals("kingdomkeys:form_final")) {
                DriveFormFinal.handleHighJump(player, playerData);
            }
            if (playerData.getActiveDriveForm().equals("kingdomkeys:form_final") || playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) && playerData.getDriveFormMap().containsKey("kingdomkeys:form_final") && playerData.getDriveFormLevel("kingdomkeys:form_final") >= 3 && playerData.getEquippedAbilityLevel("kingdomkeys:ability_glide") != null && playerData.getEquippedAbilityLevel("kingdomkeys:ability_glide")[1] > 0) {
                DriveFormFinal.handleGlide(player, playerData);
            }
            if (playerData.getIsGliding() && playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) && playerData.getEquippedAbilityLevel("kingdomkeys:ability_glide")[1] == 0) {
                playerData.setIsGliding(false);
                PacketHandler.sendToServer(new CSSetGlidingPacket(false));
            }
        }
    }

    private static boolean shouldHandleHighJump(PlayerEntity player, IPlayerCapabilities playerData) {
        return playerData.getDriveFormMap() != null && playerData.getActiveDriveForm().equals("kingdomkeys:form_final");
    }

    private static void handleHighJump(PlayerEntity player, IPlayerCapabilities playerData) {
        boolean j = false;
        if (player.field_70170_p.field_72995_K) {
            j = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
        }
        if (j && player.func_213322_ci().field_72448_b > 0.0 && playerData.getActiveDriveForm().equals("kingdomkeys:form_final")) {
            player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, (double)DriveForm.FINAL_JUMP_BOOST[playerData.getDriveFormLevel("kingdomkeys:form_final")], 0.0));
        }
    }

    private static void handleGlide(PlayerEntity player, IPlayerCapabilities playerData) {
        if (player.func_70090_H() || player.func_180799_ab()) {
            return;
        }
        if (player.field_70170_p.field_72995_K) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71439_g == player) {
                if (!player.func_233570_aj_() && player.field_70143_R > 0.0f) {
                    if (mc.field_71474_y.field_74314_A.func_151470_d()) {
                        if (!(playerData.getIsGliding() || player.field_70170_p.func_180495_p(player.func_233580_cy_()).func_177230_c() instanceof FlowingFluidBlock || player.field_70170_p.func_180495_p(player.func_233580_cy_().func_177977_b()).func_177230_c() instanceof FlowingFluidBlock)) {
                            playerData.setIsGliding(true);
                            playerData.setAerialDodgeTicks(0);
                            PacketHandler.sendToServer(new CSSetGlidingPacket(true));
                            PacketHandler.sendToServer(new CSSetAerialDodgeTicksPacket(true, 0));
                        }
                    } else if (playerData.getIsGliding()) {
                        playerData.setIsGliding(false);
                        PacketHandler.sendToServer(new CSSetGlidingPacket(false));
                    }
                } else if (playerData.getIsGliding()) {
                    playerData.setIsGliding(false);
                    PacketHandler.sendToServer(new CSSetGlidingPacket(false));
                    PacketHandler.sendToServer(new CSSetAerialDodgeTicksPacket(false, 0));
                }
            }
        }
        if (playerData.getIsGliding()) {
            int glideLevel = playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) ? playerData.getDriveFormLevel("kingdomkeys:form_final") - 2 : playerData.getDriveFormLevel("kingdomkeys:form_final");
            float glide = DriveForm.FINAL_GLIDE[glideLevel];
            float limit = DriveForm.FINAL_GLIDE_SPEED[glideLevel];
            Vector3d motion = player.func_213322_ci();
            if (Math.abs(motion.func_82615_a()) < (double)limit && Math.abs(motion.func_82616_c()) < (double)limit) {
                player.func_213293_j(motion.func_82615_a() * 1.1, motion.func_82617_b(), motion.func_82616_c() * 1.1);
            }
            motion = player.func_213322_ci();
            player.func_213293_j(motion.func_82615_a(), (double)glide, motion.func_82616_c());
            if (player.getForcedPose() != Pose.SWIMMING) {
                player.setForcedPose(Pose.SWIMMING);
            }
        }
    }
}

