/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.driveform;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;

@Mod.EventBusSubscriber(modid="kingdomkeys")
public class DriveFormValor
extends DriveForm {
    public DriveFormValor(String registryName, int order, ResourceLocation skinRL, boolean hasKeychain) {
        super(registryName, order, hasKeychain);
        this.driveCost = 300;
        this.ap = 1;
        this.levelUpCosts = new int[]{0, 80, 240, 520, 968, 1528, 2200};
        this.color = new float[]{1.0f, 0.0f, 0.0f};
        this.skinRL = skinRL;
    }

    @Override
    public String getBaseAbilityForLevel(int driveFormLevel) {
        switch (driveFormLevel) {
            case 1: {
                return "";
            }
            case 2: {
                return "kingdomkeys:ability_auto_valor";
            }
            case 3: {
                return "kingdomkeys:ability_high_jump";
            }
            case 4: {
                return "";
            }
            case 5: {
                return "kingdomkeys:ability_high_jump";
            }
            case 6: {
                return "";
            }
            case 7: {
                return "kingdomkeys:ability_high_jump";
            }
        }
        return null;
    }

    @Override
    public String getDFAbilityForLevel(int driveFormLevel) {
        switch (driveFormLevel) {
            case 1: {
                return "kingdomkeys:ability_high_jump";
            }
            case 2: {
                return "";
            }
            case 3: {
                return "kingdomkeys:ability_high_jump";
            }
            case 4: {
                return "";
            }
            case 5: {
                return "kingdomkeys:ability_high_jump";
            }
            case 6: {
                return "";
            }
            case 7: {
                return "kingdomkeys:ability_high_jump";
            }
        }
        return null;
    }

    @SubscribeEvent
    public static void getValorFormXP(LivingAttackEvent event) {
        PlayerEntity player;
        IPlayerCapabilities playerData;
        if (!event.getEntity().field_70170_p.field_72995_K && event.getEntityLiving() instanceof MonsterEntity && event.getSource().func_76346_g() instanceof PlayerEntity && (playerData = ModCapabilities.getPlayer(player = (PlayerEntity)event.getSource().func_76346_g())) != null && playerData.getActiveDriveForm().equals("kingdomkeys:form_valor")) {
            double mult = Double.parseDouble(ModConfigs.driveFormXPMultiplier.get(0).split(",")[1]);
            playerData.setDriveFormExp(player, playerData.getActiveDriveForm(), (int)((double)playerData.getDriveFormExp(playerData.getActiveDriveForm()) + 1.0 * mult));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayerEntity)player);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        PlayerEntity player;
        IPlayerCapabilities playerData;
        if (event.getEntityLiving() instanceof PlayerEntity && (playerData = ModCapabilities.getPlayer(player = (PlayerEntity)event.getEntityLiving())) != null) {
            if (playerData.getActiveDriveForm().equals("kingdomkeys:form_valor") && player.func_233570_aj_()) {
                player.func_213317_d(player.func_213322_ci().func_216369_h(new Vector3d(1.5, 1.0, 1.5)));
            }
            if (DriveFormValor.shouldHandleHighJump(player, playerData)) {
                DriveFormValor.handleHighJump(player, playerData);
            }
        }
    }

    private static boolean shouldHandleHighJump(PlayerEntity player, IPlayerCapabilities playerData) {
        if (playerData.getDriveFormMap() == null) {
            return false;
        }
        return playerData.getActiveDriveForm().equals("kingdomkeys:form_valor") || playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) && playerData.getDriveFormMap().containsKey("kingdomkeys:form_valor") && playerData.getDriveFormLevel("kingdomkeys:form_valor") >= 3 && playerData.getEquippedAbilityLevel("kingdomkeys:ability_high_jump") != null && playerData.getEquippedAbilityLevel("kingdomkeys:ability_high_jump")[1] > 0;
    }

    private static void handleHighJump(PlayerEntity player, IPlayerCapabilities playerData) {
        boolean j = false;
        if (player.field_70170_p.field_72995_K) {
            j = Minecraft.func_71410_x().field_71474_y.field_74314_A.func_151470_d();
        }
        if (j && player.func_213322_ci().field_72448_b > 0.0) {
            if (playerData.getActiveDriveForm().equals("kingdomkeys:form_valor")) {
                player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, (double)DriveForm.VALOR_JUMP_BOOST[playerData.getDriveFormLevel("kingdomkeys:form_valor")], 0.0));
            } else if (playerData.getActiveDriveForm() != null) {
                int jumpLevel = playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) ? playerData.getDriveFormLevel("kingdomkeys:form_valor") - 2 : playerData.getDriveFormLevel("kingdomkeys:form_valor");
                player.func_213317_d(player.func_213322_ci().func_72441_c(0.0, (double)DriveForm.VALOR_JUMP_BOOST[jumpLevel], 0.0));
            }
        }
    }
}

