/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;

public class EntityHelper {
    public static final DataParameter<Integer> ANIMATION = EntityDataManager.func_187226_a(MobEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(MobEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public static void setState(Entity e, int i) {
        e.func_184212_Q().func_187227_b(STATE, (Object)i);
    }

    public static double percentage(double i, double j) {
        return i * 100.0 / j;
    }

    public static int getState(Entity e) {
        return (Integer)e.func_184212_Q().func_187225_a(STATE);
    }

    public static void setAnimation(Entity e, int i) {
        e.func_184212_Q().func_187227_b(ANIMATION, (Object)i);
    }

    public static int getAnimation(Entity e) {
        return (Integer)e.func_184212_Q().func_187225_a(ANIMATION);
    }

    public static Dir get8Directions(Entity e) {
        switch (MathHelper.func_76128_c((double)((double)(e.field_70177_z * 8.0f / 360.0f) + 0.5)) & 7) {
            case 0: {
                return Dir.SOUTH;
            }
            case 1: {
                return Dir.SOUTH_WEST;
            }
            case 2: {
                return Dir.WEST;
            }
            case 3: {
                return Dir.NORTH_WEST;
            }
            case 4: {
                return Dir.NORTH;
            }
            case 5: {
                return Dir.NORTH_EAST;
            }
            case 6: {
                return Dir.EAST;
            }
            case 7: {
                return Dir.SOUTH_EAST;
            }
        }
        return null;
    }

    public static double[] generateAnimationArray(double startPos, double minPos, double maxPos, double frameSkip, int framesPerSlot) {
        double i;
        int framesCount = 0;
        double currentFrame = startPos;
        boolean hasReachedMaxPos = false;
        boolean hasReachedMinPos = false;
        for (i = startPos; i <= maxPos; i += frameSkip) {
            ++framesCount;
        }
        for (i = maxPos; i > minPos; i -= frameSkip) {
            ++framesCount;
        }
        for (i = minPos; i <= startPos; i += frameSkip) {
            ++framesCount;
        }
        framesCount *= framesPerSlot;
        double[] animation = new double[framesCount -= 1 * framesPerSlot];
        for (int j = 0; j < framesCount; ++j) {
            for (int i2 = 0; i2 < framesPerSlot; ++i2) {
                if (j + 1 >= framesCount) continue;
                if (i2 > 0) {
                    ++j;
                }
                animation[j] = currentFrame;
            }
            if (!hasReachedMaxPos && currentFrame < maxPos) {
                currentFrame += frameSkip;
            } else if (!hasReachedMinPos && hasReachedMaxPos && currentFrame > minPos) {
                currentFrame -= frameSkip;
            } else if (hasReachedMinPos && currentFrame < startPos) {
                currentFrame += frameSkip;
            }
            if (currentFrame >= maxPos) {
                hasReachedMaxPos = true;
            }
            if (!(currentFrame <= minPos)) continue;
            hasReachedMinPos = true;
        }
        return animation;
    }

    public static List<LivingEntity> getEntitiesNear(Entity e, double radius) {
        AxisAlignedBB aabb = new AxisAlignedBB(e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), e.func_226277_ct_() + 1.0, e.func_226278_cu_() + 1.0, e.func_226281_cx_() + 1.0).func_72314_b(radius, radius, radius);
        List list = e.field_70170_p.func_217357_a(LivingEntity.class, aabb);
        list.remove(e);
        return list;
    }

    public static enum MobType {
        HEARTLESS_PUREBLOOD,
        HEARTLESS_EMBLEM,
        NOBODY,
        NPC;

    }

    public static enum Dir {
        SOUTH,
        SOUTH_EAST,
        EAST,
        NORTH,
        NORTH_EAST,
        NORTH_WEST,
        WEST,
        SOUTH_WEST;

    }
}

