/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSOrgPortalTPPacket;

public class OrgPortalEntity
extends Entity
implements IEntityAdditionalSpawnData {
    int maxTicks = 100;
    float radius = 0.5f;
    BlockPos destinationPos;
    RegistryKey<World> destinationDim;
    boolean shouldTeleport;

    public OrgPortalEntity(EntityType<? extends Entity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public OrgPortalEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super((EntityType)ModEntities.TYPE_ORG_PORTAL.get(), world);
    }

    public OrgPortalEntity(World world) {
        super((EntityType)ModEntities.TYPE_ORG_PORTAL.get(), world);
        this.field_70156_m = true;
    }

    public OrgPortalEntity(World world, PlayerEntity player, BlockPos spawnPos, BlockPos destinationPos, RegistryKey<World> destinationDim, boolean shouldTP) {
        super((EntityType)ModEntities.TYPE_ORG_PORTAL.get(), world);
        this.func_70107_b((double)spawnPos.func_177958_n() + 0.5, spawnPos.func_177956_o(), (double)spawnPos.func_177952_p() + 0.5);
        this.destinationPos = destinationPos;
        this.destinationDim = destinationDim;
        this.shouldTeleport = shouldTP;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        if (this.field_70173_aa > this.maxTicks) {
            this.func_70106_y();
        }
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197616_i, this.func_226277_ct_() - 1.0 + this.field_70146_Z.nextDouble() * 2.0, this.func_226278_cu_() + this.field_70146_Z.nextDouble() * 4.0, this.func_226281_cx_() - 1.0 + this.field_70146_Z.nextDouble() * 2.0, 0.0, 0.0, 0.0);
        List tempList = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72314_b((double)this.radius, (double)this.radius, (double)this.radius));
        for (Entity t : tempList) {
            if (!this.shouldTeleport || t instanceof OrgPortalEntity) continue;
            if (!this.func_70089_S()) {
                return;
            }
            if (t == null || this.destinationPos == null || this.destinationPos.func_177958_n() == 0 || this.destinationPos.func_177956_o() == 0 || this.destinationPos.func_177952_p() == 0) continue;
            double yOffset = t.func_226278_cu_() - this.func_226278_cu_();
            t.func_70107_b((double)this.destinationPos.func_177958_n() + 0.5, (double)(this.destinationPos.func_177956_o() + 1) + yOffset, (double)this.destinationPos.func_177952_p() + 0.5);
            if (!(t instanceof PlayerEntity) || !this.field_70170_p.field_72995_K) continue;
            PacketHandler.sendToServer(new CSOrgPortalTPPacket(this.destinationDim, (double)this.destinationPos.func_177958_n() + 0.5, (double)(this.destinationPos.func_177956_o() + 1) + yOffset, (double)this.destinationPos.func_177952_p() + 0.5));
        }
        super.func_70071_h_();
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void func_213281_b(CompoundNBT compound) {
    }

    public void func_70037_a(CompoundNBT compound) {
    }

    protected void func_70088_a() {
    }

    public void writeSpawnData(PacketBuffer buffer) {
        if (this.destinationPos == null) {
            return;
        }
        buffer.func_179255_a(new BlockPos(this.destinationPos.func_177958_n(), this.destinationPos.func_177956_o(), this.destinationPos.func_177952_p()));
        buffer.func_192572_a(this.destinationDim.func_240901_a_());
        buffer.writeBoolean(this.shouldTeleport);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.destinationPos = additionalData.func_179259_c();
        this.destinationDim = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)additionalData.func_192575_l());
        this.shouldTeleport = additionalData.readBoolean();
    }
}

