/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.block;

import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import online.kingdomkeys.kingdomkeys.container.MagicalChestContainer;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;

public class MagicalChestTileEntity
extends TileEntity
implements INamedContainerProvider {
    public static final int NUMBER_OF_SLOTS = 36;
    private LazyOptional<IItemHandler> inventory = LazyOptional.of(this::createInventory);
    private UUID keyblade;
    private UUID owner;

    public MagicalChestTileEntity() {
        super((TileEntityType)ModEntities.TYPE_MAGICAL_CHEST.get());
    }

    private IItemHandler createInventory() {
        return new ItemStackHandler(36);
    }

    public UUID getKeyblade() {
        return this.keyblade;
    }

    public void setKeyblade(UUID keyblade) {
        this.keyblade = keyblade;
        this.func_70296_d();
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(UUID owner) {
        this.owner = owner;
        this.func_70296_d();
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.inventory.ifPresent(iih -> {
            CompoundNBT invCompound = (CompoundNBT)((INBTSerializable)iih).serializeNBT();
            compound.func_218657_a("inv", (INBT)invCompound);
        });
        compound.func_186854_a("owner", this.owner);
        if (this.keyblade != null && !this.keyblade.equals(new UUID(0L, 0L))) {
            compound.func_186854_a("keyblade", this.keyblade);
        }
        return compound;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        CompoundNBT invCompound = compound.func_74775_l("inv");
        this.inventory.ifPresent(iih -> ((INBTSerializable)iih).deserializeNBT((INBT)invCompound));
        this.owner = compound.func_186857_a("owner");
        if (compound.func_186855_b("keyblade")) {
            this.keyblade = compound.func_186857_a("keyblade");
        }
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        CompoundNBT nbt = new CompoundNBT();
        this.func_189515_b(nbt);
        return new SUpdateTileEntityPacket(this.func_174877_v(), 1, nbt);
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(BlockState state, CompoundNBT tag) {
        this.func_230337_a_(state, tag);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventory.cast();
        }
        return super.getCapability(cap, side);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.magical_chest");
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity playerEntity) {
        return new MagicalChestContainer(windowId, playerInventory, this);
    }
}

