/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import online.kingdomkeys.kingdomkeys.capability.IGlobalCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCRecalculateEyeHeight;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class GraviraEntity
extends ThrowableEntity {
    int maxTicks = 100;

    public GraviraEntity(EntityType<? extends ThrowableEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public GraviraEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super((EntityType)ModEntities.TYPE_GRAVIRA.get(), world);
    }

    public GraviraEntity(World world) {
        super((EntityType)ModEntities.TYPE_GRAVIRA.get(), world);
        this.field_70156_m = true;
    }

    public GraviraEntity(World world, PlayerEntity player) {
        super((EntityType)ModEntities.TYPE_GRAVIRA.get(), (LivingEntity)player, world);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70071_h_() {
        if (this.field_70173_aa > this.maxTicks) {
            this.func_70106_y();
        }
        if (this.field_70173_aa > 2) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197616_i, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        super.func_70071_h_();
    }

    protected void func_70227_a(RayTraceResult rtRes) {
        float radius = 2.5f;
        double X = this.func_226277_ct_();
        double Y = this.func_226278_cu_();
        double Z = this.func_226281_cx_();
        for (int t = 1; t < 360; t += 20) {
            for (int s = 1; s < 360; s += 20) {
                double x = X + (double)radius * Math.cos(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                double z = Z + (double)radius * Math.sin(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                double y = Y + (double)radius * Math.cos(Math.toRadians(t));
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197616_i, x, y, z, 0.0, -0.05, 0.0);
            }
        }
        IWorldCapabilities worldData = ModCapabilities.getWorld(this.field_70170_p);
        if (!this.field_70170_p.field_72995_K && this.func_234616_v_() != null && worldData != null) {
            List list = this.field_70170_p.func_72839_b(this.func_234616_v_(), this.func_174813_aQ().func_186662_g((double)radius));
            Party casterParty = worldData.getPartyFromMember(this.func_234616_v_().func_110124_au());
            if (casterParty != null && !casterParty.getFriendlyFire()) {
                for (Party.Member m : casterParty.getMembers()) {
                    list.remove(this.field_70170_p.func_217371_b(m.getUUID()));
                }
            } else {
                list.remove(this.func_234616_v_());
            }
            if (!list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    Entity e = (Entity)list.get(i);
                    if (!(e instanceof LivingEntity)) continue;
                    IGlobalCapabilities globalData = ModCapabilities.getGlobal((LivingEntity)e);
                    globalData.setFlatTicks(100);
                    if (Utils.isHostile(e)) {
                        float baseDmg = DamageCalculation.getMagicDamage((PlayerEntity)this.func_234616_v_()) * 0.2f;
                        float dmg = this.func_234616_v_() instanceof PlayerEntity ? baseDmg : 2.0f;
                        e.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_()), dmg);
                    }
                    if (e instanceof LivingEntity) {
                        PacketHandler.syncToAllAround((LivingEntity)e, globalData);
                    }
                    if (!(e instanceof ServerPlayerEntity)) continue;
                    PacketHandler.sendTo(new SCRecalculateEyeHeight(), (ServerPlayerEntity)e);
                }
            }
            this.func_70106_y();
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void func_213281_b(CompoundNBT compound) {
    }

    public void func_70037_a(CompoundNBT compound) {
    }

    protected void func_70088_a() {
    }
}

