/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Util;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.lib.Party;

public class MagneraEntity
extends ThrowableEntity {
    int maxTicks = 150;
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(MagneraEntity.class, (IDataSerializer)DataSerializers.field_187203_m);

    public MagneraEntity(EntityType<? extends ThrowableEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public MagneraEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super((EntityType)ModEntities.TYPE_MAGNERA.get(), world);
    }

    public MagneraEntity(World world) {
        super((EntityType)ModEntities.TYPE_MAGNERA.get(), world);
        this.field_70156_m = true;
    }

    public MagneraEntity(World world, PlayerEntity player) {
        super((EntityType)ModEntities.TYPE_MAGNERA.get(), (LivingEntity)player, world);
        this.setCaster(player.func_110124_au());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70071_h_() {
        if (this.field_70173_aa > this.maxTicks || this.getCaster() == null) {
            this.func_70106_y();
        }
        if (this.field_70170_p == null || ModCapabilities.getWorld(this.field_70170_p) == null || this.getCaster() == null) {
            return;
        }
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        if (this.field_70173_aa >= 3 && this.field_70173_aa % 2 == 0) {
            float radius = 2.5f;
            double X = this.func_226277_ct_();
            double Y = this.func_226278_cu_();
            double Z = this.func_226281_cx_();
            for (int t = 1; t < 360; t += 30) {
                for (int s = 1; s < 360; s += 30) {
                    double x = X + (double)radius * Math.cos(Math.toRadians(s + this.field_70173_aa)) * Math.sin(Math.toRadians(t + this.field_70173_aa));
                    double z = Z + (double)radius * Math.sin(Math.toRadians(s + this.field_70173_aa)) * Math.sin(Math.toRadians(t + this.field_70173_aa));
                    double y = Y + (double)radius * Math.cos(Math.toRadians(t + this.field_70173_aa));
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_203217_T, x, y + 1.0, z, 0.0, 0.0, 0.0);
                }
            }
            this.func_213293_j(0.0, 0.0, 0.0);
            this.field_70133_I = true;
            List list = this.field_70170_p.func_72839_b((Entity)this.getCaster(), this.func_174813_aQ().func_72314_b((double)radius, (double)(radius * 2.0f), (double)radius));
            Party casterParty = ModCapabilities.getWorld(this.field_70170_p).getPartyFromMember(this.getCaster().func_110124_au());
            if (casterParty != null && !casterParty.getFriendlyFire()) {
                for (Party.Member m : casterParty.getMembers()) {
                    list.remove(this.field_70170_p.func_217371_b(m.getUUID()));
                }
            } else {
                list.remove(this.func_234616_v_());
            }
            if (!list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    Entity e = (Entity)list.get(i);
                    if (!(e instanceof LivingEntity)) continue;
                    double d = e.func_226277_ct_() - this.func_226277_ct_();
                    double d1 = e.func_226281_cx_() - this.func_226281_cx_();
                    ((LivingEntity)e).func_233627_a_(1.0f, d, d1);
                    if (e.func_226278_cu_() < this.func_226278_cu_() - 0.5) {
                        e.func_213293_j(e.func_213322_ci().field_72450_a, 0.5, e.func_213322_ci().field_72449_c);
                    }
                    if (this.field_70173_aa + 2 <= this.maxTicks) continue;
                    if (e instanceof MonsterEntity || e instanceof PlayerEntity) {
                        e.func_70097_a(DamageSource.func_76365_a((PlayerEntity)this.getCaster()), DamageCalculation.getMagicDamage(this.getCaster()) * 0.3f);
                    }
                    this.func_70106_y();
                }
            }
        }
        super.func_70071_h_();
    }

    protected void func_70227_a(RayTraceResult rtRes) {
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.field_70180_af.func_187225_a(OWNER) != null) {
            compound.func_74778_a("OwnerUUID", ((UUID)((Optional)this.field_70180_af.func_187225_a(OWNER)).get()).toString());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(OWNER, Optional.of(UUID.fromString(compound.func_74779_i("OwnerUUID"))));
    }

    public PlayerEntity getCaster() {
        return ((Optional)this.func_184212_Q().func_187225_a(OWNER)).isPresent() ? this.field_70170_p.func_217371_b((UUID)((Optional)this.func_184212_Q().func_187225_a(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER, Optional.of(uuid));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OWNER, Optional.of(Util.field_240973_b_));
    }
}

