/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.lib.Party;

public class ThunderBoltEntity
extends ThrowableEntity {
    private int lightningState;
    public long boltVertex;
    private int boltLivingTime;
    private boolean effectOnly;
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(ThunderBoltEntity.class, (IDataSerializer)DataSerializers.field_187203_m);

    public ThunderBoltEntity(EntityType<? extends ThrowableEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public ThunderBoltEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super((EntityType)ModEntities.TYPE_THUNDERBOLT.get(), world);
    }

    public ThunderBoltEntity(World world) {
        super((EntityType)ModEntities.TYPE_THUNDERBOLT.get(), world);
        this.field_70156_m = true;
    }

    public ThunderBoltEntity(World world, PlayerEntity player, double x, double y, double z) {
        super((EntityType)ModEntities.TYPE_THUNDERBOLT.get(), (LivingEntity)player, world);
        this.setCaster(player.func_110124_au());
        this.field_70158_ak = true;
        this.func_70012_b(x, y, z, 0.0f, 0.0f);
        this.lightningState = 2;
        this.boltVertex = this.field_70146_Z.nextLong();
        this.boltLivingTime = this.field_70146_Z.nextInt(3) + 1;
        this.effectOnly = false;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.WEATHER;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        --this.lightningState;
        if (this.lightningState < 0) {
            if (this.boltLivingTime == 0) {
                this.func_70106_y();
            } else if (this.lightningState < -this.field_70146_Z.nextInt(10)) {
                --this.boltLivingTime;
                this.lightningState = 1;
                this.boltVertex = this.field_70146_Z.nextLong();
            }
        }
        if (this.lightningState >= 0) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_225605_c_(2);
            } else if (!this.effectOnly) {
                double d0 = 3.0;
                List list = this.field_70170_p.func_175674_a((Entity)this, new AxisAlignedBB(this.func_226277_ct_() - 2.0, this.func_226278_cu_() - 2.0, this.func_226281_cx_() - 2.0, this.func_226277_ct_() + 2.0, this.func_226278_cu_() + 6.0 + 2.0, this.func_226281_cx_() + 2.0), Entity::func_70089_S);
                Party casterParty = ModCapabilities.getWorld(this.field_70170_p).getPartyFromMember(this.func_234616_v_().func_110124_au());
                if (casterParty != null && !casterParty.getFriendlyFire()) {
                    for (Party.Member m : casterParty.getMembers()) {
                        list.remove(this.field_70170_p.func_217371_b(m.getUUID()));
                    }
                } else {
                    list.remove(this.func_234616_v_());
                }
                for (Entity entity : list) {
                    float baseDmg = DamageCalculation.getMagicDamage((PlayerEntity)this.func_234616_v_()) * 0.2f;
                    float dmg = this.func_234616_v_() instanceof PlayerEntity ? baseDmg : 2.0f;
                    entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_()), dmg);
                    if (entity instanceof PigEntity && this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL) {
                        PigEntity pig = (PigEntity)entity;
                        ZombifiedPiglinEntity zombifiedpiglinentity = (ZombifiedPiglinEntity)EntityType.field_233592_ba_.func_200721_a(this.field_70170_p);
                        zombifiedpiglinentity.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151010_B));
                        zombifiedpiglinentity.func_70012_b(pig.func_226277_ct_(), pig.func_226278_cu_(), pig.func_226281_cx_(), pig.field_70177_z, pig.field_70125_A);
                        zombifiedpiglinentity.func_94061_f(pig.func_175446_cd());
                        zombifiedpiglinentity.func_82227_f(pig.func_70631_g_());
                        if (pig.func_145818_k_()) {
                            zombifiedpiglinentity.func_200203_b(pig.func_200201_e());
                            zombifiedpiglinentity.func_174805_g(pig.func_174833_aM());
                        }
                        zombifiedpiglinentity.func_110163_bv();
                        this.field_70170_p.func_217376_c((Entity)zombifiedpiglinentity);
                        pig.func_70106_y();
                    }
                    if (entity instanceof VillagerEntity && this.field_70170_p.func_175659_aa() != Difficulty.PEACEFUL) {
                        VillagerEntity villager = (VillagerEntity)entity;
                        WitchEntity witchentity = (WitchEntity)EntityType.field_200759_ay.func_200721_a(this.field_70170_p);
                        witchentity.func_70012_b(villager.func_226277_ct_(), villager.func_226278_cu_(), villager.func_226281_cx_(), villager.field_70177_z, villager.field_70125_A);
                        witchentity.func_213386_a((IServerWorld)((ServerWorld)this.field_70170_p), this.field_70170_p.func_175649_E(witchentity.func_233580_cy_()), SpawnReason.CONVERSION, (ILivingEntityData)null, (CompoundNBT)null);
                        witchentity.func_94061_f(villager.func_175446_cd());
                        if (villager.func_145818_k_()) {
                            witchentity.func_200203_b(villager.func_200201_e());
                            witchentity.func_174805_g(villager.func_174833_aM());
                        }
                        witchentity.func_110163_bv();
                        this.field_70170_p.func_217376_c((Entity)witchentity);
                        villager.func_70106_y();
                    }
                    if (!(entity instanceof CreeperEntity)) continue;
                    LightningBoltEntity lightningBoltEntity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(this.field_70170_p);
                    lightningBoltEntity.func_233576_c_(Vector3d.func_237492_c_((Vector3i)entity.func_233580_cy_()));
                    lightningBoltEntity.func_204809_d(this.getCaster() instanceof ServerPlayerEntity ? (ServerPlayerEntity)this.getCaster() : null);
                    this.field_70170_p.func_217376_c((Entity)lightningBoltEntity);
                }
                if (this.getCaster() != null) {
                    CriteriaTriggers.field_204812_E.func_204814_a((ServerPlayerEntity)this.getCaster(), (Collection)list);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 64.0 * ThunderBoltEntity.func_184183_bd();
        return distance < d0 * d0;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.field_70180_af.func_187225_a(OWNER) != null) {
            compound.func_74778_a("OwnerUUID", ((UUID)((Optional)this.field_70180_af.func_187225_a(OWNER)).get()).toString());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(OWNER, Optional.of(UUID.fromString(compound.func_74779_i("OwnerUUID"))));
    }

    public PlayerEntity getCaster() {
        return ((Optional)this.func_184212_Q().func_187225_a(OWNER)).isPresent() ? this.field_70170_p.func_217371_b((UUID)((Optional)this.func_184212_Q().func_187225_a(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER, Optional.of(uuid));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OWNER, Optional.of(Util.field_240973_b_));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70227_a(RayTraceResult result) {
    }
}

