/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.organization;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.organization.LaserDomeShotEntity;

public class ArrowRainCoreEntity
extends ThrowableEntity {
    int maxTicks = 240;
    float dmg;
    double dmgMult;
    float radius;
    float space;
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(ArrowRainCoreEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Optional<UUID>> TARGET = EntityDataManager.func_187226_a(ArrowRainCoreEntity.class, (IDataSerializer)DataSerializers.field_187203_m);

    public ArrowRainCoreEntity(EntityType<? extends ThrowableEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public ArrowRainCoreEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super((EntityType)ModEntities.TYPE_ARROW_RAIN.get(), world);
    }

    public ArrowRainCoreEntity(World world) {
        super((EntityType)ModEntities.TYPE_ARROW_RAIN.get(), world);
        this.field_70156_m = true;
    }

    public ArrowRainCoreEntity(World world, PlayerEntity player, LivingEntity target, float dmg) {
        super((EntityType)ModEntities.TYPE_ARROW_RAIN.get(), (LivingEntity)player, world);
        this.setCaster(player.func_110124_au());
        this.setTarget(target.func_110124_au());
        this.dmg = dmg;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70071_h_() {
        if (this.field_70173_aa > this.maxTicks || this.getCaster() == null) {
            this.func_70106_y();
        }
        this.func_213293_j(0.0, 0.0, 0.0);
        this.field_70133_I = true;
        this.dmgMult = ModConfigs.limitArrowRainMult;
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        double X = this.func_226277_ct_();
        double Y = this.func_226278_cu_();
        double Z = this.func_226281_cx_();
        if (this.getCaster() != null) {
            if (this.field_70173_aa == 1) {
                LaserDomeShotEntity bullet = new LaserDomeShotEntity(this.field_70170_p, (LivingEntity)this.getCaster(), (double)this.dmg * this.dmgMult);
                bullet.func_70107_b(X, Y, Z);
                bullet.setMaxTicks(30);
                bullet.func_70186_c(0.0, 255.0, 0.0, 1.0f, 0.0f);
                this.field_70170_p.func_217376_c((Entity)bullet);
                this.field_70170_p.func_184133_a(this.getCaster(), this.getCaster().func_233580_cy_(), (SoundEvent)ModSounds.sharpshooterbullet.get(), SoundCategory.PLAYERS, 1.0f, 0.6f);
            } else if (this.field_70173_aa > 40 && this.field_70173_aa % 2 == 0) {
                this.radius = Math.min((float)(this.field_70173_aa - 34) / 10.0f, 20.0f);
                this.space = 26.0f - this.radius;
                int s = 1;
                while (s < 360) {
                    double x = X + (double)this.radius * Math.cos(Math.toRadians(s));
                    double z = Z + (double)this.radius * Math.sin(Math.toRadians(s));
                    LaserDomeShotEntity bullet = new LaserDomeShotEntity(this.field_70170_p, (LivingEntity)this.getCaster(), (double)this.dmg * this.dmgMult);
                    bullet.func_70107_b(X, Y + 27.0, Z);
                    bullet.setMaxTicks(20);
                    bullet.func_70186_c(x - bullet.func_226277_ct_(), this.func_226278_cu_() - bullet.func_226278_cu_() + 1.0, z - bullet.func_226281_cx_(), 2.5f, 0.0f);
                    this.field_70170_p.func_217376_c((Entity)bullet);
                    s = (int)((float)s + this.space);
                }
                this.field_70170_p.func_184133_a(this.getCaster(), this.getCaster().func_233580_cy_(), (SoundEvent)ModSounds.sharpshooterbullet.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
        super.func_70071_h_();
    }

    protected void func_70227_a(RayTraceResult rtRes) {
        this.func_70106_y();
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.field_70180_af.func_187225_a(OWNER) != null) {
            compound.func_74778_a("OwnerUUID", ((UUID)((Optional)this.field_70180_af.func_187225_a(OWNER)).get()).toString());
            compound.func_74778_a("TargetUUID", ((UUID)((Optional)this.field_70180_af.func_187225_a(TARGET)).get()).toString());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(OWNER, Optional.of(UUID.fromString(compound.func_74779_i("OwnerUUID"))));
        this.field_70180_af.func_187227_b(TARGET, Optional.of(UUID.fromString(compound.func_74779_i("TargetUUID"))));
    }

    public PlayerEntity getCaster() {
        return ((Optional)this.func_184212_Q().func_187225_a(OWNER)).isPresent() ? this.field_70170_p.func_217371_b((UUID)((Optional)this.func_184212_Q().func_187225_a(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER, Optional.of(uuid));
    }

    public PlayerEntity getTarget() {
        return ((Optional)this.func_184212_Q().func_187225_a(TARGET)).isPresent() ? this.field_70170_p.func_217371_b((UUID)((Optional)this.func_184212_Q().func_187225_a(TARGET)).get()) : null;
    }

    public void setTarget(UUID uuid) {
        this.field_70180_af.func_187227_b(TARGET, Optional.of(uuid));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OWNER, Optional.of(new UUID(0L, 0L)));
        this.field_70180_af.func_187214_a(TARGET, Optional.of(new UUID(0L, 0L)));
    }
}

