/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.organization;

import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.EndGatewayTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;

public class LanceEntity
extends ThrowableEntity {
    int maxTicks = 100;
    String model;
    boolean stopped = false;
    int rotationPoint;
    float dmg = 0.0f;
    private static final DataParameter<String> MODEL = EntityDataManager.func_187226_a(LanceEntity.class, (IDataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Boolean> STOPPED = EntityDataManager.func_187226_a(LanceEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ROTATION_POINT = EntityDataManager.func_187226_a(LanceEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public LanceEntity(EntityType<? extends ThrowableEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public LanceEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super((EntityType)ModEntities.TYPE_LANCE.get(), world);
    }

    public LanceEntity(World world) {
        super((EntityType)ModEntities.TYPE_LANCE.get(), world);
        this.field_70156_m = true;
    }

    public LanceEntity(World world, PlayerEntity player, String model, float dmg) {
        super((EntityType)ModEntities.TYPE_LANCE.get(), (LivingEntity)player, world);
        this.func_212361_a((Entity)player);
        this.setModel(model);
        this.dmg = dmg;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70071_h_() {
        if (this.field_70173_aa > this.maxTicks) {
            this.func_70106_y();
        }
        if (!this.isStopped()) {
            if (this.field_70173_aa > 2) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197614_g, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
            if (this.func_233570_aj_()) {
                this.func_230245_c_(false);
                this.func_213317_d(this.func_213322_ci().func_216372_d((double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f)));
            }
            RayTraceResult raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, arg_0 -> ((LanceEntity)this).func_230298_a_(arg_0));
            boolean flag = false;
            if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
                BlockPos blockpos = ((BlockRayTraceResult)raytraceresult).func_216350_a();
                BlockState blockstate = this.field_70170_p.func_180495_p(blockpos);
                if (blockstate.func_203425_a(Blocks.field_150427_aO)) {
                    this.func_181015_d(blockpos);
                    flag = true;
                } else if (blockstate.func_203425_a(Blocks.field_185775_db)) {
                    TileEntity tileentity = this.field_70170_p.func_175625_s(blockpos);
                    if (tileentity instanceof EndGatewayTileEntity && EndGatewayTileEntity.func_242690_a((Entity)this)) {
                        ((EndGatewayTileEntity)tileentity).func_195496_a((Entity)this);
                    }
                    flag = true;
                } else {
                    this.setStopped(true);
                }
            }
            if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((ThrowableEntity)this, (RayTraceResult)raytraceresult)) {
                this.func_70227_a(raytraceresult);
            }
            if (!this.stopped) {
                float f1;
                Vector3d vec3d = this.func_213322_ci();
                double d0 = this.func_226277_ct_() + vec3d.field_72450_a;
                double d1 = this.func_226278_cu_() + vec3d.field_72448_b;
                double d2 = this.func_226281_cx_() + vec3d.field_72449_c;
                if (this.func_70090_H()) {
                    for (int i = 0; i < 4; ++i) {
                        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, d0 - vec3d.field_72450_a * 0.25, d1 - vec3d.field_72448_b * 0.25, d2 - vec3d.field_72449_c * 0.25, vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
                    }
                    f1 = 0.8f;
                } else {
                    f1 = 0.99f;
                }
                this.func_213317_d(vec3d.func_186678_a((double)f1));
                if (!this.func_189652_ae()) {
                    Vector3d vec3d1 = this.func_213322_ci();
                    this.func_213293_j(vec3d1.field_72450_a, vec3d1.field_72448_b - (double)this.func_70185_h(), vec3d1.field_72449_c);
                }
                this.func_70107_b(d0, d1, d2);
            }
        }
    }

    public void stopLance() {
        this.setStopped(true);
        this.func_213293_j(0.0, 0.0, 0.0);
    }

    protected void func_70227_a(RayTraceResult rtRes) {
        if (!this.field_70170_p.field_72995_K) {
            EntityRayTraceResult ertResult = null;
            BlockRayTraceResult brtResult = null;
            if (rtRes instanceof EntityRayTraceResult) {
                ertResult = (EntityRayTraceResult)rtRes;
            }
            if (rtRes instanceof BlockRayTraceResult) {
                brtResult = (BlockRayTraceResult)rtRes;
            }
            if (ertResult != null && ertResult.func_216348_a() != null && ertResult.func_216348_a() instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)ertResult.func_216348_a();
                if (target != this.func_234616_v_()) {
                    target.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_()), this.dmg < 4.0f ? 4.0f : this.dmg);
                    this.dmg *= 0.8f;
                }
            } else if (brtResult != null && this.field_70170_p.func_180495_p(brtResult.func_216350_a()).func_177230_c() != Blocks.field_196804_gh && this.field_70170_p.func_180495_p(brtResult.func_216350_a()).func_177230_c() != Blocks.field_150349_c && this.field_70170_p.func_180495_p(brtResult.func_216350_a()).func_177230_c() != Blocks.field_196608_cF) {
                this.stopLance();
            }
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String name) {
        this.field_70180_af.func_187227_b(MODEL, (Object)name);
        this.model = name;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void setStopped(boolean stopped) {
        this.field_70180_af.func_187227_b(STOPPED, (Object)stopped);
        this.stopped = stopped;
    }

    public int getRotationPoint() {
        return this.rotationPoint;
    }

    public void setRotationPoint(int rotations) {
        this.field_70180_af.func_187227_b(ROTATION_POINT, (Object)rotations);
        this.rotationPoint = rotations;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (key.equals(MODEL)) {
            this.model = this.getModelDataManager();
        }
        if (key.equals(STOPPED)) {
            this.stopped = this.getStoppedDataManager();
        }
        if (key.equals(ROTATION_POINT)) {
            this.rotationPoint = this.getRotationPointDataManager();
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("Model", this.getModel());
        compound.func_74757_a("Stopped", this.isStopped());
        compound.func_74768_a("Rotation", this.getRotationPoint());
    }

    public void func_70037_a(CompoundNBT compound) {
        this.setModel(compound.func_74779_i("Model"));
        this.setStopped(compound.func_74767_n("Stopped"));
        this.setRotationPoint(compound.func_74762_e("Rotation"));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(MODEL, (Object)"");
        this.field_70180_af.func_187214_a(STOPPED, (Object)false);
        this.field_70180_af.func_187214_a(ROTATION_POINT, (Object)0);
    }

    public String getModelDataManager() {
        return (String)this.field_70180_af.func_187225_a(MODEL);
    }

    public boolean getStoppedDataManager() {
        return (Boolean)this.field_70180_af.func_187225_a(STOPPED);
    }

    public int getRotationPointDataManager() {
        return (Integer)this.field_70180_af.func_187225_a(ROTATION_POINT);
    }
}

