/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.organization;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.entity.ItemDropEntity;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.organization.LaserDomeShotEntity;
import online.kingdomkeys.kingdomkeys.lib.Party;

public class LaserCircleCoreEntity
extends ThrowableEntity {
    int maxTicks = 70;
    List<LaserDomeShotEntity> list = new ArrayList<LaserDomeShotEntity>();
    List<Entity> targetList = new ArrayList<Entity>();
    Set<Integer> usedIndexes = new HashSet<Integer>();
    float dmg;
    double dmgMult;
    float radius = 4.0f;
    int space;
    int shotsPerTick;
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(LaserCircleCoreEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Optional<UUID>> TARGET = EntityDataManager.func_187226_a(LaserCircleCoreEntity.class, (IDataSerializer)DataSerializers.field_187203_m);

    public LaserCircleCoreEntity(EntityType<? extends ThrowableEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public LaserCircleCoreEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super((EntityType)ModEntities.TYPE_LASER_CIRCLE.get(), world);
    }

    public LaserCircleCoreEntity(World world) {
        super((EntityType)ModEntities.TYPE_LASER_CIRCLE.get(), world);
        this.field_70156_m = true;
    }

    public LaserCircleCoreEntity(World world, PlayerEntity player, LivingEntity target, float dmg) {
        super((EntityType)ModEntities.TYPE_LASER_CIRCLE.get(), (LivingEntity)player, world);
        this.setCaster(player.func_110124_au());
        this.setTarget(target.func_110124_au());
        this.dmg = dmg;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70071_h_() {
        if (this.field_70173_aa > this.maxTicks || this.getCaster() == null) {
            this.func_70106_y();
        }
        this.dmgMult = ModConfigs.limitLaserCircleMult;
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        double X = this.func_226277_ct_();
        double Y = this.func_226278_cu_();
        double Z = this.func_226281_cx_();
        if (this.getCaster() != null) {
            if (this.field_70173_aa >= 0 && this.field_70173_aa <= 40 && this.field_70173_aa % 2 == 0) {
                double x = X + (double)this.radius * Math.cos(Math.toRadians(this.field_70173_aa * 9));
                double z = Z + (double)this.radius * Math.sin(Math.toRadians(this.field_70173_aa * 9));
                LaserDomeShotEntity bullet = new LaserDomeShotEntity(this.field_70170_p, (LivingEntity)this.getCaster(), (double)this.dmg * this.dmgMult);
                bullet.func_70107_b(x, Y + 1.0, z);
                bullet.setMaxTicks(this.maxTicks);
                bullet.func_70186_c(this.func_226277_ct_() - bullet.func_226277_ct_(), this.func_226278_cu_() - bullet.func_226278_cu_() + 1.0, this.func_226281_cx_() - bullet.func_226281_cx_(), 0.001f, 0.0f);
                this.field_70170_p.func_184133_a(this.getCaster(), this.getCaster().func_233580_cy_(), (SoundEvent)ModSounds.laser.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                this.list.add(bullet);
                this.field_70170_p.func_217376_c((Entity)bullet);
                this.func_213293_j(0.0, 0.0, 0.0);
                this.field_70133_I = true;
            } else if (this.field_70173_aa == 60) {
                this.updateList();
                LaserCircleCoreEntity target = this;
                if (this.targetList.size() > 1) {
                    this.targetList.remove((Object)this);
                }
                int targetIndex = this.field_70146_Z.nextInt(this.targetList.size());
                target = this.targetList.get(targetIndex);
                for (LaserDomeShotEntity bullet : this.list) {
                    if (target == null || !target.func_70089_S() || this.getCaster() == null) continue;
                    bullet.func_70186_c(target.func_226277_ct_() - bullet.func_226277_ct_(), target.func_226278_cu_() - bullet.func_226278_cu_() + 1.0, target.func_226281_cx_() - bullet.func_226281_cx_(), 1.5f, 0.0f);
                }
                this.field_70170_p.func_184133_a(this.getCaster(), this.getCaster().func_233580_cy_(), (SoundEvent)ModSounds.laser.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
        super.func_70071_h_();
    }

    private void updatePos(float r) {
        for (LaserDomeShotEntity shot : this.list) {
            double x = this.func_226277_ct_() + (double)r * Math.cos(Math.toRadians(shot.field_70173_aa * 9));
            double z = this.func_226281_cx_() + (double)r * Math.sin(Math.toRadians(shot.field_70173_aa * 9));
            shot.func_70107_b(x, this.func_226278_cu_() + 1.0, z);
            shot.func_70186_c(this.func_226277_ct_() - shot.func_226277_ct_(), this.func_226278_cu_() - shot.func_226278_cu_(), this.func_226281_cx_() - shot.func_226281_cx_(), 0.001f, 0.0f);
        }
    }

    private void updateList() {
        List tempList = this.field_70170_p.func_72839_b((Entity)this.getCaster(), this.func_174813_aQ().func_72314_b((double)this.radius, (double)this.radius, (double)this.radius));
        Party casterParty = ModCapabilities.getWorld(this.field_70170_p).getPartyFromMember(this.getCaster().func_110124_au());
        if (casterParty != null && !casterParty.getFriendlyFire()) {
            for (Party.Member m : casterParty.getMembers()) {
                tempList.remove(this.field_70170_p.func_217371_b(m.getUUID()));
            }
        } else {
            tempList.remove(this.func_234616_v_());
        }
        this.targetList.clear();
        for (Entity t : tempList) {
            if (t instanceof LaserDomeShotEntity || t instanceof ItemDropEntity || t instanceof ItemEntity || t instanceof ExperienceOrbEntity) continue;
            this.targetList.add(t);
        }
    }

    protected void func_70227_a(RayTraceResult rtRes) {
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.field_70180_af.func_187225_a(OWNER) != null) {
            compound.func_74778_a("OwnerUUID", ((UUID)((Optional)this.field_70180_af.func_187225_a(OWNER)).get()).toString());
            compound.func_74778_a("TargetUUID", ((UUID)((Optional)this.field_70180_af.func_187225_a(TARGET)).get()).toString());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(OWNER, Optional.of(UUID.fromString(compound.func_74779_i("OwnerUUID"))));
        this.field_70180_af.func_187227_b(TARGET, Optional.of(UUID.fromString(compound.func_74779_i("TargetUUID"))));
    }

    public PlayerEntity getCaster() {
        return ((Optional)this.func_184212_Q().func_187225_a(OWNER)).isPresent() ? this.field_70170_p.func_217371_b((UUID)((Optional)this.func_184212_Q().func_187225_a(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER, Optional.of(uuid));
    }

    public PlayerEntity getTarget() {
        return ((Optional)this.func_184212_Q().func_187225_a(TARGET)).isPresent() ? this.field_70170_p.func_217371_b((UUID)((Optional)this.func_184212_Q().func_187225_a(TARGET)).get()) : null;
    }

    public void setTarget(UUID uuid) {
        this.field_70180_af.func_187227_b(TARGET, Optional.of(uuid));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OWNER, Optional.of(new UUID(0L, 0L)));
        this.field_70180_af.func_187214_a(TARGET, Optional.of(new UUID(0L, 0L)));
    }
}

