/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.shotlock;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.shotlock.RagnarokShotEntity;

public class RagnarokCoreEntity
extends ThrowableEntity {
    int maxTicks = 100;
    List<RagnarokShotEntity> list = new ArrayList<RagnarokShotEntity>();
    List<Entity> targetList = new ArrayList<Entity>();
    float dmg;
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(RagnarokCoreEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<String> TARGETS = EntityDataManager.func_187226_a(RagnarokCoreEntity.class, (IDataSerializer)DataSerializers.field_187194_d);

    public RagnarokCoreEntity(EntityType<? extends ThrowableEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public RagnarokCoreEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super((EntityType)ModEntities.TYPE_SHOTLOCK_CIRCULAR.get(), world);
    }

    public RagnarokCoreEntity(World world) {
        super((EntityType)ModEntities.TYPE_SHOTLOCK_CIRCULAR.get(), world);
        this.field_70156_m = true;
    }

    public RagnarokCoreEntity(World world, PlayerEntity player, List<Entity> targets, float dmg) {
        super((EntityType)ModEntities.TYPE_SHOTLOCK_CIRCULAR.get(), (LivingEntity)player, world);
        this.setCaster(player.func_110124_au());
        String targetIDS = "";
        for (Entity t : targets) {
            targetIDS = targetIDS + "," + t.func_145782_y();
        }
        this.setTarget(targetIDS.substring(1));
        this.targetList = targets;
        this.dmg = dmg;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70071_h_() {
        if (this.field_70173_aa > this.maxTicks || this.getCaster() == null) {
            this.func_70106_y();
        }
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        double X = this.func_226277_ct_();
        double Y = this.func_226278_cu_() + 1.0;
        double Z = this.func_226281_cx_();
        if (this.getCaster() != null && this.getTargets() != null) {
            if (this.field_70173_aa == 1) {
                this.field_70170_p.func_184133_a(null, this.func_233580_cy_(), (SoundEvent)ModSounds.laser.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                for (int i = 0; i < this.getTargets().size(); ++i) {
                    Entity target = this.getTargets().get(i);
                    if (target == null) continue;
                    RagnarokShotEntity bullet = new RagnarokShotEntity(this.field_70170_p, (LivingEntity)this.getCaster(), target, this.dmg);
                    float r = 0.3f;
                    double offset_amount = -1.5;
                    double alpha = Math.toRadians(this.getCaster().field_70177_z);
                    double theta = Math.PI * 2 / (double)this.getTargets().size();
                    double x = X + offset_amount * Math.sin(alpha) + (double)r * ((Math.cos((double)i * theta) + Math.sin(alpha) * Math.sin(alpha) * (1.0 - Math.cos((double)i * theta))) * Math.cos(alpha) + -Math.cos(alpha) * Math.sin(alpha) * (1.0 - Math.cos((double)i * theta)) * Math.sin(alpha));
                    double y = Y + (double)r * (Math.cos(alpha) * Math.sin((double)i * theta) * Math.cos(alpha) + Math.sin(alpha) * Math.sin((double)i * theta) * Math.sin(alpha));
                    double z = Z - offset_amount * Math.cos(alpha) + (double)r * (-Math.cos(alpha) * Math.sin(alpha) * (1.0 - Math.cos((double)i * theta)) * Math.cos(alpha) + (Math.cos((double)i * theta) + Math.cos(alpha) * Math.cos(alpha) * (1.0 - Math.cos((double)i * theta))) * Math.sin(alpha));
                    bullet.func_70107_b(x, y, z);
                    bullet.setMaxTicks(this.maxTicks + 20);
                    this.list.add(bullet);
                    this.field_70170_p.func_217376_c((Entity)bullet);
                }
            } else if (this.field_70173_aa > 4 && this.field_70173_aa < 10) {
                for (int i = 0; i < this.list.size(); ++i) {
                    RagnarokShotEntity bullet = this.list.get(i);
                    float posI = i + this.field_70173_aa * 2;
                    float r = 0.3f * (float)this.field_70173_aa;
                    double offset_amount = -2.0;
                    double alpha = Math.toRadians(this.getCaster().field_70177_z);
                    double theta = Math.PI * 2 / (double)this.getTargets().size();
                    double x = X + offset_amount * Math.sin(alpha) + (double)r * ((Math.cos((double)posI * theta) + Math.sin(alpha) * Math.sin(alpha) * (1.0 - Math.cos((double)posI * theta))) * Math.cos(alpha) + -Math.cos(alpha) * Math.sin(alpha) * (1.0 - Math.cos((double)posI * theta)) * Math.sin(alpha));
                    double y = Y + (double)r * (Math.cos(alpha) * Math.sin((double)posI * theta) * Math.cos(alpha) + Math.sin(alpha) * Math.sin((double)posI * theta) * Math.sin(alpha));
                    double z = Z - offset_amount * Math.cos(alpha) + (double)r * (-Math.cos(alpha) * Math.sin(alpha) * (1.0 - Math.cos((double)posI * theta)) * Math.cos(alpha) + (Math.cos((double)posI * theta) + Math.cos(alpha) * Math.cos(alpha) * (1.0 - Math.cos((double)posI * theta))) * Math.sin(alpha));
                    bullet.func_70107_b(x, y, z);
                }
            }
        }
        super.func_70071_h_();
    }

    protected void func_70227_a(RayTraceResult rtRes) {
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.field_70180_af.func_187225_a(OWNER) != null) {
            compound.func_74778_a("OwnerUUID", ((UUID)((Optional)this.field_70180_af.func_187225_a(OWNER)).get()).toString());
            compound.func_74778_a("TargetsUUID", (String)this.field_70180_af.func_187225_a(TARGETS));
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(OWNER, Optional.of(UUID.fromString(compound.func_74779_i("OwnerUUID"))));
        this.field_70180_af.func_187227_b(TARGETS, (Object)compound.func_74779_i("TargetUUID"));
    }

    public PlayerEntity getCaster() {
        return ((Optional)this.func_184212_Q().func_187225_a(OWNER)).isPresent() ? this.field_70170_p.func_217371_b((UUID)((Optional)this.func_184212_Q().func_187225_a(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER, Optional.of(uuid));
    }

    public List<Entity> getTargets() {
        String[] ids;
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (String id : ids = ((String)this.func_184212_Q().func_187225_a(TARGETS)).split(",")) {
            if (id.equals("")) continue;
            list.add(this.field_70170_p.func_73045_a(Integer.parseInt(id)));
        }
        return list;
    }

    public void setTarget(String lists) {
        this.field_70180_af.func_187227_b(TARGETS, (Object)lists);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OWNER, Optional.of(new UUID(0L, 0L)));
        this.field_70180_af.func_187214_a(TARGETS, (Object)"");
    }
}

