/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.shotlock;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.shotlock.DarkVolleyCoreEntity;

public class VolleyShotEntity
extends ThrowableEntity {
    int maxTicks = 100;
    float dmg;
    Entity target;
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(DarkVolleyCoreEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Integer> TARGET = EntityDataManager.func_187226_a(DarkVolleyCoreEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public VolleyShotEntity(EntityType<? extends ThrowableEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public VolleyShotEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super((EntityType)ModEntities.TYPE_VOLLEY_SHOTLOCK_SHOT.get(), world);
    }

    public VolleyShotEntity(World world) {
        super((EntityType)ModEntities.TYPE_VOLLEY_SHOTLOCK_SHOT.get(), world);
        this.field_70156_m = true;
    }

    public VolleyShotEntity(World world, LivingEntity player, Entity target, double dmg) {
        super((EntityType)ModEntities.TYPE_VOLLEY_SHOTLOCK_SHOT.get(), player, world);
        this.dmg = (float)dmg;
        this.setTarget(target.func_145782_y());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70071_h_() {
        if (this.field_70173_aa > this.maxTicks) {
            this.func_70106_y();
        }
        if (this.field_70173_aa > 1) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197616_i, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        if (this.field_70173_aa % 10 == 0) {
            this.updateMovement();
        }
        super.func_70071_h_();
    }

    private void updateMovement() {
        if (this.getTarget() != null) {
            if (this.getTarget().func_70089_S()) {
                this.func_70186_c(this.getTarget().func_226277_ct_() - this.func_226277_ct_(), this.getTarget().func_226278_cu_() + (double)(this.getTarget().func_213302_cg() / 2.0f) - (double)this.func_213302_cg() - this.func_226278_cu_() + 0.5, this.getTarget().func_226281_cx_() - this.func_226281_cx_(), 1.0f, 0.0f);
            } else if (this.func_234616_v_() != null) {
                this.func_234612_a_((Entity)this, this.func_234616_v_().field_70125_A, this.func_234616_v_().field_70177_z, 0.0f, 1.0f, 0.0f);
            }
        }
    }

    protected void func_70227_a(RayTraceResult rtRes) {
        if (!this.field_70170_p.field_72995_K) {
            LivingEntity target;
            EntityRayTraceResult ertResult = null;
            BlockRayTraceResult brtResult = null;
            if (rtRes instanceof EntityRayTraceResult) {
                ertResult = (EntityRayTraceResult)rtRes;
            }
            if (rtRes instanceof BlockRayTraceResult) {
                brtResult = (BlockRayTraceResult)rtRes;
            }
            if (ertResult != null && ertResult.func_216348_a() instanceof LivingEntity && (target = (LivingEntity)ertResult.func_216348_a()) != this.func_234616_v_()) {
                target.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_234616_v_()), this.dmg);
                super.func_70106_y();
            }
            this.func_70106_y();
        }
    }

    public void func_70106_y() {
        if (this.field_70173_aa > 20) {
            super.func_70106_y();
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.field_70180_af.func_187225_a(OWNER) != null) {
            compound.func_74778_a("OwnerUUID", ((UUID)((Optional)this.field_70180_af.func_187225_a(OWNER)).get()).toString());
            compound.func_74768_a("TargetUUID", ((Integer)this.field_70180_af.func_187225_a(TARGET)).intValue());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(OWNER, Optional.of(UUID.fromString(compound.func_74779_i("OwnerUUID"))));
        this.field_70180_af.func_187227_b(TARGET, (Object)compound.func_74762_e("TargetUUID"));
    }

    public PlayerEntity getCaster() {
        return ((Optional)this.func_184212_Q().func_187225_a(OWNER)).isPresent() ? this.field_70170_p.func_217371_b((UUID)((Optional)this.func_184212_Q().func_187225_a(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER, Optional.of(uuid));
    }

    public Entity getTarget() {
        return this.field_70170_p.func_73045_a(((Integer)this.func_184212_Q().func_187225_a(TARGET)).intValue());
    }

    public void setTarget(int i) {
        this.field_70180_af.func_187227_b(TARGET, (Object)i);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OWNER, Optional.of(new UUID(0L, 0L)));
        this.field_70180_af.func_187214_a(TARGET, (Object)0);
    }
}

