/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.handler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.boss.WitherEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.capability.IGlobalCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.damagesource.StopDamageSource;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.entity.DriveOrbEntity;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.FocusOrbEntity;
import online.kingdomkeys.kingdomkeys.entity.HPOrbEntity;
import online.kingdomkeys.kingdomkeys.entity.HeartEntity;
import online.kingdomkeys.kingdomkeys.entity.MPOrbEntity;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.MunnyEntity;
import online.kingdomkeys.kingdomkeys.entity.SpawningMode;
import online.kingdomkeys.kingdomkeys.entity.magic.ThunderBoltEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.DuskEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.IKHMob;
import online.kingdomkeys.kingdomkeys.entity.mob.MoogleEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.ShadowEntity;
import online.kingdomkeys.kingdomkeys.entity.shotlock.RagnarokShotEntity;
import online.kingdomkeys.kingdomkeys.entity.shotlock.VolleyShotEntity;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.item.SynthesisItem;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.item.organization.OrganizationDataLoader;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCOpenAlignmentScreen;
import online.kingdomkeys.kingdomkeys.network.stc.SCRecalculateEyeHeight;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncGlobalCapabilityPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncKeybladeData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncOrganizationData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncSynthesisData;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncWorldCapability;
import online.kingdomkeys.kingdomkeys.reactioncommands.ModReactionCommands;
import online.kingdomkeys.kingdomkeys.reactioncommands.ReactionCommand;
import online.kingdomkeys.kingdomkeys.synthesis.keybladeforge.KeybladeDataLoader;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class EntityEvents {
    public static boolean isBoss = false;
    public static boolean isHostiles = false;
    public int ticks;
    Map<UUID, Boolean> openedAlignment = new HashMap<UUID, Boolean>();

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent e) {
        PlayerEntity player = e.getPlayer();
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
        IWorldCapabilities worldData = ModCapabilities.getWorld(player.field_70170_p);
        if (playerData != null) {
            if (worldData != null) {
                if (worldData.getHeartlessSpawnLevel() > 0 && ModConfigs.heartlessSpawningMode == SpawningMode.NEVER) {
                    worldData.setHeartlessSpawnLevel(0);
                } else if (worldData.getHeartlessSpawnLevel() == 0 && ModConfigs.heartlessSpawningMode == SpawningMode.ALWAYS) {
                    worldData.setHeartlessSpawnLevel(1);
                }
            }
            if (!player.field_70170_p.field_72995_K) {
                if (!playerData.getDriveFormMap().containsKey(DriveForm.NONE)) {
                    playerData.setDriveFormLevel(DriveForm.NONE.toString(), 1);
                    playerData.addKnownRecipe(((Item)ModItems.mythril_shard.get()).getRegistryName());
                    playerData.addKnownRecipe(((Item)ModItems.mythril_stone.get()).getRegistryName());
                    playerData.addKnownRecipe(((Item)ModItems.mythril_gem.get()).getRegistryName());
                    playerData.addKnownRecipe(((Item)ModItems.mythril_crystal.get()).getRegistryName());
                    playerData.addAbility("kingdomkeys:ability_zero_exp", false);
                    playerData.addKnownRecipe(((Item)ModItems.potion.get()).getRegistryName());
                    playerData.addKnownRecipe(((Item)ModItems.hiPotion.get()).getRegistryName());
                    playerData.addKnownRecipe(((Item)ModItems.megaPotion.get()).getRegistryName());
                    playerData.addKnownRecipe(((Item)ModItems.ether.get()).getRegistryName());
                    playerData.addKnownRecipe(((Item)ModItems.hiEther.get()).getRegistryName());
                    playerData.addKnownRecipe(((Item)ModItems.megaEther.get()).getRegistryName());
                    playerData.addKnownRecipe(((Item)ModItems.elixir.get()).getRegistryName());
                    playerData.addKnownRecipe(((Item)ModItems.megaLixir.get()).getRegistryName());
                    playerData.addKnownRecipe(((Item)ModItems.driveRecovery.get()).getRegistryName());
                    playerData.addKnownRecipe(((Item)ModItems.hiDriveRecovery.get()).getRegistryName());
                    playerData.addKnownRecipe(((Item)ModItems.refocuser.get()).getRegistryName());
                    playerData.addKnownRecipe(((Item)ModItems.hiRefocuser.get()).getRegistryName());
                }
                playerData.getDriveFormMap().keySet().forEach(key -> {
                    if (ModDriveForms.registry.containsKey(new ResourceLocation(key)) && ((DriveForm)ModDriveForms.registry.getValue(new ResourceLocation(key))).hasKeychain() && playerData.getDriveFormMap().containsKey(key) && !playerData.getEquippedKeychains().containsKey(new ResourceLocation(key))) {
                        playerData.setNewKeychain(new ResourceLocation(key), ItemStack.field_190927_a);
                    }
                });
                PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayerEntity)player);
                PacketHandler.sendTo(new SCSyncWorldCapability(worldData), (ServerPlayerEntity)player);
                PacketHandler.syncToAllAround(player, playerData);
                PacketHandler.sendTo(new SCSyncKeybladeData(KeybladeDataLoader.names, KeybladeDataLoader.dataList), (ServerPlayerEntity)player);
                PacketHandler.sendTo(new SCSyncOrganizationData(OrganizationDataLoader.names, OrganizationDataLoader.dataList), (ServerPlayerEntity)player);
                PacketHandler.sendTo(new SCSyncSynthesisData(RecipeRegistry.getInstance().getValues()), (ServerPlayerEntity)player);
            }
            PacketHandler.syncToAllAround(player, playerData);
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            IPlayerCapabilities playerData;
            if (this.ticks >= Integer.MAX_VALUE) {
                this.ticks = Integer.MIN_VALUE;
            }
            if ((playerData = ModCapabilities.getPlayer(event.player)) != null) {
                ArrayList<ReactionCommand> rcList = new ArrayList<ReactionCommand>();
                for (ReactionCommand rc : ModReactionCommands.registry.getValues()) {
                    if (!rc.conditionsToAppear(event.player, (LivingEntity)event.player)) continue;
                    rcList.add(rc);
                }
                playerData.setReactionCommands(new ArrayList<String>());
                for (ReactionCommand rc : rcList) {
                    playerData.addReactionCommand(rc.getName(), event.player);
                }
                if (!event.player.field_70170_p.field_72995_K && event.player.field_70173_aa == 5) {
                    PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayerEntity)event.player);
                }
                if (playerData.getActiveDriveForm().equals("kingdomkeys:form_anti")) {
                    if (playerData.getFP() > 0.0) {
                        playerData.setFP(playerData.getFP() - 0.3);
                    } else {
                        playerData.setActiveDriveForm(DriveForm.NONE.toString());
                        event.player.field_70170_p.func_184133_a(event.player, event.player.func_233580_cy_(), (SoundEvent)ModSounds.unsummon.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                        if (!event.player.field_70170_p.field_72995_K) {
                            PacketHandler.syncToAllAround(event.player, playerData);
                        }
                    }
                } else if (!playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                    ((DriveForm)ModDriveForms.registry.getValue(new ResourceLocation(playerData.getActiveDriveForm()))).updateDrive(event.player);
                }
                if (playerData.getLimitCooldownTicks() > 0 && !event.player.field_70170_p.field_72995_K) {
                    playerData.setLimitCooldownTicks(playerData.getLimitCooldownTicks() - 1);
                    if (playerData.getLimitCooldownTicks() <= 0) {
                        PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayerEntity)event.player);
                    }
                }
                if (playerData.getMagicCooldownTicks() > 0 && !event.player.field_70170_p.field_72995_K) {
                    playerData.setMagicCooldownTicks(playerData.getMagicCooldownTicks() - 1);
                    if (playerData.getMagicCooldownTicks() <= 0) {
                        PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayerEntity)event.player);
                    }
                }
                if (playerData.getRecharge()) {
                    if (playerData.getMP() >= playerData.getMaxMP()) {
                        playerData.setRecharge(false);
                        playerData.setMP(playerData.getMaxMP());
                    } else {
                        playerData.addMP(playerData.getMaxMP() / 500.0 * (Utils.getMPHasteValue(playerData) / 10.0 + 2.0));
                    }
                } else if (playerData.getMP() <= 0.0 && playerData.getMaxMP() > 0.0) {
                    playerData.setRecharge(true);
                    if (!event.player.field_70170_p.field_72995_K) {
                        PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayerEntity)event.player);
                    }
                }
                if (!event.player.field_70170_p.field_72995_K && playerData.getAlignment() == Utils.OrgMember.NONE) {
                    boolean wearingOrgCloak;
                    if (!this.openedAlignment.containsKey(event.player.func_110124_au())) {
                        this.openedAlignment.put(event.player.func_110124_au(), false);
                    }
                    if (wearingOrgCloak = Utils.isWearingOrgRobes(event.player)) {
                        if (!this.openedAlignment.get(event.player.func_110124_au()).booleanValue()) {
                            PacketHandler.sendTo(new SCOpenAlignmentScreen(), (ServerPlayerEntity)event.player);
                            this.openedAlignment.put(event.player.func_110124_au(), true);
                        }
                    } else {
                        this.openedAlignment.put(event.player.func_110124_au(), false);
                    }
                }
            }
        }
        if (this.ticks % 5 == 0) {
            List entities = event.player.field_70170_p.func_72839_b((Entity)event.player, event.player.func_174813_aQ().func_72314_b(16.0, 10.0, 16.0).func_72317_d(-8.0, -5.0, -8.0));
            List bossEntities = event.player.field_70170_p.func_72839_b((Entity)event.player, event.player.func_174813_aQ().func_72314_b(150.0, 100.0, 150.0).func_72317_d(-75.0, -50.0, -75.0));
            if (!bossEntities.isEmpty()) {
                for (int i = 0; i < bossEntities.size(); ++i) {
                    if (bossEntities.get(i) instanceof EnderDragonEntity || bossEntities.get(i) instanceof WitherEntity) {
                        isBoss = true;
                        break;
                    }
                    isBoss = false;
                }
            } else {
                isBoss = false;
            }
            if (!entities.isEmpty()) {
                for (Entity entity : entities) {
                    if (entity instanceof MonsterEntity) {
                        isHostiles = true;
                        break;
                    }
                    isHostiles = false;
                }
            } else {
                isHostiles = false;
            }
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        block39: {
            PlayerEntity player;
            IPlayerCapabilities playerData;
            block40: {
                double y;
                double z;
                double x;
                int t;
                double Z;
                double Y;
                double X;
                IGlobalCapabilities globalData = ModCapabilities.getGlobal(event.getEntityLiving());
                playerData = null;
                player = null;
                if (event.getEntityLiving() instanceof PlayerEntity) {
                    player = (PlayerEntity)event.getEntityLiving();
                    playerData = ModCapabilities.getPlayer(player);
                }
                if (globalData != null) {
                    PlayerEntity pl;
                    if (globalData.getStoppedTicks() > 0) {
                        globalData.subStoppedTicks(1);
                        event.getEntityLiving().func_213293_j(0.0, 0.0, 0.0);
                        event.getEntityLiving().field_70133_I = true;
                        if (event.getEntityLiving() instanceof MobEntity) {
                            ((MobEntity)event.getEntityLiving()).func_70624_b(null);
                        }
                        if (globalData.getStoppedTicks() <= 0) {
                            if (event.getEntityLiving() instanceof MobEntity) {
                                ((MobEntity)event.getEntityLiving()).func_94061_f(false);
                            }
                            globalData.setStoppedTicks(0);
                            if (globalData.getDamage() > 0.0f && globalData.getStopCaster() != null) {
                                event.getEntityLiving().func_70097_a(StopDamageSource.getStopDamage(Utils.getPlayerByName(event.getEntity().field_70170_p, globalData.getStopCaster())), globalData.getDamage() / 2.0f);
                            }
                            if (event.getEntityLiving() instanceof ServerPlayerEntity) {
                                PacketHandler.sendTo(new SCSyncGlobalCapabilityPacket(globalData), (ServerPlayerEntity)event.getEntityLiving());
                            }
                            globalData.setDamage(0.0f);
                            globalData.setStopCaster(null);
                        }
                    }
                    if (globalData.getFlatTicks() > 0) {
                        globalData.subFlatTicks(1);
                        if (event.getEntityLiving() instanceof PlayerEntity && ((PlayerEntity)event.getEntityLiving()).getForcedPose() != Pose.SWIMMING) {
                            ((PlayerEntity)event.getEntityLiving()).setForcedPose(Pose.SWIMMING);
                        }
                        event.getEntityLiving().func_213293_j(0.0, -4.0, 0.0);
                        event.getEntityLiving().field_70133_I = true;
                        if (globalData.getFlatTicks() <= 0) {
                            globalData.setFlatTicks(0);
                            if (event.getEntityLiving() instanceof LivingEntity) {
                                PacketHandler.syncToAllAround(event.getEntityLiving(), globalData);
                                if (event.getEntityLiving() instanceof ServerPlayerEntity) {
                                    PacketHandler.sendTo(new SCRecalculateEyeHeight(), (ServerPlayerEntity)event.getEntityLiving());
                                }
                            }
                        }
                    } else if (event.getEntityLiving() instanceof PlayerEntity && (pl = (PlayerEntity)event.getEntityLiving()).getForcedPose() != null && !ModCapabilities.getPlayer(pl).getIsGliding()) {
                        pl.setForcedPose(null);
                    }
                }
                if (playerData == null) break block39;
                if (playerData.getAerialDodgeTicks() > 0) {
                    playerData.setAerialDodgeTicks(playerData.getAerialDodgeTicks() - 1);
                }
                if (playerData.getReflectTicks() > 0) {
                    playerData.remReflectTicks(1);
                    event.getEntityLiving().func_213293_j(0.0, 0.0, 0.0);
                    event.getEntityLiving().field_70133_I = true;
                    float radius = 1.5f;
                    X = event.getEntityLiving().func_226277_ct_();
                    Y = event.getEntityLiving().func_226278_cu_();
                    Z = event.getEntityLiving().func_226281_cx_();
                    for (t = 1; t < 360; t += 20) {
                        for (int s = 1; s < 360; s += 20) {
                            x = X + (double)radius * Math.cos(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                            z = Z + (double)radius * Math.sin(Math.toRadians(s)) * Math.sin(Math.toRadians(t));
                            y = Y + (double)radius * Math.cos(Math.toRadians(t));
                            event.getEntityLiving().field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_203217_T, x, y + 1.0, z, 0.0, 0.0, 0.0);
                        }
                    }
                } else if (playerData.getReflectActive()) {
                    float dmgMult = 1.0f;
                    float radius = 1.0f;
                    switch (playerData.getReflectLevel()) {
                        case 0: {
                            radius = 2.5f;
                            dmgMult = 0.3f;
                            break;
                        }
                        case 1: {
                            radius = 3.0f;
                            dmgMult = 0.5f;
                            break;
                        }
                        case 2: {
                            radius = 3.5f;
                            dmgMult = 0.7f;
                        }
                    }
                    List list = player.field_70170_p.func_72839_b((Entity)player, player.func_174813_aQ().func_72314_b((double)radius, (double)radius, (double)radius));
                    Party casterParty = ModCapabilities.getWorld(player.field_70170_p).getPartyFromMember(player.func_110124_au());
                    if (casterParty != null && !casterParty.getFriendlyFire()) {
                        for (Party.Member m : casterParty.getMembers()) {
                            list.remove(player.field_70170_p.func_217371_b(m.getUUID()));
                        }
                    }
                    double X2 = event.getEntityLiving().func_226277_ct_();
                    double Y2 = event.getEntityLiving().func_226278_cu_();
                    double Z2 = event.getEntityLiving().func_226281_cx_();
                    for (int t2 = 1; t2 < 360; t2 += 20) {
                        double x2 = X2 + (double)radius * Math.cos(Math.toRadians(t2));
                        double z2 = Z2 + (double)radius * Math.sin(Math.toRadians(t2));
                        ((ServerWorld)event.getEntityLiving().field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197612_e.func_197554_b(), x2, Y2 + 1.0, z2, 5, 0.0, 0.0, 0.0, 1.0);
                    }
                    if (!list.isEmpty()) {
                        for (int i = 0; i < list.size(); ++i) {
                            Entity e = (Entity)list.get(i);
                            if (!(e instanceof LivingEntity)) continue;
                            e.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), DamageCalculation.getMagicDamage(player) * dmgMult);
                        }
                        player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)ModSounds.reflect2.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                    playerData.setReflectActive(false);
                }
                if (playerData.getAeroTicks() <= 0) break block39;
                playerData.remAeroTicks(1);
                if (player.field_70173_aa % 5 == 0) {
                    float radius = 1.0f;
                    X = event.getEntityLiving().func_226277_ct_();
                    Y = event.getEntityLiving().func_226278_cu_();
                    Z = event.getEntityLiving().func_226281_cx_();
                    for (t = 1; t < 360; t += 30) {
                        for (int s = 1; s < 360; s += 30) {
                            x = X + (double)radius * Math.cos(Math.toRadians(s)) * Math.sin(Math.toRadians(t)) / 2.0;
                            z = Z + (double)radius * Math.sin(Math.toRadians(s)) * Math.sin(Math.toRadians(t)) / 2.0;
                            y = Y + (double)radius * Math.cos(Math.toRadians(t));
                            event.getEntityLiving().field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_203217_T, x, y + 1.0, z, 0.0, 0.0, 0.0);
                        }
                    }
                }
                if (playerData.getAeroLevel() != 1) break block40;
                if (player.field_70173_aa % 20 != 0) break block39;
                float radius = 0.4f;
                List<Entity> list = player.field_70170_p.func_72839_b((Entity)player, player.func_174813_aQ().func_72314_b((double)radius, (double)radius, (double)radius));
                if (!list.isEmpty()) {
                    list = Utils.removeFriendlyEntities(list);
                    for (Entity e : list) {
                        if (!(e instanceof LivingEntity)) continue;
                        e.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), DamageCalculation.getMagicDamage(player) * 0.05f);
                    }
                }
                break block39;
            }
            if (playerData.getAeroLevel() == 2 && player.field_70173_aa % 10 == 0) {
                float radius = 0.6f;
                List<Entity> list = player.field_70170_p.func_72839_b((Entity)player, player.func_174813_aQ().func_72314_b((double)radius, (double)radius, (double)radius));
                if (!list.isEmpty()) {
                    list = Utils.removeFriendlyEntities(list);
                    for (Entity e : list) {
                        if (!(e instanceof LivingEntity)) continue;
                        e.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), DamageCalculation.getMagicDamage(player) * 0.1f);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void entityPickup(EntityItemPickupEvent event) {
        if (event.getPlayer().field_71071_by.func_70431_c(new ItemStack((IItemProvider)ModItems.synthesisBag.get())) && event.getItem().func_92059_d() != null && event.getItem().func_92059_d().func_77973_b() instanceof SynthesisItem) {
            for (int i = 0; i < event.getPlayer().field_71071_by.func_70302_i_(); ++i) {
                ItemStack bag = event.getPlayer().field_71071_by.func_70301_a(i);
                if (ItemStack.func_77989_b((ItemStack)bag, (ItemStack)ItemStack.field_190927_a) || bag.func_77973_b() != ModItems.synthesisBag.get()) continue;
                IItemHandler inv = (IItemHandler)bag.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElse(null);
                this.addSynthesisMaterialToBag(inv, event, bag);
            }
        }
    }

    public void addSynthesisMaterialToBag(IItemHandler inv, EntityItemPickupEvent event, ItemStack bag) {
        CompoundNBT nbt = bag.func_196082_o();
        int bagLevel = nbt.func_74762_e("level");
        int maxSlots = 0;
        switch (bagLevel) {
            case 0: {
                maxSlots = 18;
                break;
            }
            case 1: {
                maxSlots = 36;
                break;
            }
            case 2: {
                maxSlots = 54;
            }
        }
        for (int j = 0; j < maxSlots; ++j) {
            ItemStack bagItem = inv.getStackInSlot(j);
            ItemStack pickUp = event.getItem().func_92059_d();
            if (!ItemStack.func_77989_b((ItemStack)bagItem, (ItemStack)ItemStack.field_190927_a)) {
                if (!bagItem.func_77973_b().equals(pickUp.func_77973_b()) || bagItem.func_190916_E() >= 64 || bagItem.func_190916_E() + pickUp.func_190916_E() > 64) continue;
                ItemStack stack = new ItemStack((IItemProvider)pickUp.func_77946_l().func_77973_b(), pickUp.func_77946_l().func_190916_E());
                inv.insertItem(j, stack, false);
                pickUp.func_190920_e(0);
                return;
            }
            if (!ItemStack.func_77989_b((ItemStack)bagItem, (ItemStack)ItemStack.field_190927_a)) continue;
            inv.insertItem(j, pickUp.func_77946_l(), false);
            pickUp.func_190920_e(0);
            return;
        }
    }

    @SubscribeEvent
    public void hitEntity(LivingHurtEvent event) {
        PlayerEntity player;
        if (event.getSource().func_76346_g() instanceof PlayerEntity) {
            IPlayerCapabilities playerData;
            player = (PlayerEntity)event.getSource().func_76346_g();
            ItemStack weapon = null;
            weapon = Utils.getWeaponDamageStack(event.getSource(), player);
            if (weapon != null && !(event.getSource() instanceof StopDamageSource)) {
                float dmg = 0.0f;
                if (weapon.func_77973_b() instanceof KeybladeItem) {
                    dmg = DamageCalculation.getKBStrengthDamage(player, weapon);
                } else if (weapon.func_77973_b() instanceof IOrgWeapon) {
                    dmg = DamageCalculation.getOrgStrengthDamage(player, weapon);
                }
                event.setAmount(dmg);
            }
            if (ModCapabilities.getPlayer(player).getActiveDriveForm().equals("kingdomkeys:form_anti")) {
                event.setAmount((float)ModCapabilities.getPlayer(player).getStrength());
            }
            LivingEntity target = event.getEntityLiving();
            if (event.getSource().func_76364_f() instanceof VolleyShotEntity || event.getSource().func_76364_f() instanceof RagnarokShotEntity || event.getSource().func_76364_f() instanceof ThunderBoltEntity) {
                target.field_70172_ad = 0;
            }
            if (target instanceof PlayerEntity && (playerData = ModCapabilities.getPlayer((PlayerEntity)target)).getReflectTicks() <= 0) {
                if (playerData.isAbilityEquipped("kingdomkeys:ability_mp_rage")) {
                    playerData.addMP(event.getAmount() * 0.05f);
                    PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayerEntity)target);
                }
                if (playerData.isAbilityEquipped("kingdomkeys:ability_damage_drive")) {
                    playerData.addDP(event.getAmount() * 0.05f);
                    PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayerEntity)target);
                }
            }
        }
        if (event.getEntityLiving() instanceof PlayerEntity) {
            player = (PlayerEntity)event.getEntityLiving();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            float damage = Math.round(event.getAmount() * 100.0f / (float)(100 + playerData.getLevel() * 2 + playerData.getDefense()));
            if (playerData.getAeroTicks() > 0) {
                float resistMultiplier = playerData.getAeroLevel() == 0 ? 0.3f : (playerData.getAeroLevel() == 1 ? 0.35f : (playerData.getAeroLevel() == 2 ? 0.4f : 0.0f));
                playerData.remAeroTicks((int)damage * 2);
                damage -= damage * resistMultiplier;
            }
            if (playerData.isAbilityEquipped("kingdomkeys:ability_second_chance") && damage >= player.func_110143_aJ() && player.func_110143_aJ() > 1.0f) {
                if (player.func_70644_a(Effects.field_76428_l)) {
                    player.func_195063_d(Effects.field_76428_l);
                    player.field_70752_e = true;
                }
                damage = player.func_110143_aJ() - 1.0f;
            }
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayerEntity)player);
            event.setAmount(damage <= 0.0f ? 1.0f : damage);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K && event.getSource().func_76346_g() instanceof LivingEntity) {
            IGlobalCapabilities globalData;
            IPlayerCapabilities playerData;
            Party p;
            LivingEntity attacker = (LivingEntity)event.getSource().func_76346_g();
            LivingEntity target = event.getEntityLiving();
            if (attacker instanceof PlayerEntity && target instanceof PlayerEntity && (p = ModCapabilities.getWorld(attacker.field_70170_p).getPartyFromMember(attacker.func_110124_au())) != null && p.getMember(event.getEntityLiving().func_110124_au()) != null && !p.getFriendlyFire()) {
                event.setCanceled(true);
            }
            if (target instanceof PlayerEntity && (playerData = ModCapabilities.getPlayer((PlayerEntity)target)).getReflectTicks() > 0) {
                if (!playerData.getReflectActive()) {
                    playerData.setReflectActive(true);
                }
                event.setCanceled(true);
            }
            if ((globalData = ModCapabilities.getGlobal(target)) != null && event.getSource().func_76346_g() instanceof PlayerEntity) {
                PlayerEntity source = (PlayerEntity)event.getSource().func_76346_g();
                if (globalData.getStoppedTicks() > 0) {
                    float dmg = event.getAmount();
                    if (event.getSource().func_76346_g() instanceof PlayerEntity) {
                        ItemStack stack = Utils.getWeaponDamageStack(event.getSource(), source);
                        if (stack != null) {
                            if (stack.func_77973_b() instanceof KeybladeItem) {
                                dmg = DamageCalculation.getKBStrengthDamage((PlayerEntity)event.getSource().func_76346_g(), stack);
                            } else if (stack.func_77973_b() instanceof IOrgWeapon) {
                                dmg = DamageCalculation.getOrgStrengthDamage((PlayerEntity)event.getSource().func_76346_g(), stack);
                            }
                        }
                        if (dmg == 0.0f) {
                            dmg = event.getAmount();
                        }
                    }
                    globalData.addDamage(dmg);
                    event.setCanceled(true);
                }
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        IWorldCapabilities worldData = ModCapabilities.getWorld(event.getEntityLiving().field_70170_p);
        if (event.getEntityLiving() instanceof EnderDragonEntity) {
            LivingEntity entity = event.getEntityLiving();
            if (worldData.getHeartlessSpawnLevel() == 0 && ModConfigs.heartlessSpawningMode == SpawningMode.AFTER_DRAGON) {
                worldData.setHeartlessSpawnLevel(1);
            }
            for (PlayerEntity p : entity.field_70170_p.func_217369_A()) {
                entity.field_70170_p.func_217376_c((Entity)new ItemEntity(entity.field_70170_p, p.func_226277_ct_(), p.func_226278_cu_(), p.func_226281_cx_(), new ItemStack((IItemProvider)ModItems.proofOfHeart.get(), 1)));
            }
        }
        if (!event.getEntity().field_70170_p.field_72995_K) {
            IPlayerCapabilities playerData;
            if (event.getSource().func_76364_f() instanceof PlayerEntity || event.getSource().func_76346_g() instanceof PlayerEntity) {
                IKHMob heartless;
                PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
                playerData = ModCapabilities.getPlayer(player);
                if (player.func_184614_ca().func_77973_b() instanceof IOrgWeapon || player.func_184614_ca().func_77973_b() instanceof KeybladeItem) {
                    IOrgWeapon weapon;
                    int multiplier = 1;
                    if (player.func_184614_ca().func_77973_b() instanceof IOrgWeapon && (weapon = (IOrgWeapon)player.func_184614_ca().func_77973_b()).getMember() == playerData.getAlignment()) {
                        multiplier = 2;
                    }
                    if (event.getEntity() instanceof IKHMob) {
                        IKHMob mob = (IKHMob)event.getEntity();
                        if (mob.getMobType() == EntityHelper.MobType.HEARTLESS_EMBLEM) {
                            playerData.addHearts((int)((double)(20 * multiplier) * ModConfigs.heartMultiplier));
                        }
                    } else if (event.getEntity() instanceof EnderDragonEntity || event.getEntity() instanceof WitherEntity) {
                        playerData.addHearts((int)((double)(1000 * multiplier) * ModConfigs.heartMultiplier));
                    } else if (event.getEntity() instanceof VillagerEntity) {
                        playerData.addHearts((int)((double)(5 * multiplier) * ModConfigs.heartMultiplier));
                    } else if (event.getEntity() instanceof MonsterEntity) {
                        playerData.addHearts((int)((double)(2 * multiplier) * ModConfigs.heartMultiplier));
                    } else {
                        playerData.addHearts((int)((double)(1 * multiplier) * ModConfigs.heartMultiplier));
                    }
                }
                if (event.getEntityLiving() instanceof IKHMob && (heartless = (IKHMob)event.getEntityLiving()).getMobType() == EntityHelper.MobType.HEARTLESS_EMBLEM && Utils.getWeaponDamageStack(event.getSource(), player) != null && Utils.getWeaponDamageStack(event.getSource(), player).func_77973_b() instanceof KeybladeItem) {
                    HeartEntity heart = new HeartEntity(event.getEntityLiving().field_70170_p);
                    heart.func_70107_b(event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_() + 1.0, event.getEntityLiving().func_226281_cx_());
                    event.getEntityLiving().field_70170_p.func_217376_c((Entity)heart);
                }
                if (event.getEntity().getClassification(false) == EntityClassification.MONSTER) {
                    int num;
                    if (!playerData.isAbilityEquipped("kingdomkeys:ability_zero_exp")) {
                        LivingEntity mob = (LivingEntity)event.getEntity();
                        double value = mob.func_110148_a(Attributes.field_233818_a_).func_111126_e() / 2.0;
                        double exp = Utils.randomWithRange(value * 0.8, value * 1.8);
                        playerData.addExperience(player, (int)((double)((int)exp) * ModConfigs.xpMultiplier), true);
                        if (event.getEntity() instanceof WitherEntity) {
                            playerData.addExperience(player, 1500, true);
                        }
                    }
                    LivingEntity entity = event.getEntityLiving();
                    double x = entity.func_226277_ct_();
                    double y = entity.func_226278_cu_();
                    double z = entity.func_226281_cx_();
                    if (entity.field_70170_p.field_73012_v.nextInt(100) <= ModConfigs.munnyDropProbability) {
                        entity.field_70170_p.func_217376_c((Entity)new MunnyEntity(event.getEntity().field_70170_p, x, y, z, Utils.randomWithRange(5, 15)));
                    }
                    if (entity.field_70170_p.field_73012_v.nextInt(100) <= ModConfigs.hpDropProbability) {
                        entity.field_70170_p.func_217376_c((Entity)new HPOrbEntity(event.getEntity().field_70170_p, x, y, z, (int)Utils.randomWithRange(entity.func_110138_aP() / 10.0f, entity.func_110138_aP() / 5.0f)));
                    }
                    if (entity.field_70170_p.field_73012_v.nextInt(100) <= ModConfigs.mpDropProbability) {
                        entity.field_70170_p.func_217376_c((Entity)new MPOrbEntity(event.getEntity().field_70170_p, x, y, z, (int)Utils.randomWithRange(entity.func_110138_aP() / 10.0f, entity.func_110138_aP() / 5.0f)));
                    }
                    if (entity.field_70170_p.field_73012_v.nextInt(100) <= ModConfigs.driveDropProbability) {
                        entity.field_70170_p.func_217376_c((Entity)new DriveOrbEntity(event.getEntity().field_70170_p, x, y, z, (int)((double)Utils.randomWithRange(entity.func_110138_aP() * 0.1f, entity.func_110138_aP() * 0.25f) * ModConfigs.drivePointsMultiplier)));
                    }
                    if (entity.field_70170_p.field_73012_v.nextInt(100) <= ModConfigs.focusDropProbability) {
                        entity.field_70170_p.func_217376_c((Entity)new FocusOrbEntity(event.getEntity().field_70170_p, x, y, z, (int)((double)Utils.randomWithRange(entity.func_110138_aP() * 0.1f, entity.func_110138_aP() * 0.25f) * ModConfigs.focusPointsMultiplier)));
                    }
                    if ((num = Utils.randomWithRange(0, 99)) < ModConfigs.recipeDropChance) {
                        ItemEntity ie = new ItemEntity(player.field_70170_p, x, y, z, new ItemStack((IItemProvider)ModItems.recipe.get()));
                        player.field_70170_p.func_217376_c((Entity)ie);
                    }
                    PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayerEntity)player);
                }
            }
            if (event.getEntity() instanceof MoogleEntity && event.getSource() == DamageSource.field_82728_o) {
                ItemEntity ie = new ItemEntity(event.getEntity().field_70170_p, event.getEntity().func_226277_ct_(), event.getEntity().func_226278_cu_(), event.getEntity().func_226281_cx_(), new ItemStack((IItemProvider)ModBlocks.moogleProjector.get()));
                event.getEntity().field_70170_p.func_217376_c((Entity)ie);
            }
            if (event.getSource().func_76346_g() instanceof IKHMob && ModConfigs.playerSpawnHeartless) {
                IKHMob killerMob = (IKHMob)event.getSource().func_76346_g();
                if (!(event.getSource().func_76346_g().func_145818_k_() || killerMob.getMobType() != EntityHelper.MobType.HEARTLESS_EMBLEM && killerMob.getMobType() != EntityHelper.MobType.HEARTLESS_PUREBLOOD)) {
                    if (event.getEntityLiving() instanceof PlayerEntity) {
                        playerData = ModCapabilities.getPlayer((PlayerEntity)event.getEntityLiving());
                        String[] heartless = ModConfigs.playerSpawnHeartlessData.get(0).split(",");
                        String[] nobody = ModConfigs.playerSpawnHeartlessData.get(1).split(",");
                        DuskEntity newDusk = new DuskEntity((EntityType<? extends MonsterEntity>)((EntityType)ModEntities.TYPE_DUSK.get()), event.getSource().func_76346_g().field_70170_p);
                        newDusk.func_70107_b(event.getEntityLiving().func_233580_cy_().func_177958_n(), event.getEntityLiving().func_233580_cy_().func_177956_o(), event.getEntityLiving().func_233580_cy_().func_177952_p());
                        newDusk.func_200203_b((ITextComponent)new TranslationTextComponent(event.getEntityLiving().func_145748_c_().getString() + "'s Nobody"));
                        newDusk.func_110148_a(Attributes.field_233818_a_).func_111128_a(Math.max((double)event.getEntityLiving().func_110138_aP() * Double.parseDouble(nobody[1]) / 100.0, (double)newDusk.func_110138_aP()));
                        newDusk.func_70691_i(newDusk.func_110138_aP());
                        newDusk.func_110148_a(Attributes.field_233823_f_).func_111128_a(Math.max((double)playerData.getStrength() * Double.parseDouble(nobody[2]) / 100.0, newDusk.func_110148_a(Attributes.field_233823_f_).func_111125_b()));
                        event.getSource().func_76346_g().field_70170_p.func_217376_c((Entity)newDusk);
                        ShadowEntity newShadow = new ShadowEntity((EntityType<? extends MonsterEntity>)((EntityType)ModEntities.TYPE_SHADOW.get()), event.getSource().func_76346_g().field_70170_p);
                        newShadow.func_70107_b(event.getEntityLiving().func_233580_cy_().func_177958_n(), event.getEntityLiving().func_233580_cy_().func_177956_o(), event.getEntityLiving().func_233580_cy_().func_177952_p());
                        newShadow.func_200203_b((ITextComponent)new TranslationTextComponent(event.getEntityLiving().func_145748_c_().getString() + "'s Heartless"));
                        newShadow.func_110148_a(Attributes.field_233818_a_).func_111128_a(Math.max((double)event.getEntityLiving().func_110138_aP() * Double.parseDouble(heartless[1]) / 100.0, (double)newShadow.func_110138_aP()));
                        newShadow.func_70691_i(newShadow.func_110138_aP());
                        newShadow.func_110148_a(Attributes.field_233823_f_).func_111128_a(Math.max((double)playerData.getStrength() * Double.parseDouble(heartless[2]) / 100.0, newShadow.func_110148_a(Attributes.field_233823_f_).func_111125_b()));
                        event.getSource().func_76346_g().field_70170_p.func_217376_c((Entity)newShadow);
                        HeartEntity heart = new HeartEntity(event.getEntityLiving().field_70170_p);
                        heart.func_70107_b(event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_() + 1.0, event.getEntityLiving().func_226281_cx_());
                        event.getEntityLiving().field_70170_p.func_217376_c((Entity)heart);
                    } else if (event.getEntityLiving() instanceof VillagerEntity) {
                        ShadowEntity newShadow = new ShadowEntity((EntityType<? extends MonsterEntity>)((EntityType)ModEntities.TYPE_SHADOW.get()), event.getSource().func_76346_g().field_70170_p);
                        newShadow.func_70107_b(event.getEntityLiving().func_233580_cy_().func_177958_n(), event.getEntityLiving().func_233580_cy_().func_177956_o(), event.getEntityLiving().func_233580_cy_().func_177952_p());
                        event.getSource().func_76346_g().field_70170_p.func_217376_c((Entity)newShadow);
                        HeartEntity heart = new HeartEntity(event.getEntityLiving().field_70170_p);
                        heart.func_70107_b(event.getEntityLiving().func_226277_ct_(), event.getEntityLiving().func_226278_cu_() + 1.0, event.getEntityLiving().func_226281_cx_());
                        event.getEntityLiving().field_70170_p.func_217376_c((Entity)heart);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onFall(LivingFallEvent event) {
        PlayerEntity player;
        IPlayerCapabilities playerData;
        if (event.getEntityLiving() instanceof PlayerEntity && (playerData = ModCapabilities.getPlayer(player = (PlayerEntity)event.getEntityLiving())) != null && playerData.getActiveDriveForm() != null) {
            if (!playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                event.setDistance(0.0f);
            } else if (playerData.isAbilityEquipped("kingdomkeys:ability_high_jump") || playerData.isAbilityEquipped("kingdomkeys:ability_aerial_dodge") || playerData.isAbilityEquipped("kingdomkeys:ability_glide")) {
                event.setDistance(0.0f);
            }
        }
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (!event.getWorld().func_201670_d() && !event.getPlayer().func_184812_l_()) {
            if (event.getState().func_177230_c() == ModBlocks.prizeBlox.get()) {
                event.getWorld().func_217376_c((Entity)new MunnyEntity((World)event.getWorld(), event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p(), Utils.randomWithRange(50, 200)));
            } else if (event.getState().func_177230_c() == ModBlocks.rarePrizeBlox.get()) {
                event.getWorld().func_217376_c((Entity)new MunnyEntity((World)event.getWorld(), event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p(), Utils.randomWithRange(300, 500)));
            }
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        PlayerEntity oPlayer = event.getOriginal();
        PlayerEntity nPlayer = event.getPlayer();
        IPlayerCapabilities oldPlayerData = ModCapabilities.getPlayer(oPlayer);
        IPlayerCapabilities newPlayerData = ModCapabilities.getPlayer(nPlayer);
        newPlayerData.setLevel(oldPlayerData.getLevel());
        newPlayerData.setExperience(oldPlayerData.getExperience());
        newPlayerData.setExperienceGiven(oldPlayerData.getExperienceGiven());
        newPlayerData.setStrength(oldPlayerData.getStrength());
        newPlayerData.setMagic(oldPlayerData.getMagic());
        newPlayerData.setDefense(oldPlayerData.getDefense());
        newPlayerData.setMaxHP(oldPlayerData.getMaxHP());
        newPlayerData.setMP(oldPlayerData.getMP());
        newPlayerData.setMaxMP(oldPlayerData.getMaxMP());
        newPlayerData.setDP(oldPlayerData.getDP());
        newPlayerData.setFP(oldPlayerData.getFP());
        newPlayerData.setMaxDP(oldPlayerData.getMaxDP());
        newPlayerData.setMaxAP(oldPlayerData.getMaxAP());
        newPlayerData.setFocus(oldPlayerData.getFocus());
        newPlayerData.setMaxFocus(oldPlayerData.getMaxFocus());
        newPlayerData.setMunny(oldPlayerData.getMunny());
        newPlayerData.setMagicsMap(oldPlayerData.getMagicsMap());
        newPlayerData.setAbilityMap(oldPlayerData.getAbilityMap());
        newPlayerData.setDriveFormMap(oldPlayerData.getDriveFormMap());
        newPlayerData.setAntiPoints(oldPlayerData.getAntiPoints());
        newPlayerData.setActiveDriveForm(oldPlayerData.getActiveDriveForm());
        newPlayerData.setPartiesInvited(oldPlayerData.getPartiesInvited());
        newPlayerData.setKnownRecipeList(oldPlayerData.getKnownRecipeList());
        newPlayerData.setMaterialMap(oldPlayerData.getMaterialMap());
        newPlayerData.equipAllKeychains(oldPlayerData.getEquippedKeychains(), true);
        newPlayerData.setSoAState(oldPlayerData.getSoAState());
        newPlayerData.setReturnDimension(oldPlayerData.getReturnDimension());
        newPlayerData.setReturnLocation(oldPlayerData.getReturnLocation());
        newPlayerData.setChoice(oldPlayerData.getChosen());
        newPlayerData.setChoicePedestal(oldPlayerData.getChoicePedestal());
        newPlayerData.setSacrifice(oldPlayerData.getSacrificed());
        newPlayerData.setSacrificePedestal(oldPlayerData.getSacrificePedestal());
        newPlayerData.setHearts(oldPlayerData.getHearts());
        newPlayerData.setAlignment(oldPlayerData.getAlignment());
        newPlayerData.equipWeapon(oldPlayerData.getEquippedWeapon());
        newPlayerData.setWeaponsUnlocked(oldPlayerData.getWeaponsUnlocked());
        newPlayerData.setLimitCooldownTicks(oldPlayerData.getLimitCooldownTicks());
        newPlayerData.setEquippedShotlock(oldPlayerData.getEquippedShotlock());
        newPlayerData.setShotlockList(oldPlayerData.getShotlockList());
        newPlayerData.equipAllItems(oldPlayerData.getEquippedItems(), true);
        nPlayer.func_70606_j((float)oldPlayerData.getMaxHP());
        nPlayer.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)oldPlayerData.getMaxHP());
        PacketHandler.sendTo(new SCSyncWorldCapability(ModCapabilities.getWorld(nPlayer.field_70170_p)), (ServerPlayerEntity)nPlayer);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        PlayerEntity nPlayer = event.getPlayer();
        IWorldCapabilities newWorldData = ModCapabilities.getWorld(nPlayer.field_70170_p);
        nPlayer.func_70606_j((float)ModCapabilities.getPlayer(nPlayer).getMaxHP());
        if (!nPlayer.field_70170_p.field_72995_K) {
            PacketHandler.sendTo(new SCSyncWorldCapability(newWorldData), (ServerPlayerEntity)nPlayer);
        }
    }

    @SubscribeEvent
    public void onDimensionChanged(PlayerEvent.PlayerChangedDimensionEvent e) {
        PlayerEntity player = e.getPlayer();
        if (!player.field_70170_p.field_72995_K) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayerEntity)player);
            PacketHandler.sendTo(new SCSyncWorldCapability(ModCapabilities.getWorld((World)e.getPlayer().func_184102_h().func_71218_a(e.getTo()))), (ServerPlayerEntity)player);
        }
    }

    @SubscribeEvent
    public void playerStartedTracking(PlayerEvent.StartTracking e) {
        if (e.getTarget() instanceof PlayerEntity) {
            PlayerEntity targetPlayer = (PlayerEntity)e.getTarget();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(targetPlayer);
            PacketHandler.syncToAllAround(targetPlayer, playerData);
        }
    }
}

