/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.CommandMenuGui;
import online.kingdomkeys.kingdomkeys.client.gui.GuiHelper;
import online.kingdomkeys.kingdomkeys.client.gui.menu.NoChoiceMenuPopup;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.handler.EntityEvents;
import online.kingdomkeys.kingdomkeys.handler.KeyboardHelper;
import online.kingdomkeys.kingdomkeys.item.KKPotionItem;
import online.kingdomkeys.kingdomkeys.lib.Constants;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.lib.PortalData;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import online.kingdomkeys.kingdomkeys.limit.Limit;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSSetDriveFormPacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSSpawnOrgPortalPacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSSummonKeyblade;
import online.kingdomkeys.kingdomkeys.network.cts.CSSyncAllClientDataPacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSUseItemPacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSUseLimitPacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSUseMagicPacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSUseReactionCommandPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;
import online.kingdomkeys.kingdomkeys.world.dimension.ModDimensions;

public class InputHandler {
    List<UUID> portalCommands;
    Map<String, int[]> driveFormsMap;
    Map<String, Integer> magicsMap;
    List<Party.Member> targetsList;
    List<Limit> limitsList;
    Map<Integer, ItemStack> itemsList;
    List<String> reactionList = new ArrayList<String>();
    public static LivingEntity lockOn = null;
    public static int qrCooldown = 40;

    public boolean antiFormCheck() {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
        ClientWorld world = mc.field_71441_e;
        double random = Math.random();
        int ap = playerData.getAntiPoints();
        int prob = 0;
        if (ap > 0 && ap <= 4) {
            prob = 0;
        } else if (ap > 4 && ap <= 9) {
            prob = 10;
        } else if (ap >= 10) {
            prob = 25;
        }
        if (random * 100.0 < (double)prob) {
            PacketHandler.sendToServer(new CSSetDriveFormPacket("kingdomkeys:form_anti"));
            player.field_70170_p.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.antidrive.get(), SoundCategory.MASTER, 1.0f, 1.0f);
            CommandMenuGui.selected = 4;
            CommandMenuGui.submenu = 0;
            world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.menu_select.get(), SoundCategory.MASTER, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    public void commandUp() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71441_e.func_184133_a((PlayerEntity)mc.field_71439_g, mc.field_71439_g.func_233580_cy_(), (SoundEvent)ModSounds.menu_move.get(), SoundCategory.MASTER, 1.0f, 1.0f);
        this.loadLists();
        if (CommandMenuGui.submenu == 0) {
            CommandMenuGui.selected = CommandMenuGui.selected == 4 ? 1 : ++CommandMenuGui.selected;
        } else if (CommandMenuGui.submenu == 1) {
            if (CommandMenuGui.magicSelected > 0) {
                --CommandMenuGui.magicSelected;
                CommandMenuGui.submenu = 1;
            } else if (CommandMenuGui.magicSelected <= 1) {
                CommandMenuGui.magicSelected = this.magicsMap.size() - 1;
            }
        } else if (CommandMenuGui.submenu == 2) {
            if (CommandMenuGui.itemSelected > 0) {
                --CommandMenuGui.itemSelected;
                CommandMenuGui.submenu = 2;
            } else if (CommandMenuGui.itemSelected <= 1) {
                CommandMenuGui.itemSelected = this.itemsList.size() - 1;
            }
        } else if (CommandMenuGui.submenu == 3) {
            if (CommandMenuGui.driveSelected > 0) {
                --CommandMenuGui.driveSelected;
                CommandMenuGui.submenu = 3;
            } else if (CommandMenuGui.driveSelected <= 1) {
                CommandMenuGui.driveSelected = this.driveFormsMap.size() - 1;
            }
        } else if (CommandMenuGui.submenu == 4) {
            if (CommandMenuGui.portalSelected > 0) {
                --CommandMenuGui.portalSelected;
                CommandMenuGui.submenu = 4;
            } else if (CommandMenuGui.portalSelected <= 1) {
                CommandMenuGui.portalSelected = this.portalCommands.size() - 1;
            }
        } else if (CommandMenuGui.submenu == 6) {
            if (CommandMenuGui.targetSelected > 0) {
                --CommandMenuGui.targetSelected;
                CommandMenuGui.submenu = 6;
            } else if (CommandMenuGui.attackSelected <= 1) {
                CommandMenuGui.targetSelected = this.targetsList.size() - 1;
            }
        } else if (CommandMenuGui.submenu == 7) {
            if (CommandMenuGui.limitSelected > 0) {
                --CommandMenuGui.limitSelected;
                CommandMenuGui.submenu = 7;
            } else if (CommandMenuGui.attackSelected <= 1) {
                CommandMenuGui.limitSelected = this.limitsList.size() - 1;
            }
        }
    }

    public void commandDown() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71441_e.func_184133_a((PlayerEntity)mc.field_71439_g, mc.field_71439_g.func_233580_cy_(), (SoundEvent)ModSounds.menu_move.get(), SoundCategory.MASTER, 1.0f, 1.0f);
        this.loadLists();
        if (CommandMenuGui.submenu == 0) {
            CommandMenuGui.selected = CommandMenuGui.selected == 1 ? 4 : --CommandMenuGui.selected;
        } else if (CommandMenuGui.submenu == 1) {
            if (CommandMenuGui.magicSelected < this.magicsMap.size() - 1) {
                ++CommandMenuGui.magicSelected;
                CommandMenuGui.submenu = 1;
            } else if (CommandMenuGui.magicSelected >= this.magicsMap.size() - 1) {
                CommandMenuGui.magicSelected = 0;
            }
        } else if (CommandMenuGui.submenu == 2) {
            if (CommandMenuGui.itemSelected < this.itemsList.size() - 1) {
                ++CommandMenuGui.itemSelected;
                CommandMenuGui.submenu = 2;
            } else if (CommandMenuGui.itemSelected >= this.itemsList.size() - 1) {
                CommandMenuGui.itemSelected = 0;
            }
        } else if (CommandMenuGui.submenu == 3) {
            if (CommandMenuGui.driveSelected < this.driveFormsMap.size() - 1) {
                ++CommandMenuGui.driveSelected;
                CommandMenuGui.submenu = 3;
            } else if (CommandMenuGui.driveSelected >= this.driveFormsMap.size() - 1) {
                CommandMenuGui.driveSelected = 0;
            }
        } else if (CommandMenuGui.submenu == 4) {
            if (CommandMenuGui.portalSelected < this.portalCommands.size() - 1) {
                ++CommandMenuGui.portalSelected;
                CommandMenuGui.submenu = 4;
            } else if (CommandMenuGui.portalSelected >= this.portalCommands.size() - 1) {
                CommandMenuGui.portalSelected = 0;
            }
        } else if (CommandMenuGui.submenu == 6) {
            if (CommandMenuGui.targetSelected < this.targetsList.size() - 1) {
                ++CommandMenuGui.targetSelected;
                CommandMenuGui.submenu = 6;
            } else if (CommandMenuGui.targetSelected >= this.targetsList.size() - 1) {
                CommandMenuGui.targetSelected = 0;
            }
        } else if (CommandMenuGui.submenu == 7) {
            if (CommandMenuGui.limitSelected < this.limitsList.size() - 1) {
                ++CommandMenuGui.limitSelected;
                CommandMenuGui.submenu = 7;
            } else if (CommandMenuGui.limitSelected >= this.limitsList.size() - 1) {
                CommandMenuGui.limitSelected = 0;
            }
        }
    }

    public void commandEnter() {
        Party.Member member;
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        ClientWorld world = mc.field_71441_e;
        this.loadLists();
        IWorldCapabilities worldData = ModCapabilities.getWorld((World)world);
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
        if (playerData == null || worldData == null) {
            return;
        }
        switch (CommandMenuGui.selected) {
            case 4: {
                if (playerData.getAlignment() == Utils.OrgMember.NONE || CommandMenuGui.submenu != 0) break;
                if (!this.portalCommands.isEmpty() && !playerData.getRecharge()) {
                    CommandMenuGui.submenu = 4;
                    CommandMenuGui.portalSelected = 0;
                    world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                } else {
                    CommandMenuGui.selected = 4;
                    world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.error.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                }
                return;
            }
            case 3: {
                if (CommandMenuGui.submenu != 0) break;
                if (!(playerData.getRecharge() || playerData.getMagicCooldownTicks() > 0 || !(playerData.getMaxMP() > 0.0) || this.magicsMap.isEmpty() || playerData.getActiveDriveForm().equals("kingdomkeys:form_valor") || playerData.getActiveDriveForm().equals("kingdomkeys:form_anti"))) {
                    CommandMenuGui.magicSelected = 0;
                    CommandMenuGui.submenu = 1;
                    mc.field_71441_e.func_184133_a((PlayerEntity)mc.field_71439_g, mc.field_71439_g.func_233580_cy_(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                    return;
                }
                CommandMenuGui.selected = 4;
                world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.error.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                break;
            }
            case 2: {
                if (CommandMenuGui.submenu != 0) break;
                if (!this.itemsList.isEmpty()) {
                    CommandMenuGui.submenu = 2;
                    CommandMenuGui.itemSelected = 0;
                    world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.menu_select.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                } else {
                    CommandMenuGui.selected = 4;
                    world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.error.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                }
                return;
            }
            case 1: {
                if (CommandMenuGui.submenu != 0) break;
                if (playerData.getAlignment() == Utils.OrgMember.NONE) {
                    if (playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                        if (playerData.getActiveDriveForm().equals("kingdomkeys:form_anti") || this.driveFormsMap.isEmpty()) break;
                        CommandMenuGui.driveSelected = 0;
                        CommandMenuGui.submenu = 3;
                        mc.field_71441_e.func_184133_a((PlayerEntity)mc.field_71439_g, mc.field_71439_g.func_233580_cy_(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                        return;
                    }
                    if (playerData.getActiveDriveForm().equals("kingdomkeys:form_anti") && EntityEvents.isHostiles) {
                        player.field_70170_p.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.error.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                        break;
                    }
                    PacketHandler.sendToServer(new CSSetDriveFormPacket(DriveForm.NONE.toString()));
                    player.field_70170_p.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.unsummon.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                    break;
                }
                if (this.limitsList.isEmpty() || playerData.getLimitCooldownTicks() > 0) break;
                CommandMenuGui.limitSelected = 0;
                CommandMenuGui.submenu = 7;
                mc.field_71441_e.func_184133_a((PlayerEntity)mc.field_71439_g, mc.field_71439_g.func_233580_cy_(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                return;
            }
        }
        if (CommandMenuGui.selected != 4 || CommandMenuGui.submenu == 5) {
            // empty if block
        }
        if (CommandMenuGui.selected == 4 && CommandMenuGui.submenu == 4 && !this.portalCommands.isEmpty() && !ModCapabilities.getPlayer((PlayerEntity)player).getRecharge()) {
            UUID portalUUID = this.portalCommands.get((byte)CommandMenuGui.portalSelected);
            PortalData coords = worldData.getPortalFromUUID(portalUUID);
            if (!coords.getPos().equals((Object)new BlockPos(0, 0, 0))) {
                this.summonPortal((PlayerEntity)player, coords);
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent(TextFormatting.RED + "You don't have any portal destination"), Util.field_240973_b_);
            }
            CommandMenuGui.selected = 4;
            CommandMenuGui.submenu = 0;
            world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
        }
        if (CommandMenuGui.selected == 1 && CommandMenuGui.submenu == 7) {
            if (this.limitsList.isEmpty()) {
                world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.error.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                CommandMenuGui.selected = 4;
                CommandMenuGui.submenu = 0;
            } else if (playerData.getDP() < (double)this.limitsList.get(CommandMenuGui.limitSelected).getCost()) {
                world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.error.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                CommandMenuGui.selected = 4;
                CommandMenuGui.submenu = 0;
            } else {
                if (lockOn != null) {
                    PacketHandler.sendToServer(new CSUseLimitPacket(lockOn, CommandMenuGui.limitSelected));
                } else {
                    PacketHandler.sendToServer(new CSUseLimitPacket(CommandMenuGui.limitSelected));
                }
                CommandMenuGui.selected = 4;
                CommandMenuGui.submenu = 0;
                world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
            }
        }
        if (CommandMenuGui.selected == 2 && CommandMenuGui.submenu == 2 && !this.itemsList.isEmpty() && !this.itemsList.isEmpty()) {
            int slot = -1;
            int i = 0;
            for (Map.Entry<Integer, ItemStack> entry : this.itemsList.entrySet()) {
                if (CommandMenuGui.itemSelected == i) {
                    slot = entry.getKey();
                }
                ++i;
            }
            if (this.itemsList.get(slot) != null && this.itemsList.get(slot).func_77973_b() instanceof KKPotionItem) {
                KKPotionItem potion = (KKPotionItem)this.itemsList.get(slot).func_77973_b();
                Party party = worldData.getPartyFromMember(player.func_110124_au());
                if (!potion.isGlobal() && party != null) {
                    CommandMenuGui.targetSelected = party.getMemberIndex(player.func_110124_au());
                    CommandMenuGui.submenu = 6;
                    world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                    return;
                }
                PacketHandler.sendToServer(new CSUseItemPacket(slot));
                CommandMenuGui.selected = 4;
                CommandMenuGui.submenu = 0;
                world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.menu_select.get(), SoundCategory.MASTER, 1.0f, 1.0f);
            } else {
                world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.error.get(), SoundCategory.MASTER, 1.0f, 1.0f);
            }
        }
        if (CommandMenuGui.selected == 1 && CommandMenuGui.submenu == 3 && !this.driveFormsMap.isEmpty() && playerData.getAlignment() == Utils.OrgMember.NONE) {
            String formName = (String)this.driveFormsMap.keySet().toArray()[CommandMenuGui.driveSelected];
            DriveForm driveForm = (DriveForm)ModDriveForms.registry.getValue(new ResourceLocation(formName));
            if (playerData.getDP() >= (double)driveForm.getDriveCost()) {
                if (formName.equals("kingdomkeys:form_final")) {
                    PacketHandler.sendToServer(new CSSetDriveFormPacket(formName));
                    player.field_70170_p.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.drive.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                } else if (!this.antiFormCheck()) {
                    PacketHandler.sendToServer(new CSSetDriveFormPacket(formName));
                    player.field_70170_p.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.drive.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                }
                CommandMenuGui.selected = 4;
                CommandMenuGui.submenu = 0;
                world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
            } else {
                CommandMenuGui.submenu = 0;
                CommandMenuGui.selected = 4;
                world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.error.get(), SoundCategory.MASTER, 1.0f, 1.0f);
            }
        }
        if (CommandMenuGui.selected == 3 && CommandMenuGui.submenu == 6 && !this.targetsList.isEmpty()) {
            member = this.targetsList.get(CommandMenuGui.targetSelected);
            if (world.func_217371_b(member.getUUID()) != null && player.func_70032_d((Entity)world.func_217371_b(member.getUUID())) < (float)ModConfigs.partyRangeLimit) {
                String magicName = (String)this.magicsMap.keySet().toArray()[CommandMenuGui.magicSelected];
                int level = playerData.getMagicLevel(magicName);
                PacketHandler.sendToServer(new CSUseMagicPacket(magicName, member.getUsername(), level));
                CommandMenuGui.selected = 4;
                CommandMenuGui.submenu = 0;
                world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
            } else {
                world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.error.get(), SoundCategory.MASTER, 1.0f, 1.0f);
            }
        }
        if (CommandMenuGui.selected == 2 && CommandMenuGui.submenu == 6 && !this.targetsList.isEmpty()) {
            member = this.targetsList.get(CommandMenuGui.targetSelected);
            if (world.func_217371_b(member.getUUID()) != null && player.func_70032_d((Entity)world.func_217371_b(member.getUUID())) < (float)ModConfigs.partyRangeLimit) {
                int slot = -1;
                int i = 0;
                for (Map.Entry<Integer, ItemStack> entry : this.itemsList.entrySet()) {
                    if (CommandMenuGui.itemSelected == i) {
                        slot = entry.getKey();
                    }
                    ++i;
                }
                if (this.itemsList.get(slot) != null && this.itemsList.get(slot).func_77973_b() instanceof KKPotionItem) {
                    KKPotionItem potion = (KKPotionItem)this.itemsList.get(slot).func_77973_b();
                    PacketHandler.sendToServer(new CSUseItemPacket(slot, member.getUsername()));
                }
                CommandMenuGui.selected = 4;
                CommandMenuGui.submenu = 0;
                world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
            } else {
                world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.error.get(), SoundCategory.MASTER, 1.0f, 1.0f);
            }
        }
        if (CommandMenuGui.selected == 3 && CommandMenuGui.submenu == 1 && !this.magicsMap.isEmpty()) {
            String magic = (String)this.magicsMap.keySet().toArray()[CommandMenuGui.magicSelected];
            int cost = ((Magic)ModMagic.registry.getValue(new ResourceLocation(magic))).getCost();
            if (playerData.getMaxMP() == 0.0 || playerData.getRecharge() || (double)cost > playerData.getMaxMP() && cost < 300) {
                world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.error.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                CommandMenuGui.selected = 4;
                CommandMenuGui.submenu = 0;
            } else {
                if (worldData.getPartyFromMember(player.func_110124_au()) != null && ((Magic)ModMagic.registry.getValue(new ResourceLocation(magic))).getHasToSelect()) {
                    Party party = worldData.getPartyFromMember(player.func_110124_au());
                    CommandMenuGui.targetSelected = party.getMemberIndex(player.func_110124_au());
                    CommandMenuGui.submenu = 6;
                    world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                    return;
                }
                String magicName = (String)this.magicsMap.keySet().toArray()[CommandMenuGui.magicSelected];
                int level = playerData.getMagicLevel(magicName);
                PacketHandler.sendToServer(new CSUseMagicPacket(magicName, level));
                CommandMenuGui.selected = 4;
                CommandMenuGui.submenu = 0;
                world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.menu_select.get(), SoundCategory.MASTER, 1.0f, 1.0f);
            }
        }
    }

    private void summonPortal(PlayerEntity player, PortalData coords) {
        BlockPos destination = coords.getPos();
        if (player.func_225608_bj_()) {
            PacketHandler.sendToServer(new CSSpawnOrgPortalPacket(player.func_233580_cy_(), destination, coords.getDimID()));
        } else {
            RayTraceResult rtr = InputHandler.getMouseOverExtended(100.0f);
            if (rtr != null) {
                EntityRayTraceResult ertr;
                double distanceSq;
                double reachSq;
                if (rtr instanceof BlockRayTraceResult) {
                    double reachSq2 = 10000.0;
                    BlockRayTraceResult brtr = (BlockRayTraceResult)rtr;
                    double distanceSq2 = player.func_70092_e((double)brtr.func_216350_a().func_177958_n(), (double)brtr.func_216350_a().func_177956_o(), (double)brtr.func_216350_a().func_177952_p());
                    if (reachSq2 >= distanceSq2) {
                        PacketHandler.sendToServer(new CSSpawnOrgPortalPacket(brtr.func_216350_a().func_177984_a(), destination, coords.getDimID()));
                    }
                } else if (rtr instanceof EntityRayTraceResult && (reachSq = 10000.0) >= (distanceSq = player.func_70092_e((ertr = (EntityRayTraceResult)rtr).func_216348_a().func_226277_ct_(), ertr.func_216348_a().func_226278_cu_(), ertr.func_216348_a().func_226281_cx_()))) {
                    PacketHandler.sendToServer(new CSSpawnOrgPortalPacket(ertr.func_216348_a().func_233580_cy_(), destination, coords.getDimID()));
                }
            }
        }
    }

    public void commandBack() {
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71441_e.func_184133_a((PlayerEntity)mc.field_71439_g, mc.field_71439_g.func_233580_cy_(), (SoundEvent)ModSounds.menu_back.get(), SoundCategory.MASTER, 1.0f, 1.0f);
        ClientPlayerEntity player = mc.field_71439_g;
        ClientWorld world = mc.field_71441_e;
        if (CommandMenuGui.submenu == 0) {
            CommandMenuGui.submenu = 0;
        } else if (CommandMenuGui.submenu == 1) {
            CommandMenuGui.submenu = 0;
            world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.menu_back.get(), SoundCategory.MASTER, 1.0f, 1.0f);
        } else if (CommandMenuGui.submenu == 2) {
            CommandMenuGui.submenu = 0;
            world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.menu_back.get(), SoundCategory.MASTER, 1.0f, 1.0f);
        } else if (CommandMenuGui.submenu == 3) {
            CommandMenuGui.submenu = 0;
            world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.menu_back.get(), SoundCategory.MASTER, 1.0f, 1.0f);
        } else if (CommandMenuGui.submenu == 4) {
            CommandMenuGui.submenu = 0;
            world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.menu_back.get(), SoundCategory.MASTER, 1.0f, 1.0f);
        } else if (CommandMenuGui.submenu == 5) {
            CommandMenuGui.submenu = 0;
            world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.menu_back.get(), SoundCategory.MASTER, 1.0f, 1.0f);
        } else if (CommandMenuGui.submenu == 6) {
            CommandMenuGui.submenu = CommandMenuGui.selected == 3 ? 1 : 2;
            world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.menu_back.get(), SoundCategory.MASTER, 1.0f, 1.0f);
        } else if (CommandMenuGui.submenu == 7) {
            CommandMenuGui.submenu = 0;
            world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.menu_back.get(), SoundCategory.MASTER, 1.0f, 1.0f);
        }
        CommandMenuGui.driveSelected = 0;
    }

    @SubscribeEvent
    public void handleKeyInputEvent(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        ClientWorld world = mc.field_71441_e;
        Keybinds key = this.getPressedKey();
        if (key != null) {
            switch (key) {
                case OPENMENU: {
                    PacketHandler.sendToServer(new CSSyncAllClientDataPacket());
                    if (ModCapabilities.getPlayer((PlayerEntity)player).getSoAState() != SoAState.COMPLETE) {
                        if (player.field_70170_p.func_234923_W_() == ModDimensions.DIVE_TO_THE_HEART) break;
                        mc.func_147108_a((Screen)new NoChoiceMenuPopup());
                        break;
                    }
                    GuiHelper.openMenu();
                    break;
                }
                case SCROLL_UP: {
                    if (mc.field_71462_r != null) break;
                    this.commandUp();
                    break;
                }
                case SCROLL_DOWN: {
                    if (mc.field_71462_r != null) break;
                    this.commandDown();
                    break;
                }
                case ENTER: {
                    if (mc.field_71462_r != null) break;
                    this.commandEnter();
                    break;
                }
                case BACK: {
                    if (mc.field_71462_r != null) break;
                    this.commandBack();
                    break;
                }
                case SUMMON_KEYBLADE: {
                    if (ModCapabilities.getPlayer((PlayerEntity)player).getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                        PacketHandler.sendToServer(new CSSummonKeyblade());
                        break;
                    }
                    PacketHandler.sendToServer(new CSSummonKeyblade(new ResourceLocation(ModCapabilities.getPlayer((PlayerEntity)player).getActiveDriveForm())));
                    break;
                }
                case ACTION: {
                    this.commandAction();
                    break;
                }
                case LOCK_ON: {
                    if (lockOn == null) {
                        double distance;
                        EntityRayTraceResult ertr;
                        int reach = 35;
                        RayTraceResult rtr = InputHandler.getMouseOverExtended(reach);
                        if (rtr == null || !(rtr instanceof EntityRayTraceResult) || (ertr = (EntityRayTraceResult)rtr).func_216348_a() == null || !((double)reach >= (distance = (double)player.func_70032_d(ertr.func_216348_a()))) || !(ertr.func_216348_a() instanceof LivingEntity)) break;
                        lockOn = (LivingEntity)ertr.func_216348_a();
                        player.field_70170_p.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.lockon.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                        break;
                    }
                    lockOn = null;
                    break;
                }
                case REACTION_COMMAND: {
                    this.reactionCommand();
                }
            }
        }
    }

    private void commandAction() {
        Minecraft mc = Minecraft.func_71410_x();
        ClientPlayerEntity player = mc.field_71439_g;
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
        if (qrCooldown <= 0 && player.func_213322_ci().field_72450_a != 0.0 && player.func_213322_ci().field_72449_c != 0.0) {
            if (player.func_70051_ag()) {
                if (playerData.isAbilityEquipped("kingdomkeys:ability_quick_run") || playerData.getActiveDriveForm().equals("kingdomkeys:form_wisdom")) {
                    float yaw = player.field_70177_z;
                    float motionX = -MathHelper.func_76126_a((float)(yaw / 180.0f * (float)Math.PI));
                    float motionZ = MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI));
                    int wisdomLevel = playerData.getDriveFormLevel("kingdomkeys:form_wisdom");
                    double power = 0.0;
                    if (playerData.getActiveDriveForm().equals("kingdomkeys:form_wisdom")) {
                        power = Constants.WISDOM_QR[wisdomLevel];
                        if (!player.func_233570_aj_()) {
                            player.func_70024_g((double)motionX * power / 2.0, 0.0, (double)motionZ * power / 2.0);
                            qrCooldown = 20;
                        }
                    } else if (playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) && wisdomLevel > 2) {
                        power = Constants.WISDOM_QR[wisdomLevel - 2];
                    }
                    if (player.func_233570_aj_()) {
                        player.func_70024_g((double)motionX * power, 0.0, (double)motionZ * power);
                        qrCooldown = 20;
                    }
                }
            } else if (playerData.isAbilityEquipped("kingdomkeys:ability_dodge_roll") || playerData.getActiveDriveForm().equals("kingdomkeys:form_limit")) {
                int limitLevel = playerData.getDriveFormLevel("kingdomkeys:form_limit");
                double power = 0.0;
                if (playerData.getActiveDriveForm().equals("kingdomkeys:form_limit")) {
                    power = Constants.LIMIT_DR[limitLevel];
                } else if (playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) && limitLevel > 2) {
                    power = Constants.LIMIT_DR[limitLevel - 2];
                }
                if (player.func_233570_aj_()) {
                    player.func_70024_g(player.func_213322_ci().field_72450_a * power, 0.0, player.func_213322_ci().field_72449_c * power);
                    qrCooldown = 20;
                }
            }
        }
    }

    private Keybinds getPressedKey() {
        for (Keybinds key : Keybinds.values()) {
            if (!key.isPressed()) continue;
            return key;
        }
        return null;
    }

    @SubscribeEvent
    public void handleKeyInputEvent(InputEvent.RawMouseEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.field_71441_e != null) {
            if (event.getButton() == 0 && KeyboardHelper.isScrollActivatorDown() && event.getAction() == 1) {
                this.commandEnter();
                event.setCanceled(true);
            }
            if (event.getButton() == 2 && KeyboardHelper.isScrollActivatorDown() && event.getAction() == 1) {
                this.commandSwapReaction();
                event.setCanceled(true);
            }
            if (event.getButton() == 1 && KeyboardHelper.isScrollActivatorDown() && event.getAction() == 1) {
                this.commandBack();
                event.setCanceled(true);
            }
        }
    }

    private void commandSwapReaction() {
        this.loadLists();
        if (this.reactionList != null && !this.reactionList.isEmpty()) {
            if (CommandMenuGui.reactionSelected < this.reactionList.size() - 1) {
                ++CommandMenuGui.reactionSelected;
            } else if (CommandMenuGui.reactionSelected >= this.reactionList.size() - 1) {
                CommandMenuGui.reactionSelected = 0;
            }
        }
    }

    private void reactionCommand() {
        this.loadLists();
        if (!this.reactionList.isEmpty()) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientPlayerEntity player = mc.field_71439_g;
            PacketHandler.sendToServer(new CSUseReactionCommandPacket(CommandMenuGui.reactionSelected));
            CommandMenuGui.reactionSelected = 0;
            player.field_70170_p.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
        }
    }

    @SubscribeEvent
    public void OnMouseWheelScroll(InputEvent.MouseScrollEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_195544_aj() && KeyboardHelper.isScrollActivatorDown()) {
            event.setCanceled(true);
            if (event.getScrollDelta() == -1.0) {
                this.commandDown();
            } else if (event.getScrollDelta() == 1.0) {
                this.commandUp();
            }
            return;
        }
    }

    public static RayTraceResult getMouseOverExtended(float dist) {
        Minecraft mc = Minecraft.func_71410_x();
        Entity theRenderViewEntity = mc.func_175606_aa();
        AxisAlignedBB theViewBoundingBox = new AxisAlignedBB(theRenderViewEntity.func_226277_ct_() - 0.5, theRenderViewEntity.func_226278_cu_() - 0.0, theRenderViewEntity.func_226281_cx_() - 0.5, theRenderViewEntity.func_226277_ct_() + 0.5, theRenderViewEntity.func_226278_cu_() + 1.5, theRenderViewEntity.func_226281_cx_() + 0.5);
        RayTraceResult returnMOP = null;
        if (mc.field_71441_e != null) {
            double var2 = dist;
            returnMOP = theRenderViewEntity.func_213324_a(var2, 0.0f, false);
            double calcdist = var2;
            Vector3d pos = theRenderViewEntity.func_174824_e(0.0f);
            var2 = calcdist;
            if (returnMOP != null) {
                calcdist = returnMOP.func_216347_e().func_72438_d(pos);
            }
            Vector3d lookvec = theRenderViewEntity.func_70676_i(0.0f);
            Vector3d var8 = pos.func_72441_c(lookvec.field_72450_a * var2, lookvec.field_72448_b * var2, lookvec.field_72449_c * var2);
            Entity pointedEntity = null;
            float var9 = 1.0f;
            List list = mc.field_71441_e.func_72839_b(theRenderViewEntity, theViewBoundingBox.func_72314_b(lookvec.field_72450_a * var2, lookvec.field_72448_b * var2, lookvec.field_72449_c * var2).func_72314_b((double)var9, (double)var9, (double)var9));
            double d = calcdist;
            for (Entity entity : list) {
                double d1;
                if (!entity.func_70067_L()) continue;
                float bordersize = entity.func_70111_Y();
                AxisAlignedBB aabb = new AxisAlignedBB(entity.func_226277_ct_() - (double)(entity.func_213311_cf() / 2.0f), entity.func_226278_cu_(), entity.func_226281_cx_() - (double)(entity.func_213311_cf() / 2.0f), entity.func_226277_ct_() + (double)(entity.func_213311_cf() / 2.0f), entity.func_226278_cu_() + (double)entity.func_213302_cg(), entity.func_226281_cx_() + (double)(entity.func_213311_cf() / 2.0f));
                aabb.func_72314_b((double)bordersize, (double)bordersize, (double)bordersize);
                Optional mop0 = aabb.func_216365_b(pos, var8);
                if (aabb.func_72318_a(pos)) {
                    if (!(0.0 < d) && d != 0.0) continue;
                    pointedEntity = entity;
                    d = 0.0;
                    continue;
                }
                if (mop0 == null || !mop0.isPresent() || !((d1 = pos.func_72438_d((Vector3d)mop0.get())) < d) && d != 0.0) continue;
                pointedEntity = entity;
                d = d1;
            }
            if (pointedEntity != null && (d < calcdist || returnMOP == null)) {
                returnMOP = new EntityRayTraceResult(pointedEntity);
            }
        }
        return returnMOP;
    }

    public void loadLists() {
        Minecraft mc = Minecraft.func_71410_x();
        IWorldCapabilities worldData = ModCapabilities.getWorld((World)mc.field_71441_e);
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)mc.field_71439_g);
        if (playerData != null && worldData != null) {
            this.driveFormsMap = Utils.getSortedDriveForms(playerData.getDriveFormMap());
            this.driveFormsMap.remove(DriveForm.NONE.toString());
            this.magicsMap = Utils.getSortedMAgics(playerData.getMagicsMap());
            this.portalCommands = worldData.getAllPortalsFromOwnerID(mc.field_71439_g.func_110124_au());
            this.limitsList = Utils.getPlayerLimitAttacks((PlayerEntity)mc.field_71439_g);
            if (ModCapabilities.getWorld((World)mc.field_71441_e).getPartyFromMember(mc.field_71439_g.func_110124_au()) != null) {
                this.targetsList = ModCapabilities.getWorld((World)mc.field_71441_e).getPartyFromMember(mc.field_71439_g.func_110124_au()).getMembers();
            }
            this.itemsList = Utils.getEquippedItems(playerData.getEquippedItems());
            this.reactionList = playerData.getReactionCommands();
        }
    }

    public static enum Keybinds {
        OPENMENU("key.kingdomkeys.openmenu", 77),
        SCROLL_UP("key.kingdomkeys.scrollup", 265),
        SCROLL_DOWN("key.kingdomkeys.scrolldown", 264),
        ENTER("key.kingdomkeys.enter", 262),
        BACK("key.kingdomkeys.back", 263),
        SCROLL_ACTIVATOR("key.kingdomkeys.scrollactivator", 342),
        SUMMON_KEYBLADE("key.kingdomkeys.summonkeyblade", 71),
        LOCK_ON("key.kingdomkeys.lockon", 90),
        SHOW_GUI("key.kingdomkeys.showgui", 79),
        ACTION("key.kingdomkeys.action", 88),
        REACTION_COMMAND("key.kingdomkeys.reactioncommand", 82);

        private final KeyBinding keybinding;

        private Keybinds(String name, int defaultKey) {
            this.keybinding = new KeyBinding(name, defaultKey, "key.categories.kingdomkeys");
        }

        public KeyBinding getKeybind() {
            return this.keybinding;
        }

        public boolean isPressed() {
            return this.keybinding.func_151468_f();
        }
    }
}

