/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.integration.corsair;

import dk.allanmc.cuesdk.CueSDK;
import dk.allanmc.cuesdk.DeviceInfo;
import dk.allanmc.cuesdk.enums.DeviceType;
import dk.allanmc.cuesdk.jna.CorsairLedColor;
import dk.allanmc.cuesdk.jna.CorsairLedPosition;
import dk.allanmc.cuesdk.jna.CorsairLedPositions;
import dk.allanmc.cuesdk.jna.CueSDKLibrary;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.world.World;
import online.kingdomkeys.kingdomkeys.integration.corsair.functions.KeyFunction;
import online.kingdomkeys.kingdomkeys.integration.corsair.lib.CorsairUtils;
import online.kingdomkeys.kingdomkeys.integration.corsair.lib.KeyEnum;

public class KeyboardManager {
    private final Thread updateThread = new Thread(this::updateKeys);
    private CueSDK cue = new CueSDK(false);
    private CueSDKLibrary cueSDK;
    public static boolean corsairKeyboard = false;
    int test = 0;
    boolean fadingOut = false;

    public KeyboardManager() {
        for (int i = 0; i < this.cue.getDeviceCount(); ++i) {
            DeviceInfo info = this.cue.getDeviceInfo(i);
            if (info.getType() != DeviceType.CDT_Keyboard) continue;
            corsairKeyboard = true;
        }
        if (corsairKeyboard) {
            this.updateThread.setDaemon(true);
            this.updateThread.setPriority(3);
            this.updateThread.start();
            try {
                Field cueSDKField = CueSDK.class.getDeclaredField("instance");
                cueSDKField.setAccessible(true);
                this.cueSDK = (CueSDKLibrary)cueSDKField.get(this.cue);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Failed to reflect CueSDK", e);
            }
        }
    }

    public void resetKeyboard() {
        if (!corsairKeyboard) {
            return;
        }
        for (KeyEnum key : this.getKeyEnums()) {
            key.setShouldUpdate(true);
            CorsairLedColor color = new CorsairLedColor();
            color.ledId = key.ordinal();
            color.r = CorsairUtils.defaultRGB[0];
            color.g = CorsairUtils.defaultRGB[1];
            color.b = CorsairUtils.defaultRGB[2];
            this.cueSDK.CorsairSetLedsColorsAsync(1, color, null, null);
        }
    }

    public void setDefaultColor(int[] colors) {
        if (!corsairKeyboard) {
            return;
        }
        if (!CorsairUtils.isEqualsArray(CorsairUtils.defaultRGB, colors)) {
            CorsairUtils.defaultRGB = colors;
            this.resetKeyboard();
        }
    }

    public void showLogo() {
        if (!corsairKeyboard) {
            return;
        }
        for (KeyEnum key : this.getKeyEnums()) {
            CorsairLedColor color = new CorsairLedColor();
            if (CorsairUtils.orange.contains((Object)key)) {
                color.r = 255;
                color.g = 150;
                color.b = 0;
            } else if (CorsairUtils.brown.contains((Object)key)) {
                color.r = 100;
                color.g = 40;
                color.b = 0;
            } else if (CorsairUtils.gray.contains((Object)key)) {
                color.r = 160;
                color.g = 160;
                color.b = 160;
            } else if (CorsairUtils.blue.contains((Object)key)) {
                color.r = 0;
                color.g = 100;
                color.b = 255;
            } else if (CorsairUtils.yellow.contains((Object)key)) {
                color.r = 255;
                color.g = 215;
                color.b = 0;
            }
            color.ledId = key.ordinal();
            this.cueSDK.CorsairSetLedsColorsAsync(1, color, null, null);
        }
    }

    void updateKeys() {
        if (!corsairKeyboard) {
            return;
        }
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
    }

    private void lightFunction(KeyFunction keyFunction, KeyEnum key) {
        if (!corsairKeyboard) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        int[] rgbValue = keyFunction.getCallback().invoke(key, minecraft, (World)minecraft.field_71441_e, minecraft.field_71439_g);
        int[] lastColor = key.getLastColor();
        if (key.getShouldUpdate() || !CorsairUtils.isEqualsArray(lastColor, rgbValue)) {
            key.setShouldUpdate(false);
            CorsairLedColor color = new CorsairLedColor();
            key.setLastColor(rgbValue);
            color.ledId = key.ordinal();
            color.r = rgbValue[0];
            color.g = rgbValue[1];
            color.b = rgbValue[2];
            this.cueSDK.CorsairSetLedsColorsAsync(1, color, null, null);
        }
    }

    private void lightKey(KeyEnum key, int[] colors) {
        if (!corsairKeyboard) {
            return;
        }
        this.lightKey(key, colors[0], colors[1], colors[2]);
    }

    private void lightKey(final KeyEnum key, final int r, final int g, final int b) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                CorsairLedColor color = new CorsairLedColor();
                color.ledId = key.ordinal();
                color.r = r;
                color.g = g;
                color.b = b;
                KeyboardManager.this.cueSDK.CorsairSetLedsColorsAsync(1, color, null, null);
            }
        });
        t.start();
    }

    private void lightKeys(KeyEnum[] keys, int[] colors) {
        if (!corsairKeyboard) {
            return;
        }
        this.lightKeys(keys, colors[0], colors[1], colors[2]);
    }

    private void lightKeys(final KeyEnum[] keys, final int r, final int g, final int b) {
        if (!corsairKeyboard) {
            return;
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                for (KeyEnum key : keys) {
                    CorsairLedColor color = new CorsairLedColor();
                    color.ledId = key.ordinal();
                    color.r = r;
                    color.g = g;
                    color.b = b;
                    KeyboardManager.this.cueSDK.CorsairSetLedsColorsAsync(1, color, null, null);
                }
            }
        });
        t.start();
    }

    private void lightKeyAndReturn(final KeyEnum key, final int r, final int g, final int b, final int time) {
        if (!corsairKeyboard) {
            return;
        }
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                CorsairLedColor color = new CorsairLedColor();
                color.ledId = key.ordinal();
                color.r = r;
                color.g = g;
                color.b = b;
                KeyboardManager.this.cueSDK.CorsairSetLedsColorsAsync(1, color, null, null);
                try {
                    Thread.sleep(time);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    color = new CorsairLedColor();
                    color.ledId = key.ordinal();
                    color.r = CorsairUtils.defaultRGB[0];
                    color.g = CorsairUtils.defaultRGB[1];
                    color.b = CorsairUtils.defaultRGB[2];
                    KeyboardManager.this.cueSDK.CorsairSetLedsColorsAsync(1, color, null, null);
                }
            }
        });
        t.start();
    }

    private void lightKeysAndReturn(final KeyEnum[] keys, final int r, final int g, final int b, final int time) {
        if (!corsairKeyboard) {
            return;
        }
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                CorsairLedColor color;
                for (KeyEnum key : keys) {
                    color = new CorsairLedColor();
                    color.ledId = key.ordinal();
                    color.r = r;
                    color.g = g;
                    color.b = b;
                    KeyboardManager.this.cueSDK.CorsairSetLedsColorsAsync(1, color, null, null);
                }
                try {
                    Thread.sleep(time);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    for (KeyEnum key : keys) {
                        color = new CorsairLedColor();
                        color.ledId = key.ordinal();
                        color.r = CorsairUtils.defaultRGB[0];
                        color.g = CorsairUtils.defaultRGB[1];
                        color.b = CorsairUtils.defaultRGB[2];
                        KeyboardManager.this.cueSDK.CorsairSetLedsColorsAsync(1, color, null, null);
                    }
                }
            }
        });
        t.start();
    }

    List<KeyEnum> getKeyEnums() {
        return this.getKeys().stream().map(key -> KeyEnum.values()[((Key)key).id]).collect(Collectors.toList());
    }

    public List<Key> getKeys() {
        CorsairLedPositions keyPositions = this.cueSDK.CorsairGetLedPositions();
        int count = keyPositions.numberOfLed;
        CorsairLedPosition[] positionArray = (CorsairLedPosition[])keyPositions.pLedPosition.toArray(count);
        ArrayList<Key> keys = new ArrayList<Key>();
        for (CorsairLedPosition position : positionArray) {
            keys.add(new Key(position.ledId, position.top, position.left, position.height, position.width));
        }
        return keys;
    }

    public static class Key {
        private final int id;
        private final double top;
        private final double left;
        private final double height;
        private final double width;
        private final KeyEnum keyEnum;

        Key(int id, double top, double left, double height, double width) {
            this.id = id;
            this.top = top;
            this.left = left;
            this.height = height;
            this.width = width;
            this.keyEnum = KeyEnum.values()[id];
        }

        public int getId() {
            return this.id;
        }

        public double getTop() {
            return this.top;
        }

        public double getLeft() {
            return this.left;
        }

        public double getHeight() {
            return this.height;
        }

        public double getWidth() {
            return this.width;
        }

        public KeyEnum getKeyEnum() {
            return this.keyEnum;
        }
    }
}

