/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class KKPotionItem
extends Item
implements IItemCategory {
    PotionType type;
    double amount;
    boolean percentage;
    boolean all;

    public KKPotionItem(Item.Properties properties, PotionType type, double amount, boolean perc, boolean all) {
        super(properties);
        this.type = type;
        this.amount = amount;
        this.percentage = perc;
        this.all = all;
    }

    public void potionEffect(PlayerEntity player) {
        switch (this.type) {
            case HP: {
                IWorldCapabilities worldData;
                Party party;
                float hpAmount = (float)(this.percentage ? (double)player.func_110138_aP() * this.amount / 100.0 : this.amount);
                player.func_70691_i(hpAmount);
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)ModSounds.potion.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (!this.all || (party = (worldData = ModCapabilities.getWorld(player.field_70170_p)).getPartyFromMember(player.func_110124_au())) == null) break;
                for (Party.Member m : party.getMembers()) {
                    PlayerEntity target;
                    if (m.getUUID().equals(player.func_110124_au()) || !((target = player.field_70170_p.func_217371_b(m.getUUID())).func_70032_d((Entity)player) < (float)ModConfigs.partyRangeLimit)) continue;
                    hpAmount = (float)(this.percentage ? (double)target.func_110138_aP() * this.amount / 100.0 : this.amount);
                    target.func_70691_i(hpAmount);
                    player.field_70170_p.func_184133_a(null, target.func_233580_cy_(), (SoundEvent)ModSounds.potion.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
                break;
            }
            case MP: {
                IWorldCapabilities worldData;
                Party party;
                IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
                float mpAmount = (float)(this.percentage ? playerData.getMaxMP() * this.amount / 100.0 : this.amount);
                playerData.addMP(mpAmount);
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)ModSounds.potion.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (this.all && (party = (worldData = ModCapabilities.getWorld(player.field_70170_p)).getPartyFromMember(player.func_110124_au())) != null) {
                    for (Party.Member m : party.getMembers()) {
                        if (m.getUUID().equals(player.func_110124_au())) continue;
                        PlayerEntity target = player.field_70170_p.func_217371_b(m.getUUID());
                        IPlayerCapabilities targetData = ModCapabilities.getPlayer(target);
                        if (target.func_70032_d((Entity)player) < (float)ModConfigs.partyRangeLimit) {
                            mpAmount = (float)(this.percentage ? targetData.getMaxMP() * this.amount / 100.0 : this.amount);
                            targetData.addMP(mpAmount);
                            player.field_70170_p.func_184133_a(null, target.func_233580_cy_(), (SoundEvent)ModSounds.potion.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                        }
                        PacketHandler.syncToAllAround(target, targetData);
                    }
                }
                PacketHandler.syncToAllAround(player, playerData);
                break;
            }
            case HPMP: {
                IWorldCapabilities worldData;
                Party party;
                IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
                float mpAmount = (float)(this.percentage ? playerData.getMaxMP() * this.amount / 100.0 : this.amount);
                float hpAmount = (float)(this.percentage ? (double)player.func_110138_aP() * this.amount / 100.0 : this.amount);
                playerData.addMP(mpAmount);
                player.func_70691_i(hpAmount);
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)ModSounds.potion.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (this.all && (party = (worldData = ModCapabilities.getWorld(player.field_70170_p)).getPartyFromMember(player.func_110124_au())) != null) {
                    for (Party.Member m : party.getMembers()) {
                        if (m.getUUID().equals(player.func_110124_au())) continue;
                        PlayerEntity target = player.field_70170_p.func_217371_b(m.getUUID());
                        IPlayerCapabilities targetData = ModCapabilities.getPlayer(target);
                        if (target.func_70032_d((Entity)player) < (float)ModConfigs.partyRangeLimit) {
                            mpAmount = (float)(this.percentage ? targetData.getMaxMP() * this.amount / 100.0 : this.amount);
                            hpAmount = (float)(this.percentage ? (double)target.func_110138_aP() * this.amount / 100.0 : this.amount);
                            targetData.addMP(mpAmount);
                            target.func_70691_i(hpAmount);
                            player.field_70170_p.func_184133_a(null, target.func_233580_cy_(), (SoundEvent)ModSounds.potion.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                        }
                        PacketHandler.syncToAllAround(target, targetData);
                    }
                }
                PacketHandler.syncToAllAround(player, playerData);
                break;
            }
            case DRIVE: {
                IWorldCapabilities worldData;
                Party party;
                IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
                float dpAmount = (float)(this.percentage ? playerData.getMaxDP() * this.amount / 100.0 : this.amount);
                playerData.addDP(dpAmount);
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)ModSounds.potion.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (this.all && (party = (worldData = ModCapabilities.getWorld(player.field_70170_p)).getPartyFromMember(player.func_110124_au())) != null) {
                    for (Party.Member m : party.getMembers()) {
                        if (m.getUUID().equals(player.func_110124_au())) continue;
                        PlayerEntity target = player.field_70170_p.func_217371_b(m.getUUID());
                        IPlayerCapabilities targetData = ModCapabilities.getPlayer(target);
                        if (target.func_70032_d((Entity)player) < (float)ModConfigs.partyRangeLimit) {
                            dpAmount = (float)(this.percentage ? targetData.getMaxDP() * this.amount / 100.0 : this.amount);
                            targetData.addDP(dpAmount);
                            player.field_70170_p.func_184133_a(null, target.func_233580_cy_(), (SoundEvent)ModSounds.potion.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                        }
                        PacketHandler.syncToAllAround(target, targetData);
                    }
                }
                PacketHandler.syncToAllAround(player, playerData);
                break;
            }
            case FOCUS: {
                IWorldCapabilities worldData;
                Party party;
                IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
                float focusAmount = (float)(this.percentage ? playerData.getMaxFocus() * this.amount / 100.0 : this.amount);
                playerData.addFocus(focusAmount);
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), (SoundEvent)ModSounds.potion.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (this.all && (party = (worldData = ModCapabilities.getWorld(player.field_70170_p)).getPartyFromMember(player.func_110124_au())) != null) {
                    for (Party.Member m : party.getMembers()) {
                        if (m.getUUID().equals(player.func_110124_au())) continue;
                        PlayerEntity target = player.field_70170_p.func_217371_b(m.getUUID());
                        IPlayerCapabilities targetData = ModCapabilities.getPlayer(target);
                        if (target.func_70032_d((Entity)player) < (float)ModConfigs.partyRangeLimit) {
                            focusAmount = (float)(this.percentage ? targetData.getMaxFocus() * this.amount / 100.0 : this.amount);
                            targetData.addFocus(focusAmount);
                            player.field_70170_p.func_184133_a(null, target.func_233580_cy_(), (SoundEvent)ModSounds.potion.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                        }
                        PacketHandler.syncToAllAround(target, targetData);
                    }
                }
                PacketHandler.syncToAllAround(player, playerData);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String sType = Utils.translateToLocal("potion.desc." + this.type.toString().toLowerCase(), new Object[0]);
        String beginning = Utils.translateToLocal("potion.desc.beginning", (int)this.amount, this.percentage ? "%" : "", sType);
        String end = Utils.translateToLocal(this.all ? "potion.desc.toall" : "potion.desc.toone", new Object[0]);
        tooltip.add((ITextComponent)new TranslationTextComponent(beginning + end));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    @Override
    public ItemCategory getCategory() {
        return ItemCategory.CONSUMABLE;
    }

    public boolean isGlobal() {
        return this.all;
    }

    public static enum PotionType {
        HP,
        MP,
        HPMP,
        DRIVE,
        FOCUS;

    }
}

