/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.IKeychain;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.KeybladeItemTier;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;

public class KeychainItem
extends SwordItem
implements IKeychain,
IItemCategory {
    KeybladeItem keyblade;

    public KeychainItem() {
        super((IItemTier)new KeybladeItemTier(0.0f), 0, 0.0f, new Item.Properties().func_200916_a(KingdomKeys.keybladesGroup).func_200917_a(1));
    }

    public void setKeyblade(KeybladeItem kb) {
        this.keyblade = kb;
    }

    public KeybladeItem getKeyblade() {
        return this.keyblade;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (stack.func_77978_p() != null) {
            if (!stack.func_77978_p().func_186855_b("keybladeID")) {
                stack.func_77982_d(this.setID(stack.func_77978_p()));
            }
        } else {
            stack.func_77982_d(this.setID(new CompoundNBT()));
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public CompoundNBT setID(CompoundNBT nbt) {
        nbt.func_186854_a("keybladeID", UUID.randomUUID());
        return nbt;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        return super.func_77659_a(world, player, hand);
    }

    public int getKeybladeLevel(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("level")) {
            return stack.func_77978_p().func_74762_e("level");
        }
        return 0;
    }

    public void setKeybladeLevel(ItemStack stack, int level) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_74768_a("level", level);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.getKeyblade() != null && this.getKeyblade().data != null) {
            if (this.getKeyblade().getKeybladeLevel(stack) > 0) {
                tooltip.add((ITextComponent)new TranslationTextComponent(TextFormatting.YELLOW + "Level %s", new Object[]{this.getKeyblade().getKeybladeLevel(stack)}));
            }
            tooltip.add((ITextComponent)new TranslationTextComponent(TextFormatting.RED + "Strength %s", new Object[]{(float)this.getKeyblade().getStrength(this.getKeybladeLevel(stack)) + DamageCalculation.getSharpnessDamage(stack) + " [" + DamageCalculation.getKBStrengthDamage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, stack) + "]"}));
            tooltip.add((ITextComponent)new TranslationTextComponent(TextFormatting.BLUE + "Magic %s", new Object[]{this.getKeyblade().getMagic(this.getKeybladeLevel(stack)) + " [" + DamageCalculation.getMagicDamage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, stack) + "]"}));
            tooltip.add((ITextComponent)new TranslationTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + this.getKeyblade().getDescription()));
        }
        if (flagIn.func_194127_a() && stack.func_77978_p() != null && stack.func_77978_p().func_186855_b("keybladeID")) {
            tooltip.add((ITextComponent)new TranslationTextComponent(TextFormatting.RED + "DEBUG:"));
            tooltip.add((ITextComponent)new TranslationTextComponent(TextFormatting.WHITE + stack.func_77978_p().func_186857_a("keybladeID").toString()));
        }
    }

    @Override
    public KeybladeItem toSummon() {
        return this.keyblade;
    }

    @Override
    public ItemCategory getCategory() {
        return ItemCategory.TOOL;
    }
}

