/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class RecipeItem
extends Item
implements IItemCategory {
    public RecipeItem(Item.Properties properties) {
        super(properties);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        if (hand == Hand.MAIN_HAND && !world.field_72995_K) {
            ItemStack stack = player.func_184614_ca();
            if (stack.func_77942_o()) {
                String[] recipes = new String[]{stack.func_77978_p().func_74779_i("recipe1"), stack.func_77978_p().func_74779_i("recipe2"), stack.func_77978_p().func_74779_i("recipe3")};
                IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
                boolean consume = false;
                for (String recipe : recipes) {
                    String message;
                    ResourceLocation rl = new ResourceLocation(recipe);
                    if (!RecipeRegistry.getInstance().containsKey(rl)) continue;
                    ItemStack outputStack = new ItemStack((IItemProvider)RecipeRegistry.getInstance().getValue(rl).getResult());
                    if (recipe == null || !RecipeRegistry.getInstance().containsKey(rl)) {
                        message = "ERROR: Recipe for " + Utils.translateToLocal(rl.toString(), new Object[0]) + " was not learnt because it is not a valid recipe, Report this to a dev";
                        player.func_145747_a((ITextComponent)new TranslationTextComponent(TextFormatting.RED + message), Util.field_240973_b_);
                        continue;
                    }
                    if (playerData.hasKnownRecipe(rl)) {
                        message = "Recipe for " + Utils.translateToLocal(outputStack.func_77977_a(), new Object[0]) + " already learnt";
                        player.func_145747_a((ITextComponent)new TranslationTextComponent(TextFormatting.YELLOW + message), Util.field_240973_b_);
                        continue;
                    }
                    playerData.addKnownRecipe(rl);
                    consume = true;
                    message = "Recipe " + Utils.translateToLocal(outputStack.func_77977_a(), new Object[0]) + " learnt successfully";
                    player.func_145747_a((ITextComponent)new TranslationTextComponent(TextFormatting.GREEN + message), Util.field_240973_b_);
                    PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), (ServerPlayerEntity)player);
                }
                if (consume) {
                    player.func_184614_ca().func_190918_g(1);
                } else {
                    this.shuffleRecipes(stack, player);
                }
            } else {
                player.func_146105_b((ITextComponent)new TranslationTextComponent("Opened recipe"), true);
                this.shuffleRecipes(stack, player);
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public void shuffleRecipes(ItemStack stack, PlayerEntity player) {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
        ResourceLocation recipe1 = null;
        ResourceLocation recipe2 = null;
        ResourceLocation recipe3 = null;
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>();
        for (Recipe r : RecipeRegistry.getInstance().getValues()) {
            if (playerData.hasKnownRecipe(r.getRegistryName()) || !r.getType().equals("keyblade")) continue;
            list.add(r.getRegistryName());
        }
        if (list.size() == 0) {
            return;
        }
        if (list.size() > 0) {
            recipe1 = (ResourceLocation)list.get(Utils.randomWithRange(0, list.size() - 1));
        }
        if (list.size() > 1) {
            while ((recipe2 = (ResourceLocation)list.get(Utils.randomWithRange(0, list.size() - 1))) == recipe1) {
            }
        }
        if (list.size() > 2) {
            while ((recipe3 = (ResourceLocation)list.get(Utils.randomWithRange(0, list.size() - 1))) == recipe1 || recipe3 == recipe2) {
            }
        }
        stack.func_77982_d(new CompoundNBT());
        if (recipe1 != null) {
            stack.func_77978_p().func_74778_a("recipe1", recipe1.toString());
        }
        if (recipe2 != null) {
            stack.func_77978_p().func_74778_a("recipe2", recipe2.toString());
        }
        if (recipe3 != null) {
            stack.func_77978_p().func_74778_a("recipe3", recipe3.toString());
        }
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (stack.func_77942_o()) {
            for (int i = 1; i <= 3; ++i) {
                String name;
                Recipe recipe;
                String recipeName = stack.func_77978_p().func_74779_i("recipe" + i);
                if (!RecipeRegistry.getInstance().containsKey(new ResourceLocation(recipeName)) || (recipe = RecipeRegistry.getInstance().getValue(new ResourceLocation(recipeName))) == null) continue;
                if (recipe.getType().equals("keyblade")) {
                    KeychainItem item = (KeychainItem)recipe.getResult().getItem();
                    name = new ItemStack((IItemProvider)item.keyblade).func_77977_a();
                } else {
                    name = new ItemStack((IItemProvider)recipe.getResult()).func_77977_a();
                }
                tooltip.add((ITextComponent)new TranslationTextComponent(Utils.translateToLocal(name, new Object[0])));
            }
        }
    }

    @Override
    public ItemCategory getCategory() {
        return ItemCategory.MISC;
    }
}

