/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CSPartySettings {
    String name;
    boolean priv;
    byte size;
    boolean friendlyFire;

    public CSPartySettings() {
    }

    public CSPartySettings(Party party) {
        this.name = party.getName();
        this.priv = party.getPriv();
        this.size = party.getSize();
        this.friendlyFire = party.getFriendlyFire();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.name.length());
        buffer.func_180714_a(this.name);
        buffer.writeBoolean(this.priv);
        buffer.writeByte((int)this.size);
        buffer.writeBoolean(this.friendlyFire);
    }

    public static CSPartySettings decode(PacketBuffer buffer) {
        CSPartySettings msg = new CSPartySettings();
        int length = buffer.readInt();
        msg.name = buffer.func_150789_c(length);
        msg.priv = buffer.readBoolean();
        msg.size = buffer.readByte();
        msg.friendlyFire = buffer.readBoolean();
        return msg;
    }

    public static void handle(CSPartySettings message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            IWorldCapabilities worldData = ModCapabilities.getWorld(player.field_70170_p);
            Party p = worldData.getPartyFromName(message.name);
            p.setPriv(message.priv);
            p.setSize(message.size);
            p.setFriendlyFire(message.friendlyFire);
            Utils.syncWorldData(player.field_70170_p, worldData);
        });
        ctx.get().setPacketHandled(true);
    }
}

