/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import online.kingdomkeys.kingdomkeys.world.utils.BaseTeleporter;

public class CSSetChoice {
    SoAState state;
    SoAState choice;
    BlockPos pedestal;
    boolean confirm = false;

    public CSSetChoice() {
    }

    public CSSetChoice(SoAState state, SoAState choice, BlockPos pedestal) {
        this.state = state;
        this.choice = choice;
        this.pedestal = pedestal;
    }

    public CSSetChoice(SoAState state, boolean confirm) {
        this(state, SoAState.NONE, null);
        this.confirm = confirm;
        this.pedestal = new BlockPos(0, 0, 0);
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeByte((int)this.state.get());
        buffer.writeByte((int)this.choice.get());
        buffer.writeBoolean(this.confirm);
        buffer.func_179255_a(this.pedestal);
    }

    public static CSSetChoice decode(PacketBuffer buffer) {
        CSSetChoice msg = new CSSetChoice();
        msg.state = SoAState.fromByte(buffer.readByte());
        msg.choice = SoAState.fromByte(buffer.readByte());
        msg.confirm = buffer.readBoolean();
        msg.pedestal = buffer.func_179259_c();
        return msg;
    }

    public static void handle(CSSetChoice message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
            if (message.state == SoAState.CONFIRM) {
                if (message.confirm) {
                    playerData.setSoAState(SoAState.COMPLETE);
                    ServerWorld dimension = player.field_70170_p.func_73046_m().func_71218_a(playerData.getReturnDimension());
                    player.changeDimension(dimension, (ITeleporter)new BaseTeleporter(playerData.getReturnLocation().field_72450_a, playerData.getReturnLocation().field_72448_b, playerData.getReturnLocation().field_72449_c));
                    SoAState.applyStatsForChoices(playerData);
                } else {
                    playerData.setChoicePedestal(new BlockPos(0, 0, 0));
                    playerData.setSacrificePedestal(new BlockPos(0, 0, 0));
                    playerData.setChoice(SoAState.NONE);
                    playerData.setSacrifice(SoAState.NONE);
                    playerData.setSoAState(SoAState.CHOICE);
                }
            } else if (message.state == SoAState.CHOICE) {
                playerData.setChoicePedestal(message.pedestal);
                playerData.setChoice(message.choice);
                playerData.setSoAState(SoAState.SACRIFICE);
            } else if (message.state == SoAState.SACRIFICE) {
                playerData.setSacrificePedestal(message.pedestal);
                playerData.setSacrifice(message.choice);
                playerData.setSoAState(SoAState.CONFIRM);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

